using System;
using System.Windows.Forms;
using XdsObjects;

namespace LicenceManipulation
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();            
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            Text += $"        XdsObjects.v {XdsGlobal.FileVersion}";
            // this helps trouble-shoot license problems
            XdsGlobal.SetRegWord("LogMachineIDInfo", 1);

            // if there is a problem with the license activation, send us the log for checking
            // you should find the D.O.Net.xxx.log in the LicenceManipulation.exe folder 
            XdsGlobal.LogToFile(Environment.CurrentDirectory, XdsObjects.Enums.LogLevel.All);

            FillBox();
        }

        private void FillBox()
        {
            licenseList.Items.Clear();

            mode.Text = Environment.Is64BitProcess ? "64 bit mode" : "32 bit mode";
            // DicomLicensne.MachineID is generated by DicomObjects to uniquely identifies each machine
            // MachineID might change due to hardware changes, but should not change after Windows update
            machineID.Text = "MachineID = " + XdsLicense.MachineID.ToString();
                   
            // list all DicomObjects licenses found on the machine, including expired ones    
            foreach (XdsLicense l in XdsLicense.InstalledLicenses)
            {                
                var item = new ListViewItem(l.LicenseType.ToString());
                item.Tag = l;
                item.SubItems.Add(l.Expiry.ToString("D"));
                item.SubItems.Add(l.LicenseID.ToString());
                item.SubItems.Add(l.AuthorisationID.ToString());
                item.ForeColor = (l.Expiry < DateTime.Now)?System.Drawing.Color.Red: System.Drawing.Color.Green;

                licenseList.Items.Add(item);
            }
        }

        private void GetLicenseBTN_Click(object sender, EventArgs e)
        {
            newTooltip().SetToolTip(XdsLicense.Dialog.AuthorisationString, "Enter your License Key in XXXX-YYYY-ZZZZ format");
            newTooltip().SetToolTip(XdsLicense.Dialog.CustomerInfo1, "Enter the licensee's Name or ID etc.");
            newTooltip().SetToolTip(XdsLicense.Dialog.CustomerInfo2, "Enter other information that can identify the licensee");
            XdsLicense.Dialog.ShowDialog();
            FillBox();
        }

        private ToolTip newTooltip()
        {
            return new ToolTip()
            {
                ShowAlways = true,
                ReshowDelay= 0,                 
            };            
        }

        private void DeleteAllLicenseBTN_Click(object sender, EventArgs e)
        {
            deleteAllLicenses();
        }
        
        private void DeleteSelectedBTN_Click(object sender, EventArgs e)
        {
            deleteSelectedLicense();
        }

        private void licenseDetailsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (licenseList.SelectedItems.Count > 0)
            {
                XdsLicense l = licenseList.SelectedItems[0].Tag as XdsLicense;
                MessageBox.Show(getLicenseDetails(l), "License Details");
            }
        }

        private void deleteLicenseToolStripMenuItem_Click(object sender, EventArgs e)
        {
            deleteSelectedLicense();
        }

        private void deActivateAllLicensesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            deleteAllLicenses();
        }

        private void deleteSelectedLicense()
        {
            if (licenseList.SelectedItems.Count > 0)
            {
                XdsLicense l = licenseList.SelectedItems[0].Tag as XdsLicense;
                if (MessageBox.Show("Are you really sure?", "Delete Selected?", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation) == DialogResult.Yes)
                {
                    l.Delete();
                    FillBox();
                }
            }
        }

        private void deleteAllLicenses()
        {
            if (licenseList.Items.Count > 0)
            {
                UserInfoPrompt dlg = new UserInfoPrompt();
                if (dlg.ShowDialog() == DialogResult.OK 
                    && !string.IsNullOrEmpty(dlg.CustomerInfo1) 
                    && !string.IsNullOrEmpty(dlg.CustomerInfo2))
                {
                    string res;
                    res = XdsLicense.DeactivateOnline(dlg.CustomerInfo1, dlg.CustomerInfo2);
                    MessageBox.Show(res, "Deactivation result", MessageBoxButtons.OK);
                    FillBox();
                }
            }
        }

        private string getLicenseDetails(XdsLicense l)
        {
            return $@"Allowed Functions: {l.AllowedFunctions}{Environment.NewLine}
                    AuthorisationID:  {l.AuthorisationID}{Environment.NewLine}
                    Enpiry Date:  {l.Expiry.ToString("D")}{Environment.NewLine}
                    License ID:   {l.LicenseID}{Environment.NewLine}
                    License Token: {l.LicenseToken}{Environment.NewLine}
                    License Type: {l.LicenseType}{Environment.NewLine}";
        }
        
    }
}