﻿using System;
using System.IO;
using System.Net;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using XdsObjects;
using XdsObjects.Enums;

namespace XDS_Document_Source_Consumer__Advanced_Version_
{
    public partial class DocSourceForm : Form
    {
        public DocSourceForm()
        {
            InitializeComponent();
        }

        #region "Variables"
        private XdsDomain xds;
        private DocConsumer consumerForm;
        #endregion

        #region "Set up routine"
        private void Setup()
        {
            // Start logging
            XdsGlobal.LogToFile(@"C:\Xds Log Files", LogLevel.FullXmlIn | LogLevel.FullXmlOut, 60);

            // The repository address - where to send the document to
            xds = new XdsDomain();
            xds.SubmissionRepositoryEndpoint = new WebServiceEndpoint("http://localhost:8080/MyRepository");

            // Load the codes from external XML file
            XmlDocument codes = new XmlDocument();
            codes.Load(Application.StartupPath + @"\..\..\Files\codes.xml");

            // Populate the codes into dropdown boxes for user to select
            PopulateComboBox(codes, "typeCode", PRDocTypeCodeComboBox);
            PopulateComboBox(codes, "contentTypeCode", PRssContentType);
            PopulateComboBox(codes, "classCode", PRDocClassCodeComboBox);
            PopulateComboBox(codes, "confidentialityCode", PRDocConfidCodeComboBox);
            PopulateComboBox(codes, "healthcareFacilityTypeCode", PRDocHCFTCodeComboBox);
            PopulateComboBox(codes, "practiceSettingCode", PRDocPracSetCodeComboBox);
            PopulateComboBox(codes, "formatCode", PRDocFormatCodeComboBox);

            // Display Repository Address and its UID
            RepAddrText.Text = "http://localhost:8080/MyRepository";
            RepUIDText.Text = "1.19.6.24.109.42.1.5";

            // Sample UID for this document source
            SourceIDText.Text = "1.3.6.1.4.1.21367.1234567";

            if (string.IsNullOrEmpty(Properties.Settings.Default.PatientIDExtension))
                GetNewPatientID();
            else
            {
                PRpIDRootText.Text = Properties.Settings.Default.PatientIDRoot;
                PRpIDExtText.Text = Properties.Settings.Default.PatientIDExtension;
            }

            consumerForm = new DocConsumer();
        }
        #endregion

        #region "UI Handler"
        private void DocSourceForm_Load(object sender, EventArgs e)
        {
            Setup();
        }

        private void PopulateComboBox(XmlDocument codes, string name, ComboBox box)
        {
            XmlNodeList q = codes.SelectNodes("/Codes/CodeType[@name='" + name + "']/Code");

            foreach (XmlNode qq in q)
            {
                box.Items.Add(new XdsCode(qq.Attributes["codingScheme"].Value, qq.Attributes["code"].Value, qq.Attributes["display"].Value));
            }
            box.SelectedItem = box.Items[0];
        }

        /// <summary>
        /// Select document to be submitted
        /// </summary>        
        private void PRBrowseDocumentBTN_Click(object sender, EventArgs e)
        {
            OpenFileDialog dlg = new OpenFileDialog();
            dlg.FileName = "";
            dlg.Title = "Load Document";
            dlg.ShowDialog();
            if (dlg.FileName != "")
                FilePathText.Text = dlg.FileName;
        }

        /// <summary>
        /// Send document to Repository
        /// </summary>        
        private void SubmitBTN_Click(object sender, EventArgs e)
        {
            if (!string.IsNullOrEmpty(FilePathText.Text))
            {
                SubmitDocument();
                consumerForm.PIDText.Text = Properties.Settings.Default.PatientIDExtension + "^^^&" + Properties.Settings.Default.PatientIDRoot + "&ISO";
                consumerForm.ShowDialog();
            }
            else
                MessageBox.Show("Load a Document First");
        }

        /// <summary>
        /// Get a new Patient ID from the NIST patient allocation web service
        /// </summary>
        private void NewPatientBTN_Click(object sender, EventArgs e)
        {
            GetNewPatientID();
        }

        /// <summary>
        /// Get a new Patient ID from the NIST patient allocation web service
        /// </summary>
        private void GetNewPatientID()
        {
            // Public NIST patient allocation web wervice
            // Check the following webpage to see what it does
            string NISTService = "http://ihexds.nist.gov:12080/xdstools/pidallocate";
            string AssigningAuthority = "&1.3.6.1.4.1.21367.2005.3.7&ISO";

            HttpWebRequest r = (HttpWebRequest)WebRequest.Create(NISTService);
            r.Method = "POST";
            byte[] byteArray = Encoding.UTF8.GetBytes("aa=" + System.Web.HttpUtility.UrlEncode(AssigningAuthority));
            r.ContentType = "application/x-www-form-urlencoded";
            r.GetRequestStream().Write(byteArray, 0, byteArray.Length);
            r.GetRequestStream().Close();
            StreamReader sr = new StreamReader(r.GetResponse().GetResponseStream());

            string[] lines = sr.ReadToEnd().Split(new char[] { '\n' });

            //We have a new PatientID
            // Strip the new PatientID into Root and Extension
            string patientID = lines[lines.Length - 2];
            PRpIDExtText.Text = patientID.Substring(0, patientID.IndexOf("^"));
            Properties.Settings.Default.PatientIDExtension = PRpIDExtText.Text;

            string[] ss = patientID.Split(new char[] { '&' });
            PRpIDRootText.Text = ss[1];
            Properties.Settings.Default.PatientIDRoot = ss[1];
        }
        #endregion

        #region "Document Submission"
        private void SubmitDocument()
        {
            // Create a new Patient
            XdsPatient patient = new XdsPatient();
            patient.Prefix = PRpTitleText.Text;
            patient.FamilyName = PRpSurnameName.Text;
            patient.GivenName = PRpGivenName.Text;
            patient.Sex = PRpSex.Text;
            patient.DOB = Convert.ToDateTime(PRpDOB.Text);
            patient.Address = PRpAddrText.Text;

            // Format of Full Patient ID - Extension^^^&Root&ISO 
            patient.ID_Root = PRpIDRootText.Text;
            patient.ID_Extension = PRpIDExtText.Text;

            // Create a new SubmissionSet
            XdsSubmissionSet ss = new XdsSubmissionSet();
            ss.PatientInfo = patient;
            ss.Authors.Add(new XdsAuthor(PRAutNameText.Text, new XdsMultiString(PRAutInstText.Lines), new XdsMultiString(PRAutRoleText.Lines), new XdsMultiString(PRAutSpecText.Lines), new XdsMultiString("TelCom")));
            ss.SourceID = SourceIDText.Text; // UID of this Document Source
            ss.ContentType = PRssContentType.SelectedItem as XdsCode;

            // Create a new XdsDocument from File
            XdsDocument doc = new XdsDocument(FilePathText.Text);
            doc.Comments = PRDocDescripText.Text;
            doc.Title = PRDocumentNameText.Text;
            doc.RepositoryUniqueId = RepUIDText.Text; // repository uniqued ID is required
            doc.PatientInfo = patient;

            // doc.MimeType will be set automatically unless it's created via a stream

            doc.Authors.Add(new XdsAuthor(PRAutNameText.Text, new XdsMultiString(PRAutInstText.Lines), new XdsMultiString(PRAutRoleText.Lines), new XdsMultiString(PRAutSpecText.Lines), new XdsMultiString("TelCom")));
            doc.ClassCode = PRDocClassCodeComboBox.SelectedItem as XdsCode;
            doc.TypeCode = PRDocTypeCodeComboBox.SelectedItem as XdsCode;
            doc.FormatCode = PRDocFormatCodeComboBox.SelectedItem as XdsCode;
            doc.HealthCareFacilityTypeCode = PRDocHCFTCodeComboBox.SelectedItem as XdsCode;
            doc.PracticeSettingCode = PRDocPracSetCodeComboBox.SelectedItem as XdsCode;
            doc.ConfidentialityCodes.Add(PRDocConfidCodeComboBox.SelectedItem as XdsCode);

            ss.Documents.Add(doc); // Add Document to SubmissionSet. You can also have folders (XdsFolder) within SubmissionSet

            // Send the Document              
            XdsRegistryResponse rr = xds.ProvideAndRegisterDocumentSet(ss);
            MessageBox.Show(rr.Status.ToString());
        }
        #endregion

    }
}
