using System;
using System.Windows.Forms;
using DicomObjects;

namespace LicenceManipulation
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();            
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            Text += $"        DicomObjects.v {DicomGlobal.FileVersion}";
            // this helps trouble-shoot license problems
            DicomGlobal.SetRegWord("LogMachineIDInfo", 1);

            // if there is a problem with the license activation, send us the log for checking
            // you should find the D.O.Net.xxx.log in the LicenceManipulation.exe folder 
            DicomGlobal.LogToFile(Environment.CurrentDirectory, 0x3F);

            FillBox();
        }

        private void FillBox()
        {
            licenseList.Items.Clear();

            mode.Text = Environment.Is64BitProcess ? "64 bit mode" : "32 bit mode";
            // DicomLicensne.MachineID is generated by DicomObjects to uniquely identifies each machine
            // MachineID might change due to hardware changes, but should not change after Windows update
            machineID.Text = "MachineID = " + DicomLicense.MachineID.ToString();
                   
            // list all DicomObjects licenses found on the machine, including expired ones    
            foreach (DicomLicense l in DicomLicense.InstalledLicenses)
            {                
                var item = new ListViewItem(l.LicenseType.ToString());
                item.Tag = l;
                item.SubItems.Add(l.Expiry.ToString("D"));
                item.SubItems.Add(l.LicenseID.ToString());
                item.SubItems.Add(l.AuthorisationID.ToString());
                item.ForeColor = (l.Expiry < DateTime.Now)?System.Drawing.Color.Red: System.Drawing.Color.Green;

                licenseList.Items.Add(item);
            }
        }

        private void GetLicenseBTN_Click(object sender, EventArgs e)
        {
            DicomLicense.Dialog.AuthorisationString.Text = "XXXX-YYYY-ZZZZ";
            newTooltip().SetToolTip(DicomLicense.Dialog.AuthorisationString, "Enter your License Key in XXXX-YYYY-ZZZZ format");
            newTooltip().SetToolTip(DicomLicense.Dialog.CustomerInfo1, "Enter the licensee's Name or ID etc.");
            newTooltip().SetToolTip(DicomLicense.Dialog.CustomerInfo2, "Enter other information that can identify the licensee");
            DicomLicense.Dialog.ShowDialog();
            FillBox();
        }

        private ToolTip newTooltip()
        {
            return new ToolTip()
            {
                ShowAlways = true,
                ReshowDelay= 0,                 
            };            
        }

        private void DeleteAllLicenseBTN_Click(object sender, EventArgs e)
        {
            deleteAllLicenses();
        }
        
        private void DeleteSelectedBTN_Click(object sender, EventArgs e)
        {
            deleteSelectedLicense();
        }

        private void licenseDetailsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (licenseList.SelectedItems.Count > 0)
            {
                DicomLicense l = licenseList.SelectedItems[0].Tag as DicomLicense;
                MessageBox.Show(getLicenseDetails(l), "License Details");
            }
        }

        private void deleteLicenseToolStripMenuItem_Click(object sender, EventArgs e)
        {
            deleteSelectedLicense();
        }

        private void deActivateAllLicensesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            deleteAllLicenses();
        }

        private void deleteSelectedLicense()
        {
            if (licenseList.SelectedItems.Count > 0)
            {
                try
                {
                    DicomLicense l = licenseList.SelectedItems[0].Tag as DicomLicense;
                    if (l != null)
                    {
                        if (MessageBox.Show("Are you really sure?", "Deactivate Selected?", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation) == DialogResult.Yes)
                        {
                            l.Deactivate(DicomLicense.MachineID, DicomGlobal.FileVersion);
                            FillBox();
                        }
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show("Error Deactivating Selected Licence - " + ex.Message);
                }
            }
        }

        private void deleteAllLicenses()
        {
            if (licenseList.Items.Count > 0)
            {
                UserInfoPrompt dlg = new UserInfoPrompt();
                if (dlg.ShowDialog() == DialogResult.OK 
                    && !string.IsNullOrEmpty(dlg.CustomerInfo1) 
                    && !string.IsNullOrEmpty(dlg.CustomerInfo2))
                {
                    string res;
                    res = DicomLicense.DeactivateOnline(dlg.CustomerInfo1, dlg.CustomerInfo2);
                    MessageBox.Show(res, "Deactivation result", MessageBoxButtons.OK);
                    FillBox();
                }
            }
        }

        private string getLicenseDetails(DicomLicense l)
        {

            return $@"Allowed Functions: {l.AllowedFunctions}{Environment.NewLine}
AuthorisationID:  {l.AuthorisationID}{Environment.NewLine}
Enpiry Date:  {l.Expiry.ToString("D")}{Environment.NewLine}
IsRamLicense: {l.IsRamLicense}{Environment.NewLine}
License ID:   {l.LicenseID}{Environment.NewLine}
License Token: {l.LicenseToken}{Environment.NewLine}
License Type: {l.LicenseType}{Environment.NewLine}";
        }
        
    }
}