﻿using System.Collections.Generic;

namespace Sample_Router_Application
{
    public class Aet
    {
        public string Title { get; set; }
        public string Address { get; set; }
        public int Port { get; set; }
    }

    /// <summary>
    /// In a real applicaiton this would be in a database
    /// </summary>
    public static class Configuration
    {

        public readonly static List<Aet> RemoteAETS = new List<Aet>()
        {
            new Aet() { Title = "LOCAL", Address= "localhost", Port = 11112 },
            new Aet() { Title = "MoveClient1", Address= "localhost", Port = 1111 },
        };

        public readonly static Aet PACS_Config = new Aet() { Title = "TestServer", Address = "DicomServer.co.uk", Port = 104 };

        // the port we listen on for incoming client requests
        public static int LISTEN_PORT_CLIENT { get; set; } = 104;

        // the port we listen on for returning C-MOVE data from the server
        public static int LISTEN_PORT_PACS { get; set; } = 1022;

        // Whether to use C-MOVE for outing requetss
        public static bool CMOVE { get; set; } = false;

        // our own AET (only check if promiscuous is false)
        public static string ROUTER_AET { get; set; } = "DICOM Router";

        // whether to allow ANY incoming AET
        public static bool Promiscuous { get; set; } = true;

        // logging control
        public static int LOG_LEVEL { get; set; } = 63;
        public static string LOG_PATH { get; set; } = "C:\\logs";
    }
}

