﻿using System;
using DicomObjects;
using DicomObjects.DicomCodecs;
using DicomObjects.DicomUIDs;

namespace CustomCodec_CharLS
{
    internal partial class Program
    {
        public static void Main(string[] args)
        {
            try
            {
                //  Register Char-LS custom codec to handle Jpeg LS data. You could register other codecs if you want to
                CodecGlobal.RegisterCodec(new CharLsCodecFactory());

                string filename = "Your JpegLS compressed Dicom.dcm";
                
                var im = new DicomImage(filename);
                im.Write("Output.dcm", TransferSyntaxes.ExplicitVRLittleEndian);    //  Write it out to any supported transfer syntax
                
                Console.WriteLine("Successfully decompressed using CharLS Codec");
            }
            catch (Exception e)
            {
                Console.WriteLine(e);
                throw;
            }
        }
    }
}