VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form QueryRetrieve 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "DICOM Query Retrieve"
   ClientHeight    =   3990
   ClientLeft      =   30
   ClientTop       =   360
   ClientWidth     =   7815
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3990
   ScaleWidth      =   7815
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton CloseBTN 
      Caption         =   "Close"
      Height          =   492
      Left            =   4440
      TabIndex        =   3
      Top             =   3360
      Width           =   1332
   End
   Begin VB.CommandButton RetrieveBTN 
      Caption         =   "Retrieve"
      Height          =   492
      Left            =   1560
      TabIndex        =   2
      Top             =   3360
      Width           =   1332
   End
   Begin VB.CommandButton ResetBTN 
      Caption         =   "Reset"
      Height          =   492
      Left            =   3000
      TabIndex        =   1
      Top             =   3360
      Width           =   1332
   End
   Begin MSComctlLib.TreeView Tree 
      Height          =   3132
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   7572
      _ExtentX        =   13361
      _ExtentY        =   5530
      _Version        =   393217
      Style           =   7
      BorderStyle     =   1
      Appearance      =   1
   End
End
Attribute VB_Name = "QueryRetrieve"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim q As DicomQuery
Dim resultDatasets As DicomDataSets
Dim optionsRef As Options

' Get Study Description
Function Description(study As DicomDataSet)
    Dim s As String
    Dim studyDate As DicomAttribute
    
    s = study.StudyDescription
    If s = "" Then
        s = "Study Description"
    End If
    
    Set studyDate = study.Attributes(&H8, &H20)
    
    If studyDate.Exists Then
        s = s & " on " & studyDate.Value
    End If
    
    Description = s
End Function

' Perform a Patient/Study Root C-FIND to populate all Patients
Public Sub LoadPatients(opts As Options)
    Dim IDs(4) As Variant
    Dim r As DicomDataSet
    Set optionsRef = opts

    ' Each node has an array in it's "tag" property - item 0 is the level (1=PATIENT...4=Image)
    ' and the other items are the unique keys for that "level" and those above

    Tree.Nodes.Clear

    Do
        Set q = New DicomQuery
        q.Node = optionsRef.RemoteNode
        q.Port = optionsRef.RemotePort
        q.CallingAE = optionsRef.CallingAE
        q.CalledAE = optionsRef.RemoteAE
        If optionsRef.PatientRoot Then
            q.level = "PATIENT"
            q.Root = "PATIENT"
        Else
            q.level = "STUDY"
            q.Root = "STUDY"
        End If
        
        q.Name = InputBox("Enter Patient Name.  (Leave as blank or * if unknown)", , "*")

        On Error Resume Next
        Set resultDatasets = q.DoQuery ' DICOM C-FIND
        
        If Err = 0 Then Exit Do
        try = MsgBox("Attempt to query remote machine returned error" & vbCrLf & Err.Description & vbCrLf & "Please check the values used for remote node, remote port, remote AET and local AET before proceding", vbOKCancel)
        If try = 2 Then
            RetrieveDialog.Hide
            Exit Sub
        End If
        optionsRef.Show 1
        On Error GoTo 0
    Loop

    Dim nd As Node
    ' populate the treeview
    For Each r In resultDatasets
        IDs(1) = r.PatientID
        If optionsRef.PatientRoot Then
            Set nd = Tree.Nodes.Add(, , , r.Name)
            IDs(0) = 1
            Tree.Nodes.Add nd.Index, tvwChild, , "Please wait, while the study list is retrieved"
        Else
            Set nd = Tree.Nodes.Add(, , , r.Name & " / " & Description(r))
            IDs(0) = 2
            IDs(2) = r.StudyUID
            Tree.Nodes.Add nd.Index, tvwChild, , "Please wait, while the series list is retrieved"
        End If
        nd.Tag = IDs
        nd.Expanded = False
    Next
    Me.Show
End Sub

Private Sub CloseBTN_Click()
    Unload QueryRetrieve
End Sub

Private Sub ResetBTN_Click()
    LoadPatients optionsRef
End Sub

Private Sub RetrieveBTN_Click()
    Dim Node As Node
    Set Node = Tree.SelectedItem
    
    If Node Is Nothing Then
        Exit Sub
    End If
    

    Select Case Node.Tag(0)
    Case 1    '"PATIENT"
        q.PatientID = Node.Tag(1)
        q.StudyUID = ""
        q.SeriesUID = ""
        q.InstanceUID = ""
        q.level = "PATIENT"

    Case 2    '"STUDY"
        q.PatientID = Node.Tag(1)
        q.StudyUID = Node.Tag(2)
        q.SeriesUID = ""
        q.InstanceUID = ""
        q.level = "STUDY"

    Case 3    '"SERIES"
        q.PatientID = Node.Tag(1)
        q.StudyUID = Node.Tag(2)
        q.SeriesUID = Node.Tag(3)
        q.InstanceUID = ""
        q.level = "SERIES"

    Case 4    '"IMAGE"
        q.PatientID = Node.Tag(1)
        q.StudyUID = Node.Tag(2)
        q.SeriesUID = Node.Tag(3)
        q.InstanceUID = Node.Tag(4)
        q.level = "IMAGE"
    End Select

    If optionsRef.CGET Then
        On Error GoTo er1
        Set s = q.GetImages ' Perform C-GET to Retrieve Images
    ElseIf optionsRef.S_CMOVE Then
        Dim OK As Boolean
        q.Destination = optionsRef.MoveDestination
        q.ReceivePort = optionsRef.Port
        Set s = q.GetUsingMove
    ElseIf optionsRef.A_CMOVE Then
        q.Destination = optionsRef.MoveDestination ' MoveDestination must be known by PACS
        q.MoveImages ' Perform C-MOVE to Retrieve Images
    End If

    If optionsRef.CGET Or optionsRef.S_CMOVE Then
        For i = 1 To s.Count
            MainViewerForm.Viewer.Images.Add s(i)
        Next
    End If
    
    Me.Hide
    Exit Sub
er1:
    If Err.Number = 1409 Then    ' abstract syntax not supported
        MsgBox "The SCP did not accept this request, which probably means that it does not accept C-GET requests (many systems no longer accept C-GET).  You should try again using one of the C-MOVE options (see View | Options | Query SCU) then retrieval options, but note that this will only work if the SCP has been set up specificially to associate your AE Title, IP address and port number"
    Else
        MsgBox "C-GET failed - error number " & Err.Number & " - " & Err.Description
    End If
End Sub


Private Sub Tree_Expand(ByVal Node As MSComctlLib.Node)
    Dim nd As Node, r As DicomDataSet
    Dim IDs(4)
    Dim i As Integer
    For i = 1 To Node.Tag(0)
        IDs(i) = Node.Tag(i)
    Next
    IDs(0) = Node.Tag(0) + 1
    Node.Tag(0) = -Node.Tag(0)

    Select Case Node.Tag(0)
    Case 1    '"PATIENT"
        q.level = "STUDY"
        q.PatientID = Node.Tag(1)
        q.StudyUID = ""
        q.SeriesUID = ""
        q.InstanceUID = ""
        Set resultDatasets = q.DoQuery
        Tree.Nodes.Remove Node.Child.Index

        For Each r In resultDatasets
            s = Description(r)
            Set nd = Tree.Nodes.Add(Node.Index, tvwChild, , s)
            IDs(2) = r.StudyUID
            nd.Tag = IDs
            Tree.Nodes.Add nd.Index, tvwChild, , "Please wait, while the series list is retrieved"
            nd.Expanded = False
        Next
    Case 2    '"STUDY"
        q.level = "SERIES"
        q.PatientID = Node.Tag(1)
        q.StudyUID = Node.Tag(2)
        q.SeriesUID = ""
        q.InstanceUID = ""
        Set resultDatasets = q.DoQuery

        Tree.Nodes.Remove Node.Child.Index

        For Each r In resultDatasets
            s = r.SeriesDescription
            If s = "" Then s = "**SERIES**"
            Set nd = Tree.Nodes.Add(Node.Index, tvwChild, , s)
            IDs(3) = r.SeriesUID
            nd.Tag = IDs
            Tree.Nodes.Add nd.Index, tvwChild, , "Please wait, while the Image list is retrieved"
            nd.Expanded = False
        Next
    Case 3    '"SERIES"
        q.level = "IMAGE"
        q.PatientID = Node.Tag(1)
        q.StudyUID = Node.Tag(2)
        q.SeriesUID = Node.Tag(3)
        q.InstanceUID = ""
        Set resultDatasets = q.DoQuery

        Tree.Nodes.Remove Node.Child.Index

        For Each r In resultDatasets
            s = r.InstanceUID
            Set nd = Tree.Nodes.Add(Node.Index, tvwChild, , s)
            IDs(4) = r.InstanceUID
            nd.Tag = IDs
        Next
    Case -1    ' Do nothing - already retrieved
    Case -2    ' Do nothing - already retrieved
    Case -3    ' Do nothing - already retrieved

    Case Else
        MsgBox "Invalid Level"
    End Select
End Sub
