VERSION 5.00
Object = "{D1C00008-F528-4513-A681-386B6F2F74E1}#8.0#0"; "DicomObjects.8.32.ocx"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Object = "{BDC217C8-ED16-11CD-956C-0000C04E4C0A}#1.1#0"; "TABCTL32.OCX"
Begin VB.Form MainViewerForm 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "DicomObjects V8 Sample Viewer"
   ClientHeight    =   9060
   ClientLeft      =   120
   ClientTop       =   855
   ClientWidth     =   12585
   Icon            =   "DicomViewer.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   604
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   839
   Begin TabDlg.SSTab TabHolder2D3D 
      Height          =   3135
      Left            =   8160
      TabIndex        =   27
      Top             =   0
      Width           =   4215
      _ExtentX        =   7435
      _ExtentY        =   5530
      _Version        =   393216
      Tabs            =   2
      Tab             =   1
      TabHeight       =   420
      TabCaption(0)   =   "2D Operations"
      TabPicture(0)   =   "DicomViewer.frx":5A5A2
      Tab(0).ControlEnabled=   0   'False
      Tab(0).Control(0)=   "Frame7"
      Tab(0).ControlCount=   1
      TabCaption(1)   =   "3D Operations"
      TabPicture(1)   =   "DicomViewer.frx":5A5BE
      Tab(1).ControlEnabled=   -1  'True
      Tab(1).Control(0)=   "Frame2"
      Tab(1).Control(0).Enabled=   0   'False
      Tab(1).ControlCount=   1
      Begin VB.Frame Frame2 
         BorderStyle     =   0  'None
         Height          =   2532
         Left            =   120
         TabIndex        =   42
         Top             =   480
         Width           =   2412
         Begin VB.CommandButton MIP 
            Caption         =   "MIP"
            Height          =   300
            Left            =   120
            TabIndex        =   49
            Top             =   360
            Width           =   2000
         End
         Begin VB.CommandButton Slab 
            Caption         =   "Slab"
            Height          =   300
            Left            =   120
            TabIndex        =   48
            Top             =   720
            Width           =   2000
         End
         Begin VB.CommandButton VR 
            Caption         =   "VR"
            Height          =   300
            Left            =   120
            TabIndex        =   47
            Top             =   1080
            Width           =   2000
         End
         Begin VB.CommandButton SagitalView 
            Caption         =   "Sagital View"
            Height          =   300
            Left            =   120
            TabIndex        =   46
            Top             =   1440
            Width           =   2000
         End
         Begin VB.CommandButton CoronalView 
            Caption         =   "Coronal View"
            Height          =   300
            Left            =   120
            TabIndex        =   45
            Top             =   1800
            Width           =   2000
         End
         Begin VB.CommandButton AxialView 
            Caption         =   "Axial View"
            Height          =   300
            Left            =   120
            TabIndex        =   44
            Top             =   2160
            Width           =   2000
         End
         Begin VB.CommandButton MPR 
            Caption         =   "MPR"
            Height          =   300
            Left            =   120
            TabIndex        =   43
            Top             =   0
            Width           =   2000
         End
      End
      Begin VB.Frame Frame7 
         BorderStyle     =   0  'None
         Height          =   2412
         Left            =   -74880
         TabIndex        =   28
         Top             =   480
         Width           =   2412
         Begin VB.CommandButton flip_H_BTN 
            Caption         =   "Flip Horizontally"
            Height          =   300
            Left            =   100
            TabIndex        =   33
            Top             =   120
            Width           =   2000
         End
         Begin VB.CommandButton flip_V_BTN 
            Caption         =   "Flip Vertically"
            Height          =   300
            Left            =   100
            TabIndex        =   32
            Top             =   480
            Width           =   2000
         End
         Begin VB.CommandButton rotate_clock_BTN 
            Caption         =   "Rot. Clockwise"
            Height          =   300
            Left            =   120
            TabIndex        =   31
            Top             =   840
            Width           =   2000
         End
         Begin VB.CommandButton rotate_Anticlock_BTN 
            Caption         =   "Rot. Anticlockwise"
            Height          =   300
            Left            =   100
            TabIndex        =   30
            Top             =   1200
            Width           =   2000
         End
         Begin VB.CommandButton reset_2D_BTN 
            Caption         =   "Reset"
            Height          =   300
            Left            =   100
            TabIndex        =   29
            Top             =   1560
            Width           =   2000
         End
         Begin MSComctlLib.Toolbar cineToolbar 
            Height          =   564
            Left            =   120
            TabIndex        =   34
            Top             =   1920
            Width           =   2292
            _ExtentX        =   4048
            _ExtentY        =   1005
            ButtonWidth     =   609
            ButtonHeight    =   900
            _Version        =   393216
            Begin VB.CommandButton cine_Startof_BTN 
               Height          =   280
               Left            =   0
               Picture         =   "DicomViewer.frx":5A5DA
               Style           =   1  'Graphical
               TabIndex        =   41
               ToolTipText     =   "Start of Cine"
               Top             =   120
               Width           =   280
            End
            Begin VB.CommandButton cine_Reverse_BTN 
               Height          =   280
               Left            =   300
               Picture         =   "DicomViewer.frx":5FA24
               Style           =   1  'Graphical
               TabIndex        =   40
               ToolTipText     =   "Reverse Cine"
               Top             =   120
               Width           =   280
            End
            Begin VB.CommandButton cine_Play_BTN 
               Height          =   280
               Left            =   600
               Picture         =   "DicomViewer.frx":64F6E
               Style           =   1  'Graphical
               TabIndex        =   39
               ToolTipText     =   "Play Cine"
               Top             =   120
               Width           =   280
            End
            Begin VB.CommandButton cine_Repeat_BTN 
               Height          =   280
               Left            =   900
               Picture         =   "DicomViewer.frx":6A4B8
               Style           =   1  'Graphical
               TabIndex        =   38
               ToolTipText     =   "Repeat Cine"
               Top             =   120
               Width           =   280
            End
            Begin VB.CommandButton cine_Oscillate_BTN 
               Height          =   280
               Left            =   1200
               Picture         =   "DicomViewer.frx":6FA02
               Style           =   1  'Graphical
               TabIndex        =   37
               ToolTipText     =   "Oscillate Cine"
               Top             =   120
               Width           =   280
            End
            Begin VB.CommandButton cine_Endof_BTN 
               Height          =   280
               Left            =   1500
               Picture         =   "DicomViewer.frx":7504C
               Style           =   1  'Graphical
               TabIndex        =   36
               ToolTipText     =   "End of Cine"
               Top             =   120
               Width           =   280
            End
            Begin VB.CommandButton cine_Stop_BTN 
               Height          =   280
               Left            =   1800
               Picture         =   "DicomViewer.frx":7A596
               Style           =   1  'Graphical
               TabIndex        =   35
               ToolTipText     =   "Stop Cine"
               Top             =   120
               Width           =   280
            End
         End
      End
   End
   Begin MSComDlg.CommonDialog CommonDialog 
      Left            =   9240
      Top             =   7920
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      Flags           =   2621952
      MaxFileSize     =   32767
   End
   Begin VB.Frame Frame5 
      Caption         =   "Image Display Settings"
      Height          =   1400
      Left            =   10
      TabIndex        =   11
      Top             =   7450
      Width           =   7990
      Begin VB.CheckBox StretchToFit 
         Caption         =   "Stretch To Fit"
         Height          =   150
         Left            =   5640
         TabIndex        =   26
         Top             =   1080
         Value           =   1  'Checked
         Width           =   1695
      End
      Begin VB.CheckBox ShowRuler 
         Caption         =   "ShowRuler"
         Height          =   255
         Left            =   5640
         TabIndex        =   25
         Top             =   660
         Value           =   1  'Checked
         Width           =   1935
      End
      Begin VB.CheckBox ShowPatientAndExamDetails 
         Caption         =   "Show Patient/Exam details"
         Height          =   255
         Left            =   5640
         TabIndex        =   24
         Top             =   320
         Value           =   1  'Checked
         Width           =   2295
      End
      Begin VB.CheckBox DisableSmoothing 
         Caption         =   "Don't smooth during manipulation"
         Height          =   255
         Left            =   2760
         TabIndex        =   23
         Top             =   660
         Width           =   3135
      End
      Begin VB.CheckBox SmoothImages 
         Caption         =   "Smooth Images"
         Height          =   255
         Left            =   2760
         TabIndex        =   22
         Top             =   320
         Value           =   1  'Checked
         Width           =   1695
      End
      Begin VB.CheckBox AnatomicMarkers 
         Caption         =   "Show Anatomic Side Markers"
         Height          =   255
         Left            =   2760
         TabIndex        =   21
         Top             =   1000
         Value           =   1  'Checked
         Width           =   2535
      End
      Begin VB.VScrollBar ColSpin 
         Height          =   288
         Left            =   2160
         Max             =   10
         Min             =   1
         TabIndex        =   18
         Top             =   1000
         Value           =   10
         Width           =   252
      End
      Begin VB.VScrollBar RowSpin 
         Height          =   288
         Left            =   2160
         Max             =   10
         Min             =   1
         TabIndex        =   17
         Top             =   660
         Value           =   10
         Width           =   252
      End
      Begin VB.TextBox Rows 
         Height          =   288
         Left            =   1680
         TabIndex        =   16
         Text            =   "1"
         Top             =   660
         Width           =   372
      End
      Begin VB.TextBox Columns 
         Height          =   288
         Left            =   1680
         TabIndex        =   15
         Text            =   "1"
         Top             =   1000
         Width           =   372
      End
      Begin VB.VScrollBar CImageIndexSpin 
         Height          =   288
         Left            =   2160
         Max             =   0
         TabIndex        =   14
         Top             =   320
         Width           =   252
      End
      Begin VB.TextBox CImageIndex 
         Height          =   285
         Left            =   1680
         TabIndex        =   13
         Top             =   320
         Width           =   372
      End
      Begin VB.Label RowsLabel 
         Caption         =   "Display Rows"
         Height          =   255
         Left            =   120
         TabIndex        =   20
         Top             =   660
         Width           =   1095
      End
      Begin VB.Label ColumnsLabel 
         Caption         =   "Display Columns"
         Height          =   252
         Left            =   120
         TabIndex        =   19
         Top             =   1000
         Width           =   1332
      End
      Begin VB.Label ImageLabel 
         Caption         =   "Current Image Index"
         Height          =   255
         Left            =   120
         TabIndex        =   12
         Top             =   320
         Width           =   1695
      End
   End
   Begin VB.Frame Frame4 
      Caption         =   "Mouse Functions"
      Height          =   1695
      Left            =   8160
      TabIndex        =   10
      Top             =   5160
      Width           =   4212
      Begin VB.OptionButton MouseFunctionOption 
         Caption         =   "Edit Annotation"
         Height          =   255
         Index           =   5
         Left            =   2280
         TabIndex        =   57
         Top             =   1320
         Width           =   1695
      End
      Begin VB.OptionButton MouseFunctionOption 
         Caption         =   "Window, Scroll && Zoom"
         Height          =   255
         Index           =   6
         Left            =   120
         TabIndex        =   56
         Top             =   600
         Width           =   2055
      End
      Begin VB.OptionButton MouseFunctionOption 
         Caption         =   "Rotate, Pan && Zoom"
         Height          =   255
         Index           =   7
         Left            =   120
         TabIndex        =   55
         Top             =   960
         Width           =   2055
      End
      Begin VB.OptionButton MouseFunctionOption 
         Caption         =   "Add Label/Measurment"
         Height          =   255
         Index           =   4
         Left            =   120
         TabIndex        =   54
         Top             =   1320
         Width           =   2055
      End
      Begin VB.OptionButton MouseFunctionOption 
         Caption         =   "PixelValues"
         Height          =   255
         Index           =   2
         Left            =   2280
         TabIndex        =   53
         Top             =   240
         Width           =   1815
      End
      Begin VB.OptionButton MouseFunctionOption 
         Caption         =   "Free Image Rotation"
         Height          =   255
         Index           =   3
         Left            =   2280
         TabIndex        =   52
         Top             =   600
         Width           =   1815
      End
      Begin VB.OptionButton MouseFunctionOption 
         Caption         =   "Magnifing Glass"
         Height          =   255
         Index           =   1
         Left            =   2280
         TabIndex        =   51
         Top             =   960
         Width           =   1695
      End
      Begin VB.OptionButton MouseFunctionOption 
         Caption         =   "Crop"
         Height          =   255
         Index           =   8
         Left            =   120
         TabIndex        =   50
         Top             =   240
         Width           =   1455
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "Mouse && Wheel functions"
      Height          =   1815
      Left            =   8160
      TabIndex        =   1
      Top             =   3240
      Width           =   4212
      Begin VB.Label RightFunction 
         Alignment       =   1  'Right Justify
         BackColor       =   &H8000000E&
         Caption         =   "Select"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   2160
         TabIndex        =   9
         Top             =   1080
         Width           =   1935
      End
      Begin VB.Label MouseWheelFunction 
         Alignment       =   1  'Right Justify
         BackColor       =   &H8000000E&
         Caption         =   "Select"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   2160
         TabIndex        =   8
         Top             =   1440
         Width           =   1935
      End
      Begin VB.Label MiddleFunction 
         Alignment       =   1  'Right Justify
         BackColor       =   &H8000000E&
         Caption         =   "Select"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   2160
         TabIndex        =   7
         Top             =   720
         Width           =   1935
      End
      Begin VB.Label LeftFunction 
         Alignment       =   1  'Right Justify
         BackColor       =   &H8000000E&
         Caption         =   "Select"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   2160
         TabIndex        =   6
         Top             =   360
         Width           =   1935
      End
      Begin VB.Label Label1 
         Caption         =   "Mouse Wheel"
         Height          =   255
         Index           =   3
         Left            =   105
         TabIndex        =   5
         Top             =   1440
         Width           =   1005
      End
      Begin VB.Label Label1 
         Caption         =   "Right Button"
         Height          =   255
         Index           =   2
         Left            =   105
         TabIndex        =   4
         Top             =   1080
         Width           =   1005
      End
      Begin VB.Label Label1 
         Caption         =   "Middle Button"
         Height          =   255
         Index           =   1
         Left            =   105
         TabIndex        =   3
         Top             =   720
         Width           =   1005
      End
      Begin VB.Label Label1 
         Caption         =   "Left Button"
         Height          =   255
         Index           =   0
         Left            =   100
         TabIndex        =   2
         Top             =   360
         Width           =   1000
      End
   End
   Begin DicomObjects8.DicomViewer Viewer 
      Height          =   7410
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   7965
      _Version        =   524288
      _ExtentX        =   14049
      _ExtentY        =   13053
      _StockProps     =   35
      BackColor       =   -2147483638
      UseMouseWheel   =   -1  'True
   End
   Begin VB.Menu File 
      Caption         =   "File"
      Begin VB.Menu Load2D 
         Caption         =   "Load 2D"
      End
      Begin VB.Menu Load3D 
         Caption         =   "Load 3D"
      End
      Begin VB.Menu Write 
         Caption         =   "Write"
      End
      Begin VB.Menu ApplyPresentationState 
         Caption         =   "Apply Presentation State"
      End
      Begin VB.Menu PrintDICOM 
         Caption         =   "Print (DICOM)"
      End
      Begin VB.Menu PrintWindows 
         Caption         =   "Print (Windows)"
      End
      Begin VB.Menu importFromNonDICOMFile 
         Caption         =   "Import from non-DICOM file"
      End
      Begin VB.Menu exportToNonDICOMFile 
         Caption         =   "Export to non-DICOM file"
      End
      Begin VB.Menu Exit 
         Caption         =   "Exit"
      End
   End
   Begin VB.Menu Edit 
      Caption         =   "Edit"
      Begin VB.Menu DeleteSelectedImage 
         Caption         =   "Delete Selected Image"
      End
      Begin VB.Menu DeleteAll 
         Caption         =   "Delete All"
      End
   End
   Begin VB.Menu Network 
      Caption         =   "Network"
      Begin VB.Menu VerifyCECHO 
         Caption         =   "Verify (C-ECHO)"
      End
      Begin VB.Menu QueryRetrieve 
         Caption         =   "Query/Retrieve (C-FIND/C-GET/C-MOVE)"
      End
      Begin VB.Menu SendSelectedCSTORE 
         Caption         =   "Send Selected (C-STORE)"
      End
      Begin VB.Menu SendAllCSTORE 
         Caption         =   "Send All (C-STORE)"
      End
   End
   Begin VB.Menu Display 
      Caption         =   "Display"
      Begin VB.Menu ViewerMode 
         Caption         =   "Viewer Mode"
         Begin VB.Menu DirectX 
            Caption         =   "DirectX"
         End
         Begin VB.Menu GDI 
            Caption         =   "GDI"
         End
      End
   End
   Begin VB.Menu View 
      Caption         =   "View"
      Begin VB.Menu ImageInformation 
         Caption         =   "Image Information"
      End
      Begin VB.Menu Options 
         Caption         =   "Options"
      End
   End
   Begin VB.Menu Tools 
      Caption         =   "Tools"
      Begin VB.Menu MakeNewImage 
         Caption         =   "Make New Image"
      End
      Begin VB.Menu Anonymiser 
         Caption         =   "Anonymiser"
      End
      Begin VB.Menu ShowLoggingOptions 
         Caption         =   "Show Logging options"
      End
      Begin VB.Menu CropToLastLabel 
         Caption         =   "Crop To Last Label"
      End
      Begin VB.Menu AboutThisExample 
         Caption         =   "About this Example"
      End
   End
End
Attribute VB_Name = "MainViewerForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' global variables
Dim SelectedImage As DicomImage, ActiveImage As DicomImage, MagnifierImage As DicomImage
Attribute ActiveImage.VB_VarUserMemId = 1073938432
Attribute MagnifierImage.VB_VarUserMemId = 1073938432

Dim WithEvents server As DicomServer
Attribute server.VB_VarHelpID = -1
Dim LabelDrawing As Boolean
Attribute LabelDrawing.VB_VarUserMemId = 1073938436
Dim LastPositionX As Single, LastPositionY As Single, MouseDownPositionX As Single, MouseDownPositionY As Single
Attribute LastPositionX.VB_VarUserMemId = 1073938437
Attribute LastPositionY.VB_VarUserMemId = 1073938437
Attribute MouseDownPositionX.VB_VarUserMemId = 1073938437
Attribute MouseDownPositionY.VB_VarUserMemId = 1073938437
Dim ActiveIndex As Integer
Attribute ActiveIndex.VB_VarUserMemId = 1073938441
Dim CurrentLabel As DicomLabel, FirstLineLabel As DicomLabel, ValueLabel As DicomLabel, CropLabel As DicomLabel, PixelValueLabel As DicomLabel
Attribute CurrentLabel.VB_VarUserMemId = 1073938442
Attribute FirstLineLabel.VB_VarUserMemId = 1073938442
Attribute ValueLabel.VB_VarUserMemId = 1073938442
Attribute CropLabel.VB_VarUserMemId = 1073938442
Attribute PixelValueLabel.VB_VarUserMemId = 1073938442

Dim OptionsBox As New Options
Attribute OptionsBox.VB_VarUserMemId = 1073938447
Dim RetrieveBox As New QueryRetrieve
Attribute RetrieveBox.VB_VarUserMemId = 1073938448
Dim Information As New ImageInformation
Attribute Information.VB_VarUserMemId = 1073938449
Dim AboutBox As New AboutBox
Attribute AboutBox.VB_VarUserMemId = 1073938450
Dim LabelForm As New LabelForm
Attribute LabelForm.VB_VarUserMemId = 1073938451
Dim LabelEdgeX As Single, LabelEdgeY As Single
Attribute LabelEdgeY.VB_VarUserMemId = 1073938433

Enum MouseFunctionEnums

    'These names should match the control on the Form for GroupBoxToEnum & EnumToGroupBox utility routines to work

    '  2D
    mfMagnifyingGlass = 1
    mfPixelValues = 2
    mfFreeRotation = 3
    mfAddAnnotation = 4
    mfEditAnnotation = 5

    '  BOTH
    mfwindowing = 6

    '  3D
    mfRotatePanZoom = 7
    mfCrop = 8


End Enum

Enum WheelFunction

    Volume
    nextImage
    cine
End Enum

Dim mouseFunction As MouseFunctionEnums

Private Sub AddAnnotation_Click()
    LabelForm.Show
    UpdateInformation

End Sub

Private Sub AnatomicMarkers_Click()
    UpdateMarkers
    Viewer.Refresh
End Sub



Sub SetPlane(plane As doPlane)
    If Not GetSelectedImage() Is Nothing And Not GetSelectedImage().PropertiesFor3D Is Nothing Then
        GetSelectedImage().Projection.SetViewPlane plane, True, 1
    End If
End Sub

Private Sub AxialView_Click()
    SetPlane doPlaneAxial
End Sub

Private Sub CImageIndexSpin_Change()

    If (CImageIndexSpin > 0) And (CImageIndexSpin <= Viewer.Images.Count) Then
        Viewer.CurrentIndex = Val(CImageIndexSpin)
    End If
    CImageIndex.Text = CImageIndexSpin.Value
    
End Sub

Private Sub cine_Oscillate_BTN_Click()
    ChangeCineMode doCineOscillate
End Sub

Private Sub cine_Play_BTN_Click()
    ChangeCineMode doCineForward
End Sub

Private Sub cine_Repeat_BTN_Click()
    ChangeCineMode doCineRepeat
End Sub

Private Sub cine_Reverse_BTN_Click()
    ChangeCineMode doCineReverse
End Sub
Private Sub cine_Stop_BTN_Click()
    ChangeCineMode doCineStatic
End Sub

Private Sub cine_Startof_BTN_Click()
    If Not GetSelectedImage() Is Nothing Then GetSelectedImage().Frame = 1
End Sub

Private Sub cine_Endof_BTN_Click()
    If Not GetSelectedImage() Is Nothing Then GetSelectedImage().Frame = GetSelectedImage().FrameCount
End Sub

Sub ChangeCineMode(mode As doCineMode)
    If Not GetSelectedImage() Is Nothing Then GetSelectedImage().CineMode = mode
End Sub


Private Sub ColSpin_Change()
    Viewer.MultiColumns = ColSpin.Value
    Columns.Text = ColSpin.Value
End Sub

Private Sub CoronalView_Click()
    SetPlane doPlaneCoronal
End Sub

Private Sub flip_H_BTN_Click()
    If Not GetSelectedImage() Is Nothing Then GetSelectedImage().FlipState = GetSelectedImage().FlipState Xor doFlipHorizontal
End Sub

Private Sub flip_V_BTN_Click()
    If Not GetSelectedImage() Is Nothing Then GetSelectedImage().FlipState = GetSelectedImage().FlipState Xor doFlipVertical
End Sub

Private Sub Form_Load()
    Set server = New DicomServer
    server.Listen OptionsBox.Port
    'Set the location to load the ffmpeg dll's in order to suport mpeg features (containing folder of the OCX)
    Dim DG As New DicomGlobal
    DG.SetDLLDirectory
    UpdateCells
End Sub

Private Sub Form_Unload(Cancel As Integer)
    End
End Sub

' Menu options - checked
Private Sub Load2D_Click()

    CommonDialog.InitDir = GetSamplePath("SampleProjects", "SampleImages\2D")
    CommonDialog.Filename = ""
    CommonDialog.ShowOpen

    If CommonDialog.Filename <> "" Then
        LoadImages Viewer.Images, CommonDialog.Filename
        SetSmoothingAll SmoothImages.Value
        EnableCinemodeToolbar
        SetSelectedImage Viewer.CurrentImage
        Viewer.CurrentImage.CacheMode = doCacheAll
        SetMouseFunction mfwindowing
    End If
    Viewer.AdjustMultiRowsColumns
    UpdateCells
End Sub

Private Sub UpdateCells()

    CImageIndex.Text = Viewer.CurrentIndex
    'Set limits on spin edits
    CImageIndexSpin.min = Viewer.Images.Count
    CImageIndexSpin.max = min(Viewer.Images.Count, 1)
    
    'not neeed all the time but convenient place to hide
    ColSpin.min = Viewer.MultiColumns
    ColSpin.max = 1
    RowSpin.min = Viewer.MultiRows
    RowSpin.max = 1
    
    Columns.Text = ColSpin.Value
    Rows.Text = RowSpin.Value
    
End Sub

Private Sub Load3D_Click()

    Dim Collection As New DicomImages, Volume As DicomVolume, mpr1 As DicomImage, mpr2 As DicomImage, label As DicomLabel

    Viewer.Images.Clear
    Viewer.MultiRows = 1
    Viewer.MultiColumns = 2
    

    CommonDialog.InitDir = GetSamplePath("SampleProjects", "SampleImages\3D")
    CommonDialog.DialogTitle = "Open a single File containing a Multi-Frame DicomImage, or multiple single images using shift-key for multi-select"
    CommonDialog.Filename = ""
    CommonDialog.ShowOpen

    If CommonDialog.Filename <> "" Then

        MousePointer = vbHourglass

        LoadImages Collection, CommonDialog.Filename
        If Collection.Count = 1 Then
            Set Volume = Collection(1).MakeVolume(1)
        Else
            Set Volume = Collection.MakeVolume(1)
        End If

        ' this example loads 2 copies, to show:
        ' a) That multiple copies can be displayed from one set of data
        ' b) How Dynamic reference lines can be used.

        Set mpr1 = Volume.Make3D(doMPR)    ' new DicomImage3D(volume, RenderMode3D.MPR)

        'Enable Directx mode here else we get an error in the viewer as 3D is not supported by GDI rednering.
        ''        SetViewerMode doDirectX

        ' centred on image, viewing along Y axis, with -ve Z (top of head) upwards
        mpr1.Projection.SetViewPlane doPlaneCoronal, True, 1
        Viewer.Images.Add mpr1

        Set mpr2 = Volume.Make3D(doMPR)    ' new DicomImage3D(volume, RenderMode3D.MPR)

        ' centred on image, viewing along X axis, with -ve Z (top of head) upwards
        mpr2.Projection.SetViewPlane doPlaneAxial, True, 1
        Viewer.Images.Add mpr2

        ' Give each a reference line pointing to the other
        Set label = New DicomLabel
        label.LabelType = doLabelReferenceLine
        Set label.ReferenceImage = mpr2
        label.ForeColour = vbRed
        mpr1.Labels.Add label

        Set label = New DicomLabel
        label.LabelType = doLabelReferenceLine
        Set label.ReferenceImage = mpr1
        label.ForeColour = vbYellow
        mpr2.Labels.Add label

        SetMouseFunction mfRotatePanZoom
        MousePointer = vbDefault
        SetSelectedImage mpr1
    End If
    
End Sub

Sub SetMouseFunction(func As MouseFunctionEnums)

    If func = mfAddAnnotation Then
        LabelForm.Show
    End If

    MouseFunctionOption(func).Value = 1
    mouseFunction = func
    Dim v As Variant
    v = MouseFunctionNames(mouseFunction)
    LeftFunction = v(0)
    MiddleFunction = v(1)
    RightFunction = v(2)
End Sub


Private Sub MIP_Click()
    Set3DMode doMaximum
End Sub

Private Sub MouseFunctionOption_Click(Index As Integer)
    SetMouseFunction (Index)
End Sub

Function MouseFunctionNames(func As MouseFunctionEnums) As Variant

    Select Case mouseFunction
        Case mfMagnifyingGlass
            MouseFunctionNames = Array("Magnifier", "Magnifier", "Magnifier")
        Case mfPixelValues
            MouseFunctionNames = Array("Show Pixel Values", "Show Pixel Values", "Show Pixel Values")
        Case mfFreeRotation
            MouseFunctionNames = Array("Free Rotation", "Free Rotation", "Free Rotation")
        Case mfAddAnnotation
            MouseFunctionNames = Array("Add Label", "Add Label", "Add Measurement")
        Case mfEditAnnotation
            MouseFunctionNames = Array("Select Label", "Move Label", "Resize Label")
        Case mfwindowing
            MouseFunctionNames = Array("Windowing", "Scroll", "Zoom")
        Case mfRotatePanZoom
            MouseFunctionNames = Array("Rotate in 3D", "Pan", "Zoom")
        Case mfCrop
            MouseFunctionNames = Array("Rectangle crop", "3D Rotation", "Line crop")

    End Select
End Function

Private Sub MPR_Click()
    Set3DMode doMPR
End Sub

Sub Set3DMode(mode As do3DMode)
    If Not GetSelectedImage() Is Nothing And Not GetSelectedImage().PropertiesFor3D Is Nothing Then
        GetSelectedImage().mode = mode
    End If
End Sub

Private Sub reset_2D_BTN_Click()
    If Not GetSelectedImage() Is Nothing Then
        GetSelectedImage().RotateState = doRotateNormal
        GetSelectedImage().FlipState = doFlipNormal
        GetSelectedImage().angle = 0
    End If


End Sub

Private Sub rotate_Anticlock_BTN_Click()
    If Not GetSelectedImage() Is Nothing Then GetSelectedImage().RotateState = GetSelectedImage().RotateState + 1

End Sub

Private Sub rotate_clock_BTN_Click()
    If Not GetSelectedImage() Is Nothing Then GetSelectedImage().RotateState = GetSelectedImage().RotateState - 1
End Sub

Private Sub RowSpin_Change()
    Viewer.MultiRows = RowSpin.Value
    Rows.Text = RowSpin.Value
End Sub

Private Sub SagitalView_Click()
    Me.SetPlane doPlaneSagittal
End Sub

Private Sub server_InstanceReceived(ByVal Connection As DicomObjects8.DicomConnection, ByVal dataset As DicomObjects8.DicomDataSet)
    Connection.Status = 0
End Sub

Private Sub server_VerifyReceived(Status As Long)
    Status = 0
End Sub

Private Sub ShowPatientAndExamDetails_Click()
    UpdateInformation
    Viewer.Refresh
End Sub

Private Sub ShowRuler_Click()
    UpdateRulers
    Viewer.Refresh
End Sub

Private Sub Slab_Click()
    Set3DMode doAverage
End Sub

Private Sub SmoothImages_Click()
    SetSmoothingAll SmoothImages.Value
End Sub

Private Sub StretchToFit_Click()

    If StretchToFit.Value Then
        GetSelectedImage().StretchMode = StretchCentred
    Else
        GetSelectedImage().ScrollX = GetSelectedImage().ActualScrollX
        GetSelectedImage().ScrollY = GetSelectedImage().ActualScrollY
        GetSelectedImage().Zoom = GetSelectedImage().ActualZoom
        GetSelectedImage().StretchMode = NoStretch
    End If
End Sub

' control events

Private Sub Viewer_MouseDown(Button As Integer, Shift As Integer, x As Long, y As Long)

    Dim labelList As DicomLabels

    Me.SetFocus

    ' update active irrespective of mouse function
    GetSelectedImage().BorderColour = vbTransparent    ' clear previous

    ActiveIndex = Viewer.ImageIndex(x, y)
    If ActiveIndex >= 1 And ActiveIndex <= Viewer.Images.Count Then
        Set ActiveImage = Viewer.Images(ActiveIndex)
        SetSelectedImage ActiveImage    ' this one is NOT cleared in mouse up - used in GetSelectedImage
    Else
        Set ActiveImage = Nothing
        'If this is a new label action then we need to process it and not return here
        If LabelDrawing Then Exit Sub
    End If

    MouseDownPositionX = x
    MouseDownPositionY = y

    Select Case mouseFunction
        Case mfwindowing
            ' may turn off smoothing for Manipulation

            If DisableSmoothing.Value Then SetSmoothingAll False

        Case mfAddAnnotation
            If Not CurrentLabel Is Nothing Then
                CurrentLabel.SelectMode = doSelectNone
            End If

            Set CurrentLabel = LabelForm.NewLabel(x, y)
            LabelDrawing = True
            Viewer.Labels.Add CurrentLabel

            If Button = vbRightButton Or LabelForm.isAngle() Then    'Measure
                If FirstLineLabel Is Nothing And LabelForm.isAngle() Then
                    Set FirstLineLabel = CurrentLabel
                Else
                    Set ValueLabel = New DicomLabel

                    ValueLabel.ScaleMode = doLabelScaleOutput
                    ValueLabel.ScaleFontSize = False
                    ValueLabel.ForeColour = vbGreen
                    'ValueLabel.Font = LabelForm.Font
                    ValueLabel.Tag = "VALUE"

                    If LabelForm.Transparent.Value = 0 Then
                        ValueLabel.BackColour = LabelForm.BackColour.BackColor
                    End If
                    Viewer.Labels.Add ValueLabel
                End If
            End If

        Case mfEditAnnotation    ' Select Label
            Set labelList = Viewer.LabelHits(x, y, True, True, True)    '' .Where(l >= l.Tag = Null).ToList() ' exclude markers etc.

            If Not CurrentLabel Is Nothing Then
                CurrentLabel.SelectMode = doSelectNone
                Set CurrentLabel = Nothing
            End If

            '' need to add "where" into this to exclude markers

            If labelList.Count > 0 Then
                'The line below can be modified to refer to any label within the collection
                'This example selects the first label within the collection
                Set CurrentLabel = labelList(1)
                CurrentLabel.SelectColour = vbYellow
                CurrentLabel.SelectMode = doSelectAllHandles
            Else
                Exit Sub
            End If

            MoveLabelImageToViewer CurrentLabel

            'Right Button to Resize Label
            If Button = vbRightButton Then

                Dim x2 As Single, y2 As Single
                x2 = (x - CurrentLabel.Left) / CurrentLabel.Width
                y2 = (y - CurrentLabel.Top) / CurrentLabel.Height

                LabelEdgeX = IIf(x2 < 0.3, -1, IIf(x2 < 0.7, 0, 1))   ' -1 = left, 0 = middle, 1 = right
                LabelEdgeY = IIf(y2 < 0.3, -1, IIf(y2 < 0.7, 0, 1))    ' -1 = top, 0 = middle, 1 = Bottom
            End If

            ' Middle Button to Move the Label
            If Button = vbMiddleButton Then
                LabelEdgeX = 0
                LabelEdgeY = 0
            End If
            Viewer.Refresh

        Case mfMagnifyingGlass
            SetMagnifier x, y

        Case mfPixelValues
            SetPixelLabel x, y

        Case mfCrop

            '  Initialize Crop Label with a starting point
            Set CropLabel = LabelForm.NewLabel(x, y)

            Select Case Button
                    '  Rectangle crop
                Case vbRightButton
                    CropLabel.LabelType = doLabelLine

                    '  Line crop
                Case vbLeftButton
                    CropLabel.LabelType = doLabelRectangle
            End Select

            '  Add label to the Viewer
            Viewer.Labels.Add CropLabel

    End Select    ' End switch
    LastPositionX = x
    LastPositionY = y
End Sub

Private Sub Viewer_MouseMove(Button As Integer, Shift As Integer, x As Long, y As Long)

    Dim PositionX As Integer, PositionY As Integer
    Dim OffsetX As Integer, OffsetY As Integer
    Dim Selected3DImage As DicomProjection
    Dim ImageReferencePoint
    
    PositionX = x
    PositionY = y
    OffsetX = x - LastPositionX
    OffsetY = y - LastPositionY

    If Button > 0 Then
        Select Case mouseFunction
            Case mfwindowing
                Select Case Button
                    Case vbLeftButton    ' windowing
                        ActiveImage.Width = ActiveImage.Width + OffsetX
                        ActiveImage.level = ActiveImage.level + OffsetY

                    Case vbMiddleButton    ' scrolling
                        ActiveImage.ScrollX = ActiveImage.ScrollX - OffsetX
                        ActiveImage.ScrollY = ActiveImage.ScrollY - OffsetY

                    Case vbRightButton    ' zooming around mouse location
                        Dim newzoom As Single, correction As Single
                        newzoom = ActiveImage.ActualZoom * (1.01 ^ OffsetY)

                        correction = 1 - newzoom / ActiveImage.ActualZoom
                        ActiveImage.ScrollX = ActiveImage.ActualScrollX - (LastPositionX + ActiveImage.ActualScrollX) * correction
                        ActiveImage.ScrollY = ActiveImage.ActualScrollY - (LastPositionY + ActiveImage.ActualScrollY) * correction
                        ActiveImage.Zoom = newzoom

                        ActiveImage.StretchMode = NoStretch

                End Select

            Case mfAddAnnotation
                If LabelDrawing Then
                    CurrentLabel.Width = x - CurrentLabel.Left
                    CurrentLabel.Height = y - CurrentLabel.Top

                    '.Area = RectangleF.FromLTRB(CurrentLabel.Area.Left, CurrentLabel.Area.Top, e.Location.x, e.Location.y)
                    If CurrentLabel.LabelType = doLabelPolygon Or CurrentLabel.LabelType = doLabelPolyLine Then
                        CurrentLabel.AddPoint x, y
                    End If

                ActiveImage.Refresh False
                End If


            Case mfEditAnnotation:
                If CurrentLabel Is Nothing Then Exit Sub

                If Button = vbRightButton Or Button = vbMiddleButton Then

                    ' if left/top (or moving from centre) then move left/top coordinate
                    If LabelEdgeX = -1 Or LabelEdgeX = 0 And LabelEdgeY = 0 Then CurrentLabel.Left = CurrentLabel.Left + OffsetX
                    If LabelEdgeY = -1 Or LabelEdgeX = 0 And LabelEdgeY = 0 Then CurrentLabel.Top = CurrentLabel.Top + OffsetY

                    CurrentLabel.Width = CurrentLabel.Width + OffsetX * LabelEdgeX
                    CurrentLabel.Height = CurrentLabel.Height + OffsetY * LabelEdgeY

                    Viewer.Refresh
                End If


            Case mfMagnifyingGlass
                ' if user has strayed onto a different image, then simulate mouse up and then down again - but only for this mouse function.
                If Not ActiveImage Is Nothing Then
                    SetMagnifier PositionX, PositionY
                End If


            Case mfPixelValues
                SetPixelLabel x, y

            Case mfFreeRotation

                ' just use horizontal movement to rotate
                ActiveImage.angle = ActiveImage.angle + OffsetX

            Case mfRotatePanZoom
                Set Selected3DImage = ActiveImage.Projection

                Select Case Button

                        ' Rotate about vertical and horizontal axes
                    Case vbLeftButton
                        Selected3DImage.Rotate OffsetX / 2#, 0, -1, 0
                        Selected3DImage.Rotate OffsetY / 2#, 1, 0, 0

                        ' Pan
                    Case vbMiddleButton
                        Selected3DImage.TranslatePixels OffsetX, OffsetY

                        ' up/down = Zoom
                        ' Left/right = Rotate about Z axis
                    Case vbRightButton
                        Selected3DImage.Rotate OffsetX / 2#, 0, 0, 1
                        Selected3DImage.Zoom 1 + OffsetY / 200#

                End Select

            Case mfCrop
                Set Selected3DImage = ActiveImage.Projection
                Select Case Button
                        '  Move Rectangle/Line Crop label
                    Case vbRightButton, vbLeftButton    '   This needs to be working for both mouse buttons!
                        'Case
                        If Not CropLabel Is Nothing Then
                            CropLabel.Width = x - CropLabel.Left
                            CropLabel.Height = y - CropLabel.Top
                        End If

                        '  Rotate about vertical and horizontal axes
                    Case vbMiddleButton
                        Selected3DImage.Rotate OffsetX / 2, 0, -1, 0
                        Selected3DImage.Rotate OffsetY / 2, 1, 0, 0
                End Select

                ActiveImage.Refresh False
        End Select
    End If
    LastPositionX = x
    LastPositionY = y
End Sub

Private Sub Viewer_MouseUp(Button As Integer, Shift As Integer, x As Long, y As Long)

    Select Case mouseFunction

        Case mfwindowing
            If DisableSmoothing.Value Then SetSmoothingAll SmoothImages.Value

        Case mfMagnifyingGlass
            EndMagnifier

        Case mfPixelValues
            If Not PixelValueLabel Is Nothing Then Viewer.Labels.Remove Viewer.Labels.IndexOf(PixelValueLabel)
            Set PixelValueLabel = Nothing

        Case mfAddAnnotation

            ' handle angle separately as it uses TWO lines
            If LabelForm.isAngle() Then
                If FirstLineLabel Is CurrentLabel Then    ' this is the first - leave in viewer units
                    Set CurrentLabel = Nothing
                    Exit Sub
                Else
                    MoveLabelViewerToImage FirstLineLabel, LabelForm.ScaleMode
                    If Not ValueLabel Is Nothing Then    'Measure
                        ValueLabel.Left = LastPositionX
                        ValueLabel.Top = LastPositionY
                        ValueLabel.Width = 150
                        ValueLabel.Height = 100
                        Dim angle As Long
                        angle = (ArcTan2(FirstLineLabel.Height, FirstLineLabel.Width) - ArcTan2(CurrentLabel.Height, CurrentLabel.Width)) * 180 / Pi
                        ValueLabel.Text = angle
                        MoveLabelViewerToImage ValueLabel, LabelForm.ScaleMode
                        Set ValueLabel = Nothing
                    End If
                    
                    Set FirstLineLabel = Nothing
                End If
            End If

            LabelDrawing = False

            If LabelForm.ScaleMode = doLabelScaleOutput Then  ' attach currentlabel to viewer
                Viewer.Labels.Add CurrentLabel
            Else    ' attach currentlabel to target image
                If Not ActiveImage Is Nothing Then
                    MoveLabelViewerToImage CurrentLabel, LabelForm.ScaleMode
                
                    If Not ValueLabel Is Nothing Then    'Measure
                        ValueLabel.Left = LastPositionX
                        ValueLabel.Top = LastPositionY
                        ValueLabel.Width = 150
                        ValueLabel.Height = 100
                        
                        If CurrentLabel.LabelType = doLabelLine Or CurrentLabel.LabelType = doLabelPolyLine Then
                        'Displays the length of a line drawn by the measure function in the ROIDistanceUnits
                        ValueLabel.Text = CurrentLabel.ROILength & CurrentLabel.ROIDistanceUnits
                        Else
                        'Displays the area encaptured by a rectangle drawn usuing the measure function. Units are set as ROIDistnaceUnits
                        ValueLabel.Text = CurrentLabel.ROIArea & " square " & CurrentLabel.ROIDistanceUnits & "Mean value = " & CurrentLabel.ROIMean
                        End If
                    MoveLabelViewerToImage ValueLabel, LabelForm.ScaleMode
                    Set ValueLabel = Nothing
                    End If
                End If
            End If

            If CurrentLabel.LabelType = doLabelText Then
                CurrentLabel.FontSize = LabelForm.Font.Size
                CurrentLabel.FontName = LabelForm.Font.Name
                CurrentLabel.Text = InputBox("Enter Label Text", "DicomObjects.NET Label Example", "", 500, 500)
            End If
            Set CurrentLabel = Nothing

        Case mfEditAnnotation
            MoveLabelViewerToImage CurrentLabel, LabelForm.ScaleMode    ' - could be saved version
            Set CurrentLabel = Nothing


        Case mfCrop
            Dim Selected3DImage As DicomProjection
            Set Selected3DImage = ActiveImage.Projection

            If Not Selected3DImage Is Nothing Then
            
                'Rescale the label to the active image before crop
                CropLabel.Rescale ActiveImage, doLabelScaleImage
                
                '  Only valid for MIP and VR
                Selected3DImage.Cut CropLabel   ' Doesn't seem to be working at the moment!
                
                'clear up labels
                Viewer.Labels.Clear
                Set CropLabel = Nothing
                
                
            End If
    End Select
    Set ActiveImage = Nothing
    UpdateInformation
End Sub

' other checked code

Sub MoveLabelViewerToImage(label As DicomLabel, newMode As doScaleMode)

    If label Is Nothing Then Exit Sub

    Viewer.Labels.Remove Viewer.Labels.IndexOf(label)
    ActiveImage.Labels.Add label
    label.Rescale ActiveImage, newMode
    label.ForeColour = LabelForm.ForeColour.BackColor
    Viewer.Refresh
End Sub

Sub MoveLabelImageToViewer(label As DicomLabel)

    If label Is Nothing Then Exit Sub

    label.Rescale ActiveImage, doLabelScaleOutput
    ActiveImage.Labels.Remove ActiveImage.Labels.IndexOf(label)
    Viewer.Labels.Add label
    label.ForeColour = vbGreen
    Viewer.Refresh
End Sub

Sub EnableCinemodeToolbar()
    Dim cine As Boolean
    cine = GetSelectedImage() Is Nothing And GetSelectedImage().FrameCount > 1

    cine_Endof_BTN = cine
    cine_Oscillate_BTN = cine
    cine_Play_BTN = cine
    cine_Repeat_BTN = cine
    cine_Reverse_BTN = cine
    cine_Startof_BTN = cine
    cine_Stop_BTN = cine
    cine_Endof_BTN = cine

End Sub


Sub UpdateMarkers()
    Dim Image As DicomImage, l As DicomLabel
    For Each Image In Viewer.Images

        ' remove existing
        CleanLabels Image.Labels, "MARKER"


        If AnatomicMarkers.Value Then

            Set l = MarkerLabel(Image)
            l.Left = 0.05
            l.Top = 0.3
            l.Text = "LEFT"
            l.Alignment = doAlignMiddleLeft

            Set l = MarkerLabel(Image)
            l.Left = 0.3
            l.Top = 0.05
            l.Text = "TOP"
            l.Alignment = doAlignCentre

            Set l = MarkerLabel(Image)
            l.Left = 0.55
            l.Top = 0.3
            l.Text = "RIGHT"
            l.Alignment = doAlignMiddleRight

            Set l = MarkerLabel(Image)
            l.Left = 0.3
            l.Top = 0.55
            l.Text = "BOTTOM"
            l.Alignment = doAlignBottomCentre

        End If
    Next
End Sub


Function MarkerLabel(Image As DicomImage) As DicomLabel

    Set MarkerLabel = New DicomLabel

    MarkerLabel.LabelType = doLabelSpecial
    MarkerLabel.ScaleMode = doLabelScaleCell
    MarkerLabel.FontSize = 30
    MarkerLabel.Width = 0.4
    MarkerLabel.Height = 0.4
    MarkerLabel.ForeColour = vbRed
    MarkerLabel.Tag = "MARKER"

    Image.Labels.Add MarkerLabel

End Function

Sub CleanLabels(Labels As DicomLabels, Tag As String)
    Dim i As Integer
    For i = Labels.Count To 1 Step -1
        If Labels(i).Tag = Tag Then Labels.Remove i
    Next

End Sub
Sub UpdateRulers()
    Dim Image As DicomImage
    For Each Image In Viewer.Images
        CleanLabels Image.Labels, "RULER"
        If ShowRuler.Value Then
            Dim label As New DicomLabel
            label.LabelType = doLabelRuler
            label.ScaleMode = doLabelScaleCell
            label.Left = 0.01
            label.Top = 0.2
            label.Width = 0.03
            label.Height = 0.6
            label.ForeColour = vbCyan

            label.Tag = "RULER"
            Image.Labels.Add label
        End If
    Next
End Sub


Sub LoadImages(Collection As DicomImages, Filename As String)
    Dim Filenames, i As Integer

    Filenames = Split(Filename, vbNullChar)

    If UBound(Filenames, 1) = 0 Then    ' single file
        Collection.ReadFile Filename
    Else
        For i = 1 To UBound(Filenames, 1)    ' multiple files
            Collection.ReadFile Filenames(0) + "\" + Filenames(i)
        Next
    End If
End Sub

Sub SetSelectedImage(Image As DicomImage)
    Set SelectedImage = Image
    If Not SelectedImage Is Nothing Then
        UpdateControls
        StretchToFit.Value = IIf(SelectedImage.StretchMode = NoStretch, 0, 1)
        SelectedImage.BorderColour = vbRed
        SelectedImage.BorderWidth = 1
    End If
End Sub

Sub UpdateControls()
    Dim ImageIs3D As Boolean
    Dim i As Integer

    ImageIs3D = Not SelectedImage Is Nothing And SelectedImage.mode <> 0  ' 0 = 2D
    TabHolder2D3D.Tab = IIf(ImageIs3D, 1, 0)

    ' 2D
    For i = 1 To 5
        MouseFunctionOption(i).Enabled = Not ImageIs3D
    Next

    ' 3D
    For i = 7 To 8
        MouseFunctionOption(i).Enabled = ImageIs3D
    Next

End Sub
Sub SetSmoothingAll(Smooth As Boolean)

' this is a simple version for the demo - other smoothing modes exist
    If Smooth Then
        UpdateSmoothing doFilterMovingAverage, doFilterBSpline
    Else
        UpdateSmoothing doFilterReplicate, doFilterReplicate
    End If

End Sub


Sub UpdateSmoothing(min As doFilterMode, Mag As doFilterMode)
    Dim Image As DicomImage

    For Each Image In Viewer.Images
        Image.MagnificationMode = Mag
        Image.MinificationMode = min
    Next

End Sub
Sub EndMagnifier()
    If Not MagnifierImage Is Nothing Then
        Viewer.Images.Remove Viewer.Images.IndexOf(MagnifierImage)
        Set MagnifierImage = Nothing
        Viewer.Refresh
    End If
End Sub

Sub SetMagnifier(ByVal x As Single, ByVal y As Single)

    Const MagnifierSize = 100
    Dim x1 As Single, y1 As Single

    If Not ActiveImage Is Nothing Then
        If MagnifierImage Is Nothing Then
            Viewer.AutoDisplay = False
            Viewer.Images.Add ActiveImage
            Viewer.AutoDisplay = True
            Set MagnifierImage = Viewer.Images(Viewer.Images.Count)
            MagnifierImage.StretchMode = NoStretch
            MagnifierImage.Zoom = ActiveImage.ActualZoom * 2
            MagnifierImage.Labels.Clear
        End If

        If Viewer.ImageIndex(x, y) <> 0 Then

            ' image coordinates
            x1 = Viewer.ImageXPosition(x, y)
            y1 = Viewer.ImageYPosition(x, y)

            MagnifierImage.ScrollX = x1 * MagnifierImage.ActualZoom - MagnifierSize / 2
            MagnifierImage.ScrollY = y1 * MagnifierImage.ActualZoom - MagnifierSize / 2

            'now move the magnify viewer within the main viewer
            MagnifierImage.Left = (x - MagnifierSize / 2) * 1000 / Viewer.Width
            MagnifierImage.Top = (y - MagnifierSize / 2) * 1000 / Viewer.Height
            MagnifierImage.Right = (x + MagnifierSize / 2) * 1000 / Viewer.Width
            MagnifierImage.Bottom = (y + MagnifierSize / 2) * 1000 / Viewer.Height

        End If
    End If
End Sub

Sub UpdateInformation()

    Dim Image As DicomImage, i As Integer, l As DicomLabel
    For Each Image In Viewer.Images

        CleanLabels Image.Labels, "INFO"

        If ShowPatientAndExamDetails.Value = 1 Then
            Set l = DataLabel(Image)
            l.Left = 0.01
            l.Top = 0.01
            l.Text = Image.Name + vbCrLf + Format(Image.DateOfBirth)
            l.Alignment = doAlignLeft    ' top left

            Set l = DataLabel(Image)
            l.Left = 0.5
            l.Top = 0.01
            l.Text = Image.StudyDescription + vbCrLf + Format(Image.Attributes(&H8, &H20).Value) + vbCrLf + Format(Image.Attributes(&H8, &H30).Value)
            l.Alignment = doAlignRight    ' top right

            Set l = DataLabel(Image)
            l.Left = 0.01
            l.Top = 0.5
            l.Text = Image.Attributes(&H8, &H60).Value + vbCrLf + Image.Attributes(&H8, &H70).Value + vbCrLf + Image.Attributes(&H8, &H80).Value
            l.Alignment = doAlignBottomLeft

            Set l = DataLabel(Image)
            l.Left = 0.5
            l.Top = 0.5
            l.Text = "Frame: " + Str(Image.Frame) + vbCrLf + "Centre: " + Str(Image.level) + vbCrLf + "Width: " + Str(Image.Width) + vbCrLf + "Zoom: " + Str(Image.ActualZoom)
            l.Alignment = doAlignBottomRight
        End If
    Next
    Viewer.Refresh

End Sub

Sub SetPixelLabel(x As Long, y As Long)
    If PixelValueLabel Is Nothing Then
        Set PixelValueLabel = New DicomLabel
        PixelValueLabel.LabelType = doLabelText
        PixelValueLabel.ScaleMode = doLabelScaleOutput
        PixelValueLabel.ForeColour = vbGreen
        Viewer.Labels.Add PixelValueLabel
    End If

    'Calculate Pixel location on current image
    If Not ActiveImage Is Nothing Then
        Dim l As New DicomLabel
        l.LabelType = doLabelRectangle
        l.Left = x
        l.Top = y
        l.Width = 1
        l.Height = 1
        l.ScaleMode = doLabelScaleOutput
        Viewer.Labels.Add l
        l.Rescale ActiveImage, doLabelScaleImage
        Viewer.Labels.Remove Viewer.Labels.Count

        ActiveImage.Labels.Add l
        l.Left = Int(l.Left)
        l.Top = Int(l.Top)
        l.Width = 1
        l.Height = 1

        PixelValueLabel.Text = "[X : " & Str(x) & " Y : " & Str(y) & vbCrLf & "Pixel Value : " & Str(l.ROIMean)
        ActiveImage.Labels.Remove ActiveImage.Labels.Count

    Else
        PixelValueLabel.Text = "No image under cursor."
    End If

    PixelValueLabel.Left = x
    PixelValueLabel.Top = y + 30
    PixelValueLabel.Width = 1000
    PixelValueLabel.Height = 100

    Viewer.Refresh

End Sub

Function DataLabel(Image As DicomImage) As DicomLabel

    Set DataLabel = New DicomLabel
    DataLabel.LabelType = doLabelText
    DataLabel.ScaleMode = doLabelScaleCell
    DataLabel.FontSize = 20
    DataLabel.Width = 0.49
    DataLabel.Height = 0.49

    DataLabel.ForeColour = vbYellow
    DataLabel.Margin = 8
    DataLabel.Tag = "INFO"

    Image.Labels.Add DataLabel

End Function


Private Function GetSelectedImage() As DicomImage
    If SelectedImage Is Nothing Then
        If Viewer.Images.Count > 0 Then
            Set SelectedImage = Viewer.CurrentImage
        Else
            Set SelectedImage = New DicomImage    ' to avoid crashes if no images
        End If
    End If
    
    Set GetSelectedImage = SelectedImage

End Function


' end of checked code


Private Sub AboutThisExample_Click()
    AboutBox.Show 1, Me
End Sub

Private Sub ApplyPresentationState_Click()
    CommonDialog.Filename = ""
    CommonDialog.ShowOpen
    If CommonDialog.Filename <> "" Then
        Dim dds As New DicomDataSets
        GetSelectedImage().PresentationState = dds.ReadFile(CommonDialog.Filename)
        Viewer_OnDataChanged  ' to update sliders
    End If
End Sub

Private Sub CropToLastLabel_Click()
    Dim Image As DicomImage
    Set Image = GetSelectedImage()
    If Not Image Is Nothing Then
        Dim label As DicomLabel
        Set label = Image.Labels(Image.Labels.Count)
        If Not label Is Nothing Then
            Dim CroppedImage As DicomImage
            Set CroppedImage = Image.SubImage(label.Left, label.Top, label.Width, label.Height, 1, 1)

            Viewer.AutoDisplay = True
            Viewer.Images.Add CroppedImage
        End If
    End If
End Sub

Private Sub DeleteAll_Click()
    Viewer.Images.Clear
End Sub

Private Sub DeleteSelectedImage_Click()
    Viewer.Images.Remove Viewer.Images.IndexOf(GetSelectedImage())
    Set SelectedImage = Nothing
End Sub

Private Sub DirectX_Click()
    Viewer.PreferredViewerMode = doViewerModeDirectX
    Dim DG As New DicomGlobal
    '   For generating bitmaps
    DG.PreferredBitmapMode = doViewerModeDirectX
End Sub

Private Sub Exit_Click()
    End
End Sub

Private Sub exportToNonDICOMFile_Click()
    CommonDialog.Filename = ""
    CommonDialog.Filter = "Photos & Cine (*.bmp,*.jpg,*.avi,*.mp4,*.mpeg,*.mpg)|*.bmp;*.dib;*.jpg;*.avi;*.mp4;*.mpeg;*.mpg"
    CommonDialog.ShowSave
    If CommonDialog.Filename <> "" Then
        GetSelectedImage().FileExport CommonDialog.Filename, ""
    End If
End Sub    '

Private Sub GDI_Click()
    Viewer.PreferredViewerMode = doViewerModeGdi
    Dim DG As New DicomGlobal
    '   For generating bitmaps
    DG.PreferredBitmapMode = doViewerModeGdi
End Sub

Private Sub ImageInformation_Click()
    Information.AttributeList.Text = DicomToText()
    Information.Visible = True
End Sub

Function DicomToText() As String
    Dim Image As DicomImage
    Dim q As String
    If (Viewer.Images.Count > 0) Then
        q = ""
        If (Not IsNull(GetSelectedImage.Command)) Then
            AppendAttributes q, "", GetSelectedImage.Command.Attributes
        End If
        AppendAttributes q, "", GetSelectedImage.Attributes
        DicomToText = q
    Else
        DicomToText = "No Image available"
    End If
End Function

Private Sub importFromNonDICOMFile_Click()
    CommonDialog.Filename = ""
    CommonDialog.Filter = "Photos & Cine (*.bmp,*.jpg,*.avi,*.mp4,*.mpeg,*.mpg)|*.bmp;*.dib;*.jpg;*.avi;*.mp4;*.mpeg;*.mpg"
    CommonDialog.ShowOpen
    If CommonDialog.Filename <> "" Then
        Dim i As New DicomImage
        i.FileImport CommonDialog.Filename, ""
        Viewer.Images.Add i
    End If
End Sub


Private Sub MakeNewImage_Click()
    Dim DG As New DicomGlobal
    Dim Image As New DicomImage
    Dim i As Integer, j As Integer, s As Integer, r As Integer
    r = 50
    s = 256
    Image.Name = "test"
    Image.PatientID = "test image001"
    Image.DateOfBirth = Now
    Image.InstanceUID = DG.NewUID
    Image.SeriesUID = DG.NewUID
    Image.StudyUID = DG.NewUID
    
    Image.Attributes.Add &H8, &H60, "OT" 'Modality
    Image.Attributes.Add &H8, &H16, doSOP_SecondaryCapture
    Image.Attributes.Add &H28, &H2, 1    ' samples/pixel
    Image.Attributes.Add &H28, &H4, "MONOCHROME2"    ' photometric interpreation
    Image.Attributes.Add &H28, &H10, s    'x
    Image.Attributes.Add &H28, &H11, s    'Y
    Image.Attributes.Add &H28, &H100, 8    'bits allocated
    Image.Attributes.Add &H28, &H101, 8    ' bits stored
    Image.Attributes.Add &H28, &H102, 7    ' high bit
    ReDim pix(s, s) As Byte
    For i = 1 To s
        For j = 1 To s
            pix(i, j) = (i + j) / 2 Mod 256
        Next
    Next
    For i = -r To r
        For j = -r To r
            If i * i + j * j < r * r Then pix(i + s / 2, j + s / 2) = Sqr((i * i + j * j) / (r * r)) * 255
        Next
    Next

    Image.Attributes.Add &H7FE0, &H10, pix
    Viewer.Images.Add Image
End Sub

Private Sub Options_Click()
    OptionsBox.Show
End Sub

Private Sub PrintDICOM_Click()
    Dim printer As New DicomPrint, Image As DicomImage
    printer.Colour = OptionsBox.PrintInColour.Value
    printer.Node = OptionsBox.PrintNode
    printer.Port = OptionsBox.PrintPort
    printer.CalledAE = OptionsBox.PrintAE
    printer.CallingAE = OptionsBox.PrintCallingAE
    printer.Open

    printer.Format = OptionsBox.PrintFormat
    printer.Orientation = OptionsBox.PrintOrientation
    printer.FilmSize = OptionsBox.FilmSize
    printer.FilmBox.Attributes.Add &H2010, &H60, OptionsBox.Magnification

    For Each Image In Viewer.Images
        printer.PrintImage Image, False, True
    Next
    printer.Close
End Sub

Private Sub PrintWindows_Click()
' This routine prints only a single image
' printing other formats is very easy and flexible
' This trivial example prints (almost) full width across a sheet

    Dim w As Long, H As Long
    Dim Image As DicomImage

    Set Image = Viewer.CurrentImage
    w = printer.Width - 400
    H = w * Image.SizeY / Image.SizeX

    printer.PaintPicture Image.Picture, 200, 200, w, H
    printer.EndDoc
End Sub

Private Sub QueryRetrieve_Click()
    RetrieveBox.LoadPatients OptionsBox
End Sub

Private Sub SendAllCSTORE_Click()
    Dim res As Long
    Dim im As DicomImage
    For Each im In Viewer.Images
        res = im.Send(OptionsBox.StorageNode, OptionsBox.StoragePort, OptionsBox.CallingAE, OptionsBox.StorageAE)
        If res <> 0 Then
            MsgBox "Send failed - code " & res
            Exit For
        End If
    Next
End Sub

Private Sub SendSelectedCSTORE_Click()
    MsgBox "Result code = " & GetSelectedImage().Send(OptionsBox.StorageNode, OptionsBox.StoragePort, OptionsBox.CallingAE, OptionsBox.StorageAE)
End Sub

Private Sub ShowLoggingOptions_Click()
    OptionsBox.tabControl.Tab = 5
    OptionsBox.Show
End Sub


Private Sub VerifyCECHO_Click()
    Dim g As New DicomGlobal
    Dim result As Integer

    result = g.Echo(OptionsBox.StorageNode, OptionsBox.StoragePort, OptionsBox.CallingAE, OptionsBox.StorageAE)
    MsgBox "Verify returned status: " & hex4(result)
End Sub


Private Sub Viewer_MouseWheel(ByVal Shift As Long, ByVal Delta As Integer, ByVal x As Long, ByVal y As Long)
    If Not SelectedImage Is Nothing Then
        Select Case GetWheelFunction
            Case Volume
                SelectedImage.Projection.TranslateNormal Sgn(Delta) * 2    '' 2mm increments
            Case nextImage
                Viewer.CurrentIndex = max(1, min(Viewer.Images.Count, Viewer.CurrentIndex + Sgn(Delta)))
            Case cine
                GetSelectedImage().Frame = max(1, min(GetSelectedImage().FrameCount, GetSelectedImage().Frame + Sgn(Delta)))
        End Select
    End If
End Sub

Function GetWheelFunction() As WheelFunction
    If Not SelectedImage Is Nothing Then
        If SelectedImage.mode <> 0 Then
            GetWheelFunction = Volume
        ElseIf SelectedImage.FrameCount > 1 Then
            GetWheelFunction = cine
        Else
            GetWheelFunction = nextImage
        End If
    End If
End Function

Private Sub Viewer_OnDataChanged()
    Dim PreState As Boolean
    Rows.Text = Viewer.MultiRows
    Columns.Text = Viewer.MultiColumns
    CImageIndexSpin.min = Viewer.Images.Count
    
    If Viewer.Images.Count > 0 Then

        CImageIndexSpin.Value = Viewer.CurrentIndex
        PreState = Not GetSelectedImage().PresentationState Is Nothing
        StretchToFit.Visible = Not PreState
        StretchToFit.Value = IIf(GetSelectedImage().StretchMode = NoStretch, 0, 1)
    Else
        StretchToFit.Visible = False
    End If

    UpdateMarkers
    UpdateInformation
    UpdateRulers
    EnableCinemodeToolbar
End Sub

Private Sub Viewer_OnDisplayChanged()
    Dim WheelNames
    WheelNames = Array("Move View Plane", "Change Image", "Change Cine Frame")
    MouseWheelFunction.Caption = WheelNames(GetWheelFunction())

End Sub

Private Sub VR_Click()
    Set3DMode doVR
End Sub

Private Sub Write_Click()
    CommonDialog.Filename = ""
    CommonDialog.ShowSave
    If CommonDialog.Filename <> "" Then
        GetSelectedImage().WriteFile CommonDialog.Filename, True, GetSelectedImage.ReceivedSyntax
    End If
End Sub
