VERSION 5.00
Object = "{D1C00008-F528-4513-A681-386B6F2F74E1}#8.0#0"; "DicomObjects.8.32.ocx"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form Form1 
   Caption         =   "3D View demo"
   ClientHeight    =   12060
   ClientLeft      =   120
   ClientTop       =   465
   ClientWidth     =   11475
   LinkTopic       =   "Form1"
   ScaleHeight     =   12060
   ScaleWidth      =   11475
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Reset 
      Caption         =   "Reset"
      Height          =   720
      Left            =   6720
      TabIndex        =   5
      Top             =   100
      Width           =   4215
   End
   Begin MSComDlg.CommonDialog CommonDialog 
      Left            =   5520
      Top             =   240
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      Flags           =   2621952
      MaxFileSize     =   32767
   End
   Begin VB.CommandButton Load 
      Caption         =   "Load 3D"
      Height          =   660
      Left            =   720
      TabIndex        =   4
      Top             =   90
      Width           =   4335
   End
   Begin DicomObjects8.DicomViewer ViewerCO 
      Height          =   5295
      Left            =   240
      TabIndex        =   0
      Top             =   999
      Width           =   5415
      _Version        =   524288
      _ExtentX        =   9551
      _ExtentY        =   9340
      _StockProps     =   35
   End
   Begin DicomObjects8.DicomViewer ViewerAX 
      Height          =   5295
      Left            =   240
      TabIndex        =   1
      Top             =   6600
      Width           =   5415
      _Version        =   524288
      _ExtentX        =   9551
      _ExtentY        =   9340
      _StockProps     =   35
   End
   Begin DicomObjects8.DicomViewer ViewerSG 
      Height          =   5295
      Left            =   5880
      TabIndex        =   2
      Top             =   999
      Width           =   5415
      _Version        =   524288
      _ExtentX        =   9551
      _ExtentY        =   9340
      _StockProps     =   35
   End
   Begin DicomObjects8.DicomViewer ViewerVR 
      Height          =   5295
      Left            =   5880
      TabIndex        =   3
      Top             =   6600
      Width           =   5415
      _Version        =   524288
      _ExtentX        =   9551
      _ExtentY        =   9340
      _StockProps     =   35
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'  World Rotation and Translation Demo (Double oblique)
'  We have 3 views, all initially orthogonal (coronal, sagital, axial).
'  When we move or rotate a viewpoint point shown by DicomObjects refence lines in a selected view, we want the other views
'  to reflect the change in orientation and remain orhtogonal to the selected view.
'  This is accomplished by always roating the OTHER views about the screen normal of the current view **IN WORLD SPACE**.
'  This is done by using a new DicomImage method RotateWorld, that takes an orientation vector in addition
'  to the standard rotate method in order to apply the resulting operation in absolute world space. This vector is always
'  the screen normal of the selected view.
'  So to simplify: we move the mouse in Viewer1 then call RotateWorld of Viewer2 and Viewer3 images by an angle (from the
'  mouse.X delta) about the screen normal of viewer 1.

'  See MouseMove - Button = 2 part below


Dim iCO As DicomImage, iSG As DicomImage, iAX As DicomImage, iVR As DicomImage
Dim lastX  As Integer, lastY As Integer
Dim norm As Variant, Volume As DicomVolume, lastWorldPoint(0 To 2) As Single, p3D As Variant, xDelta As Single

Private Sub Load_Click()
    Dim Collection As New DicomImages, refLine As DicomLabel

    ViewerCO.Images.Clear
    ViewerSG.Images.Clear
    ViewerAX.Images.Clear
    ViewerVR.Images.Clear
    
    CommonDialog.MaxFileSize = 32767
    CommonDialog.DialogTitle = "Open a single File containing a Multi-Frame DicomImage, or multiple single images using shift-key for multi-select"
    
    CommonDialog.ShowOpen
    
    If CommonDialog.Filename <> "" Then

        MousePointer = vbHourglass

        LoadImages Collection, CommonDialog.Filename
        If Collection.Count = 1 Then
            Set Volume = Collection(1).MakeVolume(1)
        Else
            Set Volume = Collection.MakeVolume(1)
        End If
        
        '  Set volume boundary colour
        Volume.SetBorderColour vbRed, vbCyan, vbYellow, vbGreen
        
        ' Load 3 3D images from the same volume on 3 different viewers
        Set iCO = Volume.Make3D(doMPR)
        Set iSG = Volume.Make3D(doMPR)
        Set iAX = Volume.Make3D(doMPR)
        Set iVR = Volume.Make3D(doVR)

        '   Set View planes
        Reset_Click
        
        ViewerCO.Images.Add iCO
        ViewerSG.Images.Add iSG
        ViewerAX.Images.Add iAX
        ViewerVR.Images.Add iVR
                
        '   Coronal
        Set refLine = New DicomLabel
        refLine.LabelType = doLabelReferenceLine
        Set refLine.ReferenceImage = iSG
        refLine.ForeColour = vbRed
        iCO.Labels.Add refLine
        
        Set refLine = New DicomLabel
        refLine.LabelType = doLabelReferenceLine
        Set refLine.ReferenceImage = iAX
        refLine.ForeColour = vbYellow
        iCO.Labels.Add refLine
        
        '   Sagittal
        Set refLine = New DicomLabel
        refLine.LabelType = doLabelReferenceLine
        Set refLine.ReferenceImage = iCO
        refLine.ForeColour = vbBlue
        iSG.Labels.Add refLine
        
        Set refLine = New DicomLabel
        refLine.LabelType = doLabelReferenceLine
        Set refLine.ReferenceImage = iAX
        refLine.ForeColour = vbYellow
        iSG.Labels.Add refLine
        
        '   Axial
        Set refLine = New DicomLabel
        refLine.LabelType = doLabelReferenceLine
        Set refLine.ReferenceImage = iCO
        refLine.ForeColour = vbBlue
        iAX.Labels.Add refLine
        
        Set refLine = New DicomLabel
        refLine.LabelType = doLabelReferenceLine
        Set refLine.ReferenceImage = iSG
        refLine.ForeColour = vbRed
        iAX.Labels.Add refLine

        MousePointer = vbDefault
    End If
End Sub
Sub LoadImages(Collection As DicomImages, Filename As String)
    Dim Filenames, i As Integer

    Filenames = Split(Filename, vbNullChar)

    If UBound(Filenames, 1) = 0 Then    ' single file
        Collection.ReadFile Filename
    Else
        For i = 1 To UBound(Filenames, 1)    ' multiple files
            Collection.ReadFile Filenames(0) + "\" + Filenames(i)
        Next
    End If
End Sub


Private Sub Reset_Click()
    ' centred on image, viewing along Y axis, with -ve Z (top of head) upwards
    iCO.Projection.SetViewPlane doPlaneCoronal, True, 1
    
    ' centred on image, viewing along Z axis, with -ve Z (top of head) upwards
    iSG.Projection.SetViewPlane doPlaneSagittal, True, 1
        
    ' centred on image, viewing along X axis, with -ve Z (top of head) upwards
    iAX.Projection.SetViewPlane doPlaneAxial, True, 1
    
    
    ' centred on image, viewing along Y axis, front view of the volume
    iVR.Projection.SetViewPlane doPlaneCoronal, True, 1
    
    ' Set to default centre viewpoint
    UpdateLastWorldPointFormText Volume.CentreX, Volume.CentreY, Volume.CentreZ
    
End Sub

Private Sub ViewerAX_MouseMove(Button As Integer, Shift As Integer, x As Long, y As Long)
    MouseMove Button, 3, x, y
End Sub

Private Sub ViewerSG_MouseMove(Button As Integer, Shift As Integer, x As Long, y As Long)
    MouseMove Button, 2, x, y
End Sub

Private Sub ViewerCO_MouseMove(Button As Integer, Shift As Integer, x As Long, y As Long)
    MouseMove Button, 1, x, y
End Sub


Private Sub MouseMove(Button As Integer, Viewer As Integer, x As Long, y As Long)
    Debug.Print "Viewer: " & Viewer & "  Button: " & Button
    
    '   To be used for rotation offset so it doesn't always increase
    xDelta = x - lastX
    
    '   Make less responsive to Mouse movement, you can adjust this to see what feels best
    xDelta = xDelta / 100
    
    
    If Button = 1 Then
        If Viewer = 1 Then
              ' ViewerCO
            p3D = iCO.Projection.ScreenToWorld(x, y)
            iSG.Projection.TranslateNormal -iSG.DistanceFromPoint(p3D(0), p3D(1), p3D(2))
            iAX.Projection.TranslateNormal -iAX.DistanceFromPoint(p3D(0), p3D(1), p3D(2))
            ViewerCO.Refresh    '   Force refresh to update Ref Line
            
        ElseIf Viewer = 2 Then
              ' ViewerSG
            p3D = iSG.Projection.ScreenToWorld(x, y)
            iAX.Projection.TranslateNormal -iAX.DistanceFromPoint(p3D(0), p3D(1), p3D(2))
            iCO.Projection.TranslateNormal -iCO.DistanceFromPoint(p3D(0), p3D(1), p3D(2))
            ViewerSG.Refresh    '   Force refresh to update Ref Line
            
        ElseIf Viewer = 3 Then
              ' ViewerAX
            p3D = iAX.Projection.ScreenToWorld(x, y)
            iSG.Projection.TranslateNormal -iSG.DistanceFromPoint(p3D(0), p3D(1), p3D(2))
            iCO.Projection.TranslateNormal -iCO.DistanceFromPoint(p3D(0), p3D(1), p3D(2))
            ViewerAX.Refresh    '   Force refresh to update Ref Line
        End If
            
        UpdateLastWorldPointFormText p3D(0), p3D(1), p3D(2)
        
    ElseIf Button = 2 Then
    
        If Viewer = 1 Then
              ' ViewerCO
            norm = iCO.Projection.ScreenNormal
        
            iSG.Projection.RotateWorld xDelta, norm(0), norm(1), norm(2), lastWorldPoint(0), lastWorldPoint(1), lastWorldPoint(2)
            iAX.Projection.RotateWorld xDelta, norm(0), norm(1), norm(2), lastWorldPoint(0), lastWorldPoint(1), lastWorldPoint(2)
            ViewerCO.Refresh    '   Force refresh to update Ref Line
            
        ElseIf Viewer = 2 Then
              ' ViewerSG
            norm = iSG.Projection.ScreenNormal
        
            iCO.Projection.RotateWorld xDelta, norm(0), norm(1), norm(2), lastWorldPoint(0), lastWorldPoint(1), lastWorldPoint(2)
            iAX.Projection.RotateWorld xDelta, norm(0), norm(1), norm(2), lastWorldPoint(0), lastWorldPoint(1), lastWorldPoint(2)
            ViewerSG.Refresh    '   Force refresh to update Ref Line
            
        ElseIf Viewer = 3 Then
              ' ViewerAX
            norm = iAX.Projection.ScreenNormal
        
            iCO.Projection.RotateWorld xDelta, norm(0), norm(1), norm(2), lastWorldPoint(0), lastWorldPoint(1), lastWorldPoint(2)
            iSG.Projection.RotateWorld xDelta, norm(0), norm(1), norm(2), lastWorldPoint(0), lastWorldPoint(1), lastWorldPoint(2)
            ViewerAX.Refresh    '   Force refresh to update Ref Line
        End If
        
        '   This only makes sense once you decide on how to synchronise the 3D orientation.
        '   For e.g tie it to one of the viewers, and reset it when the other views are reset.
        iVR.Projection.RotateWorld xDelta, norm(0), norm(1), norm(2), lastWorldPoint(0), lastWorldPoint(1), lastWorldPoint(2)
    
    End If
    
    lastX = x
End Sub

Sub UpdateLastWorldPointFormText(ByVal x As Single, ByVal y As Single, ByVal Z As Single)
    lastWorldPoint(0) = x
    lastWorldPoint(1) = y
    lastWorldPoint(2) = Z
    Form1.Caption = "Last World Point: (" & lastWorldPoint(0) & ", " & lastWorldPoint(1) & ", " & lastWorldPoint(2) & ")"
End Sub
