VERSION 5.00
Begin VB.Form QueryRouterForm 
   Caption         =   "QueryRouter"
   ClientHeight    =   3564
   ClientLeft      =   60
   ClientTop       =   348
   ClientWidth     =   5772
   LinkTopic       =   "Form1"
   ScaleHeight     =   3564
   ScaleWidth      =   5772
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame1 
      Caption         =   "Retrieval method from main server"
      Height          =   735
      Left            =   360
      TabIndex        =   9
      Top             =   2520
      Width           =   4935
      Begin VB.OptionButton CGET 
         Caption         =   "C-GET"
         Height          =   255
         Left            =   2160
         TabIndex        =   11
         Top             =   360
         Width           =   1695
      End
      Begin VB.OptionButton CMOVE 
         Caption         =   "C-MOVE"
         Height          =   255
         Left            =   360
         TabIndex        =   10
         Top             =   360
         Value           =   -1  'True
         Width           =   1695
      End
   End
   Begin VB.Frame ServerDetails 
      Caption         =   "Main Server Details"
      Height          =   2175
      Left            =   360
      TabIndex        =   0
      Top             =   240
      Width           =   4935
      Begin VB.TextBox RemoteAE 
         Height          =   285
         Left            =   2520
         TabIndex        =   4
         Text            =   "Server"
         Top             =   1200
         Width           =   1815
      End
      Begin VB.TextBox RemotePort 
         Height          =   285
         Left            =   2520
         TabIndex        =   3
         Text            =   "104"
         Top             =   840
         Width           =   1815
      End
      Begin VB.TextBox RemoteIP 
         Height          =   285
         Left            =   2520
         TabIndex        =   2
         Text            =   "localhost"
         Top             =   480
         Width           =   1815
      End
      Begin VB.TextBox CallingAE 
         Height          =   285
         Left            =   2520
         TabIndex        =   1
         Text            =   "Router"
         Top             =   1560
         Width           =   1815
      End
      Begin VB.Label Label3 
         Caption         =   "Remote AE Name"
         Height          =   255
         Left            =   360
         TabIndex        =   8
         Top             =   1200
         Width           =   1815
      End
      Begin VB.Label Label2 
         Caption         =   "Port Number"
         Height          =   255
         Left            =   360
         TabIndex        =   7
         Top             =   840
         Width           =   1695
      End
      Begin VB.Label Label1 
         Caption         =   "Node Name or IP Address"
         Height          =   255
         Left            =   360
         TabIndex        =   6
         Top             =   480
         Width           =   2175
      End
      Begin VB.Label Label6 
         Caption         =   "Calling AE Name to Use"
         Height          =   255
         Left            =   360
         TabIndex        =   5
         Top             =   1560
         Width           =   1815
      End
   End
End
Attribute VB_Name = "QueryRouterForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' This applicatin acts as a "router" for DICOM query/rerieve operations
' Though relatively self-contained, some modification would probably be required
' to make a "real" application

' Incoming requests are accepted (on part 105, not 104 in order to allow use on same machine
' as Access server)

' Requests are then passed on to a "main server", and results are passed back to the client
' as if they had been handled by the router.

' This application could have uses where "standard" DICOM Q/R was difficult due to dynamic
' IP addresses, or where it is necesary to intermix incompatible C-GET & C-MOVE systems
' (this router handles both requests, and can pass through to the server as either.

'  Of course, this system lacks the normal security constraints imposed by known AETs, so
' alternative arrangements (probably in server_incoming_AssociationRequest) will be needed

' Server_incoming handles all incoming requests (whether from the client or the C-MOVE responses
'   from the main server)
' server_outgoing is used merely to attach the ActionComplete events for outgoing operatons
'   (all to the mainserver)
' the functions could be combined, but keeping them separate makes the code (slightly) easier to follow

' throughout, the following titles are used for DicomConnection objects for consistency
' note however, that these are NOT global variables, as many instances of each may be active
' simultaneously

' C1 = original incoming association from client (also handles return images, even if C-MOVE used)
' C2 = outgoing association to main server
' C3 = incoming association from main server with C-STORE operations

' To tie these together, the Tag & MoveOriginator properties are used.
' C2.Tag = C1 - this is true throughout request
' C1.Tag = C3 - this is only between receiving an image, and passing back the status

Option Explicit
Dim WithEvents server_incoming As DicomServer
Attribute server_incoming.VB_VarHelpID = -1
Dim WithEvents server_outging As DicomServer
Attribute server_outging.VB_VarHelpID = -1

Private Sub Form_Load()
    Dim listenok As Boolean
    Set server_incoming = New DicomServer
    Set server_outging = New DicomServer
    
    server_incoming.DefaultStatus = &HC000 ' default bad value in case event not handled for some reason
    listenok = server_incoming.Listen(11112)
    If Not listenok Then MsgBox "Listening on port 11112 failed"
End Sub


Private Sub server_incoming_AssociationRequest(ByVal Connection As DicomObjects8.DicomConnection, isOK As Boolean)
    ' This is where security checking of IP addresses and AETS should happen
    ' by default, all associations are accepted
End Sub


Private Sub server_incoming_QueryRequest(ByVal C1 As DicomObjects8.DicomConnection)
    Dim C2 As DicomConnection
    
    Set C2 = server_outging.New("DicomConnection") ' async mode by default
    Set C2.Tag = C1 ' permanent link back to requesting association
    
    'set up necessary presentation contexts (using default transfer syntaxes)
    If C1.Operation = "C-FIND" Then
        C2.Contexts.Add C1.Command.Attributes(0, 2)
    ElseIf C1.Operation = "C-GET" Or C1.Operation = "C-MOVE" Then
        If CMOVE Then
            If C1.Root = "PATIENT" Then
                C2.Contexts.Add doSOP_PatientRootQR_MOVE
            ElseIf C1.Root = "PATIENT/STUDY" Then
                C2.Contexts.Add doSOP_PatientStudyOnlyQR_MOVE
            ElseIf C1.Root = "STUDY" Then
                C2.Contexts.Add doSOP_StudyRootQR_MOVE
            End If
        Else
            ' One of the problems with C-GET is that you need to
            ' know in advance what SOP classes you are likely to be offered
            ' solution here - if there's an incoming C-GET use the uses that you are offered
            ' but if incoming is C-MOVE use a default list
            
            ' If, as is normally the case, you are only using C-MOVE to the main server,
            ' this section can be deleted
            If C1.Operation = "C-GET" Then
                Dim context As DicomContext
                For Each context In C1.Contexts
                    C2.Contexts.Add context.AbstractSyntax
                Next
            Else
                If C1.Root = "PATIENT" Then
                    C2.Contexts.Add doSOP_PatientRootQR_GET
                ElseIf C1.Root = "PATIENT/STUDY" Then
                    C2.Contexts.Add doSOP_PatientStudyOnlyQR_GET
                ElseIf C1.Root = "STUDY" Then
                    C2.Contexts.Add doSOP_StudyRootQR_GET
                End If

                C2.Contexts.Add doSOP_CT
                C2.Contexts.Add doSOP_SecondaryCapture
                C2.Contexts.Add doSOP_MR
                C2.Contexts.Add doSOP_ComputedRadiography
                C2.Contexts.Add doSOP_Ultrasound
                C2.Contexts.Add doSOP_NuclearMedicine
                C2.Contexts.Add doSOP_UltrasoundMultiframe
            End If
                
        End If
        If C1.Operation = "C-MOVE" Then
            ' Here we need to do a lookup on C1.Destination to find the AE to send the images to
            ' This wil lbe implementatin dependent, and probably need a database of some sort, so
            ' for this simple example we assume localhost/port 1111
            
            ' Note that this should be called from the ActionComplete after C2.SetDestination to prevent
            ' the possibility of C1 "blocking" waiting for SetDestination to complete when images are sent
            ' to it, but the likelihood of images being available before a negotiation is complete is small
            ' and delay would be negligible
            C1.SetDestination "localhost", 1111, CallingAE, C1.Destination
        End If
   End If
    'This routine ONLY fires the setdestination call (asynchronously), allowing
    '   other functions while negotiation takes place
    'The "real" request happens from server_outgoing_ActionComplete once the connection is established
    
    C2.SetDestination RemoteIP, RemotePort, CallingAE, RemoteAE
        
End Sub

Private Sub server_outging_ActionComplete(ByVal C2 As DicomObjects8.DicomConnection, ByVal Action As String, ByVal Tag As Variant, ByVal Success As Boolean, ByVal ErrorMessage As String)
    Dim C1 As DicomConnection
    Set C1 = C2.Tag ' used to retrieve quesry details and to pass back C-FIND results
    
    If Not Success Then DoError ErrorMessage
    
    If Action = "SetDestination" Then
        'Fire "main" operation, as a clone of incoming request, altering ONLY requested C-MOVE destination
        If Success Then
            If C1.Operation = "C-FIND" Then
                C2.Find C1.Root, C1.Request
            Else ' incoming is C-GET or C-MOVE, but method used to main server is independent
                If CMOVE Then
                    C2.Move C1.Root, CallingAE, C1.Request
                Else
                    C2.Get C1.Root, C1.Request
                End If
            End If
        End If
    Else ' actions below are grouped, as they all "finish" with C2
        If Success Then
            If Action = "Find" Then
                'This means that a C-FIND operation has completed, so pass back results
                ' Althoug many cleints ignore the field, the results SHOULD contain a field giving the name of the
                ' AET from which the images can be obtained - update this to be current AET, as known
                ' to the client
                
                Dim Result As DicomDataSet
                For Each Result In C2.ReturnedDataSets
                    Result.Attributes.Add 8, &H54, C1.CalledAET
                Next
                C1.SendData C2.ReturnedDataSets, &HFF00 ' pending - final status from server_incoming_ActionComplete
        
            ElseIf Action = "Get" Then
                'This means that a C-GET operation has completed.
                'Results (images) need to be passed back
                C1.SendImages C2.ReturnedImages
                
            ElseIf Action = "Move" Then
                'This means that a C-MOVE operation has completed.
                'Results (images) will already have been passed back via code in
                '   server_incoming_ImageReceivedAsync, so just send status and close C2
                C1.SendStatus 0
                
            End If
        End If
        'C2 is now finished with
        C2.Tag = Nothing
        C2.Close
    End If
End Sub

Private Sub server_incoming_ActionComplete(ByVal C1 As DicomObjects8.DicomConnection, ByVal Action As String, ByVal Tag As Variant, ByVal Success As Boolean, ByVal ErrorMessage As String)
    If Not Success Then DoError ErrorMessage
    If Action = "SendData" Then
        'This fires after C-FIND results have been returned on C1
        If Success Then C1.SendStatus 0
    ElseIf Action = "SendImages" Then
        'Action depends on whether method used from main server is C-MOVE or C-GET
        If CMOVE Then
            ' This fires after a single image has been returned on C1
            ' need here to pass status back to C3
            Dim C3 As DicomConnection
            Set C3 = C1.Tag
            If Success Then C3.SendStatus C1.LastStatus
            Set C1.Tag = Nothing ' help clear ref counts
        Else
            ' This fires after ALL images have been sent, so we need to send status of 0
            If Success Then C1.SendStatus 0
        End If
    End If
End Sub

Private Sub server_incoming_ImageReceivedAsync(ByVal C3 As DicomObjects8.DicomConnection, ByVal Image As DicomObjects8.DicomImage)
    Dim C1 As DicomConnection, C2 As DicomConnection
    
    Set C2 = C3.MoveOriginator
    Set C1 = C2.Tag '- i.e incoming C-GET/MOVE connection
    
    Set C1.Tag = C3 '- server_outging status can be sent
    C1.SendImages Image
End Sub

Sub DoError(msg As String)
    MsgBox msg
End Sub
