VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "PrintSCP"
   ClientHeight    =   4584
   ClientLeft      =   -12
   ClientTop       =   276
   ClientWidth     =   4224
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4584
   ScaleWidth      =   4224
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox Path 
      Height          =   285
      Left            =   120
      TabIndex        =   1
      Text            =   "C:\Temp"
      Top             =   4200
      Width           =   3972
   End
   Begin VB.TextBox Logger 
      Height          =   3732
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   0
      Top             =   120
      Width           =   3972
   End
   Begin VB.Label Label1 
      Caption         =   "File Path to save images to"
      Height          =   252
      Left            =   120
      TabIndex        =   2
      Top             =   3960
      Width           =   2532
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim WithEvents server As DicomServer
Attribute server.VB_VarHelpID = -1
Dim printerobject As DicomDataSet
Dim Datasets As DicomDataSets
Dim g As DicomGlobal
Option Base 1
Dim lut(45) As Long

Private Declare Function GetTempPath Lib "kernel32" _
   Alias "GetTempPathA" _
  (ByVal nSize As Long, _
   ByVal lpBuffer As String) As Long
   
Public Function GetTempDir() As String
    Dim nSize As Long
    Dim buff As String
    buff = Space$(260)
    nSize = Len(buff)
    Call GetTempPath(nSize, buff)
    GetTempDir = TrimNull(buff)
End Function

Private Function TrimNull(item As String)
    Dim pos As Integer
    pos = InStr(item, Chr$(0))
    If pos Then
       TrimNull = left$(item, pos - 1)
    Else
       TrimNull = item
    End If
End Function

Private Sub Log(s As String)
    Logger.Text = Logger.Text & s & vbCrLf
End Sub

Private Sub Form_Load()
    Set server = New DicomServer
    Dim templut As Variant, i As Integer '(1 To 45) As Integer
    server.Listen 104
    Log "Server listens on port 104"
    Set Datasets = New DicomDataSets
    Set g = New DicomGlobal
    Me.Caption = Me.Caption & " DO v" & g.Version
    MakePrinterdataset
    g.RegWord("GdiCaptureMode") = 1
    templut = Array(0, 48, 50, 52, 55, 59, 64, 66, 67, 70, 72, 75, 77, 81, 83, 88, 91, 94, 96, 97, 101, 104, 110, 113, 117, 125, 129, 131, 137, 141, 146, 150, 155, 160, 165, 170, 175, 180, 192, 202, 208, 214, 220, 226, 255)
    For i = LBound(lut) To UBound(lut)
        lut(i) = templut(i) * 256
    Next
    'get temp path
    Path.Text = GetTempDir
End Sub

Function Dataset(class As String, uid As String)
    ' this function would allow youto keep different classes of dataset in different collections if you wished
    Set Dataset = Datasets(uid)
End Function

Function DatasetFromSequence(a As DicomAttribute, n As Integer)
    Dim seq As DicomDataSets, seqitem As DicomDataSet
    Set seq = a.Value
    Set seqitem = seq(n)
    Set DatasetFromSequence = Dataset(seqitem.Attributes(8, &H1150), seqitem.Attributes(8, &H1155))
End Function

Function NewDataSet() As DicomDataSet
    Set NewDataSet = Datasets.AddNew
    Set NewDataSet.Tag = New DicomDataSets
End Function

Sub MakePrinterdataset()
    Dim p As DicomDataSet
    Set p = NewDataSet
    
    p.instanceUID = doInstance_Printer
    p.Attributes.Add &H8, &H16, doSOP_Printer
    p.Attributes.Add &H8, &H70, "Medical Connections"
    p.Attributes.Add &H8, &H1090, "Demo Printer SCP"
    p.Attributes.Add &H18, &H1000, "serial no 1234"
    p.Attributes.Add &H18, &H1020, g.Version
    p.Attributes.Add &H2110, &H10, "Normal"                                      ' Printer Status
    p.Attributes.Add &H2110, &H20, "StatusInfo"                                   ' Printer Status Info
    p.Attributes.Add &H2110, &H30, "PrinterName"                                  ' Printer Name
    p.Attributes.Add &H18, &H1200, "20140723"                                     ' Date of Last Calibration
    p.Attributes.Add &H18, &H1201, "102030"                                       ' Time of Last Calibration
    Set printerobject = p
End Sub

Function DoPrint(ByVal ruid As String) As Long
    Dim filmBox As DicomDataSet
    Dim actionitem As DicomDataSet
    Set actionitem = Datasets(ruid)
    If actionitem.SOPClass = "1.2.840.10008.5.1.1.1" Then ' session
        Dim filmboxes As DicomDataSets
        Set filmboxes = actionitem.Tag
        For Each filmBox In filmboxes
            PrintFilmBox filmBox
        Next
    Else ' filmbox
        Set filmBox = actionitem
        PrintFilmBox filmBox
    End If

    DoPrint = 0 ' should be non-zero on failure
End Function

Sub PrintFilmBox(ByVal filmBox As DicomDataSet)
   Dim image As DicomImage, images As DicomImages, rows As Integer, columns As Integer, row As Integer
    Dim column As Integer, width As Long, height As Long, top As Long, left As Long, zoom As Single, pic As Picture
    Dim vpos As Long, hpos As Long, session As DicomDataSet, orientation As String, dss As DicomDataSets
    Dim copies As Integer, margin As Integer, colour As Long, backcolour As String
    Dim ds2 As DicomDataSet
    Dim imageatt As DicomAttribute

    Set dss = filmBox.Attributes(&H2010, &H510).Value
    Set session = DatasetFromSequence(filmBox.Attributes(&H2010, &H500), 1)
    
    DecodeFormat filmBox.Attributes(&H2010, &H10), columns, rows
    
    copies = session.Attributes(&H2000, &H10)
    Printer.copies = copies
    
    orientation = filmBox.Attributes(&H2010, &H40)
    If orientation = "PORTRAIT" Then
        Printer.orientation = vbPRORPortrait
    Else
        Printer.orientation = vbPRORLandscape
    End If
    
    margin = 150
    top = Printer.ScaleTop
    left = Printer.ScaleLeft
    width = (Printer.ScaleWidth + margin) / columns - margin
    height = (Printer.ScaleHeight + margin) / rows - margin
    
    'do "background"
    If filmBox.Attributes(&H2010, &H100).Exists Then
    
        backcolour = filmBox.Attributes(&H2010, &H100)
    End If
    
        If backcolour = "BLACK" Then
            colour = vbBlack
        Else
            colour = vbWhite
        End If
    
    ' should also do film boxes here using 2010,0110
    
    For row = 1 To rows
        For column = 1 To columns

            Set ds2 = Datasets(dss((row - 1) * columns + column).Attributes(8, &H1155).Value)
            
            'Mono image
            Set imageatt = ds2.Attributes(&H2020, &H110)
            
            'If no mono, check for a colour image
            If Not imageatt.Exists Then Set imageatt = ds2.Attributes(&H2020, &H111)
            
            If imageatt.Exists Then
                Set images = New DicomImages
                images.Add imageatt.Value.item(1)
                Set image = images(1)
                Set pic = image.PictureWithLUT(lut)
                hpos = left + (column - 1) * (width + margin)
                vpos = top + (row - 1) * (height + margin)
                
                'check whether width or height is limiting factor
                zoom = width / pic.width
                If zoom < height / pic.height Then
                    ' width limited
                    vpos = vpos + (height - pic.height * zoom) / 2
                Else
                    ' height limited
                    zoom = height / pic.height
                    hpos = hpos + (width - pic.width * zoom) / 2
                End If

                Printer.PaintPicture pic, hpos, vpos, pic.width * zoom, pic.height * zoom
                
                'Also Save image to disk
                image.instanceUID = g.NewUID
                image.SOPClass = doSOP_SecondaryCapture
                image.WriteFile Path & "\" & image.instanceUID, True, doTS_ExplicitVRLittleEndian
            End If
        Next
    Next
    Printer.EndDoc
End Sub

Sub DecodeFormat(ByVal format As String, x As Integer, y As Integer)
    Dim p As Integer, p1 As Integer
    p = InStr(format, "\")
    p1 = InStr(p + 1, format, ",")
    x = Val(Mid(format, p + 1, p1 - p - 1))
    y = Val(Mid(format, p1 + 1))
End Sub

Sub Remove(classUID As String, instanceUID As String)
    Dim children As DicomDataSets, child As DicomDataSet
    Dim thisDataSet As DicomDataSet
    
    ' Object may already have been removed by delete so trap and ignore errors
    On Error GoTo er1
    Set thisDataSet = Datasets(instanceUID)
    
    Set children = thisDataSet.Tag
    For Each child In children
        Remove child.SOPClass, child.instanceUID
        'Remove child.instanceUID
    Next
    
    Datasets.Remove instanceUID
    
cont:
    Exit Sub
    
er1:
    Resume cont
End Sub

Private Sub server_AssociationRequest(ByVal Connection As DicomObjects8.DicomConnection, isOK As Boolean)
    Set Connection.Tag = New DicomDataSets
    Log "Association Request from " & Connection.CallingAET & " at IP: " & Connection.RemoteIP
End Sub

Private Sub server_NormalisedReceived(ByVal Connection As DicomObjects8.DicomConnection)
    Dim command As DicomDataSet, ds As DicomDataSet, a As DicomAttribute
    Dim operation As Integer, rclass As String, ruid As String, aclass As String, auid As String
    Dim dss As DicomDataSets, ds1 As DicomDataSet, ds2 As DicomDataSet, i As Integer
    Dim sessionUID As String
    
    Set command = Connection.command
    
    operation = command.Attributes(0, &H100)
    rclass = command.Attributes(0, 3) & ""
    ruid = command.Attributes(0, &H1001) & ""
    aclass = command.Attributes(0, 2) & ""
    auid = command.Attributes(0, &H1000) & ""

    Select Case operation
    Case &H110  ' N-GET
        Log "N-GET Request from " & Connection.CallingAET & " at IP: " & Connection.RemoteIP
        Set ds = Dataset(rclass, ruid)
        Connection.SendData ds, 0
        Connection.SendStatus 0
    Case &H140  ' N-CREATE
        Log "N-CREATE Request from " & Connection.CallingAET & " at IP: " & Connection.RemoteIP
        Set ds = NewDataSet 'Datasets.AddNew
        ' set defaults
        For Each a In Connection.Request.Attributes
            ds.Attributes.Add a.Group, a.Element, a.Value
        Next
        ds.Attributes.Add 8, &H16, aclass
        If auid = "" Then auid = g.NewUID
        ds.Attributes.Add 8, &H18, auid
        
        ' specific to film box
        If aclass = doSOP_BasicFilmBox Then
             ' check number of image boxes, then make then
            Dim columns As Integer, rows As Integer
            DecodeFormat ds.Attributes(&H2010, &H10), columns, rows
            Set dss = ds.Tag 'New DicomDataSets

            Dim ImageBoxType As String
            Dim MetaSOPClass As String

            ' Connection.PresentationContextID requires at least DicomObjects8.ocx version 4.3.212
            MetaSOPClass = Connection.Contexts(Connection.PresentationContextID).AbstractSyntax

            If MetaSOPClass = doMeta_BasicGrayscalePrint Then
                ImageBoxType = doSOP_BasicGrayscaleImageBox
            Else
                ImageBoxType = doSOP_BasicColorImageBox ' doMeta_BasicColorPrint
            End If

            For i = 1 To rows * columns
                Set ds1 = NewDataSet 'dss.AddNew
                ds1.instanceUID = g.NewUID ' for indexing
                ds1.Attributes.Add 8, &H1155, ds1.instanceUID
                ds1.Attributes.Add 8, &H1150, ImageBoxType
                dss.Add ds1
            Next
            ds.Attributes.Add &H2010, &H510, dss
            
            ' also link to session
            Dim sessionseq As DicomDataSets
            Set sessionseq = ds.Attributes(&H2010, &H500).Value
            sessionUID = sessionseq(1).Attributes(8, &H1155)
            
            Datasets(sessionUID).Tag.Add ds
        
        End If
        
        'specific to seesion - link to the connection
        If aclass = doSOP_BasicFilmSession Then
            Connection.Tag.Add ds
        End If
       
        Connection.SendData ds, 0
        
    Case &H130 ' action
        Log "N-ACTION Request from " & Connection.CallingAET & " at IP: " & Connection.RemoteIP
        Connection.SendStatus DoPrint(ruid)
        
    Case &H150 'delete
        Log "N-DELETE Request from " & Connection.CallingAET & " at IP: " & Connection.RemoteIP
        Remove rclass, ruid
        Connection.SendStatus 0
        
    Case &H120 ' N-SET
        Log "N-SET Request from " & Connection.CallingAET & " at IP: " & Connection.RemoteIP
        Set ds = Dataset(rclass, ruid)
        For Each a In Connection.Request.Attributes
            ds.Attributes.Add a.Group, a.Element, a.Value
        Next
        Connection.SendStatus 0
    End Select
End Sub

Private Sub server_AssociationClosed(ByVal Connection As DicomObjects8.DicomConnection)
    Dim session As DicomDataSet
    For Each session In Connection.Tag
        Remove session.SOPClass, session.instanceUID
    Next
End Sub
