// QRDialog.cpp : implementation file
//

#include "stdafx.h"
#include "MSVC Viewer.h"
#include "QRDialog.h"
#include "inputdialog.h"
#include "DicomKeywords.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CQRDialog dialog


CQRDialog::CQRDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CQRDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CQRDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CQRDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CQRDialog)
	DDX_Control(pDX, IDC_TREE, m_tree);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CQRDialog, CDialog)
	//{{AFX_MSG_MAP(CQRDialog)
	ON_NOTIFY(TVN_ITEMEXPANDED, IDC_TREE, OnItemexpandedTree)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CQRDialog message handlers

bool CQRDialog::InitialLoad()
{
    IDicomDataSetPtr r;
    IDicomDataSetsPtr res;

   // Each node has an IDData item pointed to by it "data" property - item 0 is the level (1=PATIENT...4=Image)
    // and the other items are the unique keys for that "level" and those above

	m_tree.DeleteAllItems();
 	CQROptions * pOptions=&(((CMSVCViewerApp*)AfxGetApp())->options);

	try
	{
		q.CreateInstance("DicomObjects8.DicomQuery");
		q->Node = _bstr_t(pOptions->m_RemoteIP);
		q->Port = pOptions->m_RemotePort;
		q->CallingAE = _bstr_t(pOptions->m_LocalAET);
		q->CalledAE = _bstr_t(pOptions->m_RemoteAET);
		if(pOptions->m_StudyRoot)
		{
			q->Level = "STUDY";
		    q->Root = "STUDY";
		}
		else
		{
			q->Level = "PATIENT";
			q->Root = "PATIENT";
		}
		CInputDialog d;
		// This could and should be extened to include Patient ID
		d.m_question="Enter Patient Name.  (Leave as blank or * if unknown)";
		if(d.DoModal()!=IDOK)
			return false;

		q->Name = (const char *)d.m_answer;
    
		res = q->DoQuery();
	}
	catch(_com_error e)
	{
		AfxMessageBox("Attempt to query remote machine returned error\r\n\r\n'" + e.Description() + "'\r\n\r\nPlease check the options and try again",MB_OK);
		return false;
	}
    
    HTREEITEM nd;
    for(long i=1;i<=res->Count;i++)
	{
        r=res->Item[_variant_t(i)];
		IDData * IDs=NewIDItem(NULL);
		IDs->PatientID = r->PatientID;
		if(pOptions->m_StudyRoot)
		{
            nd = m_tree.InsertItem(r->Name + " / " + Description(r));
			IDs->level = 2;
            IDs->StudyUID = r->StudyUID;
            m_tree.InsertItem("Please wait, while the series list is retrieved",nd);
		}
		else
		{
            nd = m_tree.InsertItem(r->Name);
            IDs->level = 1;
			m_tree.InsertItem("Please wait, while the study list is retrieved",nd);
		}
        m_tree.SetItemData(nd,(DWORD)IDs);
        m_tree.Expand(nd,TVE_COLLAPSE);
	}
	return true;
}

void CQRDialog::OnItemexpandedTree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	IDicomDataSetsPtr res;
	IDicomDataSetPtr r;
	long i;
	CString s;
	HTREEITEM nd1,oldChild;

	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	HTREEITEM nd=pNMTreeView->itemOld.hItem;

	IDData * IDs=(IDData*)m_tree.GetItemData(nd);
	*pResult = 0;

	if(IDs->level<0)  // already expanded
		return;
	IDData * newIDs=NewIDItem(IDs);;

	newIDs->level=IDs->level+1;
	IDs->level=(-IDs->level); // mark as expanded
    
    switch(abs(IDs->level))
	{

	case 1: //"PATIENT"
        q->Level = "STUDY";
        q->PatientID = IDs->PatientID;
        q->StudyUID = "";
        q->SeriesUID = "";
        q->InstanceUID = "";
        res = q->DoQuery();

		oldChild=m_tree.GetChildItem(nd);
		m_tree.DeleteItem(oldChild);
        
        for(i=1;i<=res->Count;i++)
		{
            r=res->Item[i];
			s = Description(r);
            nd1 = m_tree.InsertItem(s,nd);
            newIDs->StudyUID = r->StudyUID;
            m_tree.SetItemData(nd1,(DWORD)newIDs);
			m_tree.InsertItem("Please wait, while the series list is retrieved",nd1);
			m_tree.Expand(nd1,TVE_COLLAPSE);
        }
        break;

    case 2: //"STUDY"
        q->Level = "SERIES";
        q->PatientID = IDs->PatientID;
        q->StudyUID = IDs->StudyUID;
        q->SeriesUID = "";
        q->InstanceUID = "";
        res = q->DoQuery();
        
		oldChild=m_tree.GetChildItem(nd);
		m_tree.DeleteItem(oldChild);
        
        for(i=1;i<=res->Count;i++)
		{
            r=res->Item[i];
            s = (const char *)r->SeriesDescription;
            if(s == "")
				s = "**SERIES**";
            nd1 = m_tree.InsertItem(s,nd);
            newIDs->SeriesUID = r->SeriesUID;
            m_tree.SetItemData(nd1,(DWORD)newIDs);
			m_tree.InsertItem("Please wait, while the image list is retrieved",nd1);
			m_tree.Expand(nd1,TVE_COLLAPSE);
        }
        break;
        

    case 3: //"SERIES"
        q->Level = "IMAGE";
        q->PatientID = IDs->PatientID;
        q->StudyUID = IDs->StudyUID;
        q->SeriesUID = IDs->SeriesUID;
        q->InstanceUID = "";
        res = q->DoQuery();
        
		oldChild=m_tree.GetChildItem(nd);
		m_tree.DeleteItem(oldChild);
        
        for(i=1;i<=res->Count;i++)
		{
            r=res->Item[i];
            s = (const char *)r->InstanceUID;
            nd1 = m_tree.InsertItem(s,nd);
            newIDs->InstanceUID = r->InstanceUID;
            m_tree.SetItemData(nd1,(DWORD)newIDs);
        }
        
	}
}

CString CQRDialog::Description(IDicomDataSetPtr study)
{
    CString s((const char *)study->StudyDescription);
	IDicomAttributePtr dt;
    if(s == "") 
		s = "STUDY";
    dt = study->Attributes->Item[Keyword_StudyDate];
    if(dt->Exists && dt->Value.vt!=VT_NULL)
	{
		s = s + " on " + (const char*)_bstr_t(dt->Value );
	}
    return s;

}

CQRDialog::~CQRDialog()
{
	for(int i=0;i<m_data.GetSize();i++)
	{
		delete m_data[i];
	}
}

IDData * CQRDialog::NewIDItem(IDData * original)
{
	IDData * item=new IDData;
	if(original!=NULL)
		*item=*original;
	m_data.Add(item);
	return item;
}

void CQRDialog::OnOK() 
{
    HTREEITEM nd=m_tree.GetSelectedItem();
	IDData * IDs=(IDData*)m_tree.GetItemData(nd);
	IDicomImagesPtr res;
 	CQROptions * pOptions=&(((CMSVCViewerApp*)AfxGetApp())->options);
    
    switch(abs(IDs->level))
	{
	case 1:// '"PATIENT"
        q->PatientID = IDs->PatientID;
        q->StudyUID = "";
        q->SeriesUID = "";
        q->InstanceUID = "";
        q->Level = "PATIENT";
		break;
        
    case 2:// '"STUDY"
        q->PatientID = IDs->PatientID;
        q->StudyUID = IDs->StudyUID;
        q->SeriesUID = "";
        q->InstanceUID = "";
        q->Level = "STUDY";
		break;

    case 3: //'"SERIES"
        q->PatientID = IDs->PatientID;
        q->StudyUID = IDs->StudyUID;
        q->SeriesUID = IDs->SeriesUID;
        q->InstanceUID = "";
        q->Level = "SERIES";
		break;
                
	case 4: //'"IMAGE"
        q->PatientID = IDs->PatientID;
        q->StudyUID = IDs->StudyUID;
        q->SeriesUID = IDs->SeriesUID;
        q->InstanceUID = IDs->InstanceUID;
        q->Level = "IMAGE";
		break;
	}
    
    int mode=pOptions->m_RetrievalType; //0=C-GET, 1=Sync C-MOVE, 2=Async C-MOVE
    switch(mode)
	{
	case 0:
		try
		{
			res = q->GetImages();
		}
		catch(_com_error & e)
		{
			if(e.WCode()==1409)
			{
				AfxMessageBox("The SCP did not accept this request, which probably means that it does not accept C-GET requests (many systems no longer accept C-GET).  You should try again using one of the C-MOVE options, but note that this will only work if the SCP has been set up specificially to associate your AE Title, IP address and port number");
				return;
			}
		}

		break;

	case 1:
		q->Destination = _bstr_t(pOptions->m_LocalAET);
		q->ReceivePort=pOptions->m_LocalPort;

		{
			IDicomServerPtr server=(((CMSVCViewerApp*)AfxGetApp())->Server);
			server->Unlisten(pOptions->m_LocalPort);
			res = q->GetUsingMove();
			server->Listen(pOptions->m_LocalPort);
		}
		break;

	case 2:
		q->Destination = _bstr_t(pOptions->m_LocalAET);
		q->MoveImages();
		break;
	}

	if(mode !=2)
	{
		for(long i = 1;i<=res->Count;i++)
		{
			CMSVCViewerDoc * doc=((CMSVCViewerApp*)AfxGetApp())->AddNewImage(res->Item[i]);
			doc->UpdateAllViews(NULL);
		}
	}
	CDialog::OnOK();
}
