#if !defined(AFX_DICOMVIEWERSINK_H__856F0803_B6C5_11D2_A474_0040C711066C__INCLUDED_)
#define AFX_DICOMVIEWERSINK_H__856F0803_B6C5_11D2_A474_0040C711066C__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// DicomViewerSink.h : header file
//



/////////////////////////////////////////////////////////////////////////////
// CDicomViewerSink command target
extern const IID IID_IDicomViewerSink;
class CMSVCViewerView;

class CDicomViewerSink : public CCmdTarget
{
	DECLARE_DYNCREATE(CDicomViewerSink)

	CDicomViewerSink();           // protected constructor used by dynamic creation
	void OnInfoMessage(short InfoType, BSTR Text);
	void OnDataChanged();
	void OnDisplayChanged();
	void OnImageReceived(DicomImage* ReceivedImage, long Association, boolean* isAdded, long* Status);
	void OnClick();
	void OnDblClick();
	void OnMouseDown(short Button, short Shift, long x, long y);
	void OnMouseMove(short Button, short Shift, long x, long y);
	void OnMouseUp(short Button, short Shift, long x, long y);
	void OnError(short Number, BSTR* Description, SCODE Scode, BSTR Source, BSTR HelpFile, long HelpContext, boolean* CancelDisplay);
	void OnQueryRequest(DicomConnection* Connection);
	void OnEventReport(DicomConnection* Connection, short EventID, DicomDataSet* DataSet, long* Status);
	void OnAssociationRequest(BSTR CallingAE, BSTR CalledAE, BSTR CallingIPAddress, long Association, boolean* isOK, DicomContexts* Contexts);
	void OnActionComplete(DicomConnection* Connection, BSTR Action, VARIANT Tag, boolean Success, BSTR ErrorMessage);
	void OnImageReceivedAsync(DicomConnection* Connection, DicomImage* Image, boolean* isAdded);
	void OnNormalisedReceived(DicomConnection* Connection);

// Attributes
public:

// Operations
public:
	void OnKeyPress(short * KeyAscii);
	void OnKeyDown(short * KeyCode, short Shift);
	void OnKeyUp(short * KeyCode, short Shift);
	void OnDrawStart();
	void OnDrawEnd();
	void OnFrameChanging(int Index, int Frame);
	void OnVerifyReceived(int * Status);

	CDicomViewerSink(CDicomViewer * Control,CMSVCViewerView * Window);           // protected constructor used by dynamic creation

	virtual ~CDicomViewerSink();
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDicomViewerSink)
	public:
	virtual void OnFinalRelease();
	//}}AFX_VIRTUAL

// Implementation
protected:
	CMSVCViewerView *	m_ViewerWindow;
	CDicomViewer *		m_ViewerControl;

	// These are used for drawing

	IDicomLabelPtr CurrentLabel;
	bool LabelDrawing;



	// Generated message map functions
	//{{AFX_MSG(CDicomViewerSink)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
	// Generated OLE dispatch map functions
	//{{AFX_DISPATCH(CDicomViewerSink)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()
	DECLARE_INTERFACE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_DICOMVIEWERSINK_H__856F0803_B6C5_11D2_A474_0040C711066C__INCLUDED_)
