// DicomViewerSink.cpp : implementation file
//

#include "stdafx.h"
#include "dicomviewer.h"
#include "MSVC ViewerDoc.h"
#include "MSVC ViewerView.h"
#include "MSVC Viewer.h"
#include "DicomViewerSink.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDicomViewerSink

IMPLEMENT_DYNCREATE(CDicomViewerSink, CCmdTarget)

CDicomViewerSink::CDicomViewerSink(CDicomViewer * Control,CMSVCViewerView * Window)
{
	EnableAutomation();
	m_ViewerControl=Control;
	m_ViewerWindow=Window;
	LabelDrawing=false;
}
CDicomViewerSink::CDicomViewerSink()
{
	EnableAutomation();
	LabelDrawing=false;
}

CDicomViewerSink::~CDicomViewerSink()
{
}


void CDicomViewerSink::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CCmdTarget::OnFinalRelease();
}


BEGIN_MESSAGE_MAP(CDicomViewerSink, CCmdTarget)
	//{{AFX_MSG_MAP(CDicomViewerSink)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CDicomViewerSink, CCmdTarget)
	DISP_FUNCTION_ID(CDicomViewerSink,"InfoMessage", 1, OnInfoMessage, VT_EMPTY, VTS_I2  VTS_BSTR)
	DISP_FUNCTION_ID(CDicomViewerSink,"OnDataChanged", 3, OnDataChanged, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION_ID(CDicomViewerSink,"OnDisplayChanged", 4, OnDisplayChanged, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION_ID(CDicomViewerSink,"ImageReceived", 5, OnImageReceived, VT_EMPTY, VTS_DISPATCH  VTS_I2  VTS_PBOOL  VTS_PI2)
	DISP_FUNCTION_ID(CDicomViewerSink,"QueryRequest", 6, OnQueryRequest, VT_EMPTY, VTS_DISPATCH)
	DISP_FUNCTION_ID(CDicomViewerSink,"EventReport", 101, OnEventReport, VT_EMPTY, VTS_DISPATCH  VTS_I2  VTS_DISPATCH  VTS_PI4)
	DISP_FUNCTION_ID(CDicomViewerSink,"AssociationRequest", 102, OnAssociationRequest, VT_EMPTY, VTS_BSTR  VTS_BSTR  VTS_BSTR  VTS_I4  VTS_PBOOL VTS_DISPATCH)
	DISP_FUNCTION_ID(CDicomViewerSink,"ActionComplete", 103, OnActionComplete, VT_EMPTY, VTS_DISPATCH  VTS_BSTR  VTS_VARIANT VTS_BOOL VTS_BSTR)
	DISP_FUNCTION_ID(CDicomViewerSink,"ImageReceivedAsync", 104, OnImageReceivedAsync, VT_EMPTY, VTS_DISPATCH  VTS_DISPATCH  VTS_PBOOL)
	DISP_FUNCTION_ID(CDicomViewerSink,"NormalisedReceived", 105, OnNormalisedReceived, VT_EMPTY, VTS_DISPATCH)
	DISP_FUNCTION_ID(CDicomViewerSink,"DrawStart", 201, OnDrawStart, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION_ID(CDicomViewerSink,"DrawEnd", 202, OnDrawEnd, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION_ID(CDicomViewerSink,"VerifyReceived", 203, OnVerifyReceived, VT_EMPTY, VTS_PI4)
	DISP_FUNCTION_ID(CDicomViewerSink,"OnFrameChanging", 204, OnFrameChanging, VT_EMPTY, VTS_I4  VTS_I4)

	DISP_FUNCTION_ID(CDicomViewerSink,"Click" , DISPID_CLICK, OnClick, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION_ID(CDicomViewerSink,"DblClick" , DISPID_DBLCLICK, OnDblClick, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION_ID(CDicomViewerSink,"MouseDown" , DISPID_MOUSEDOWN, OnMouseDown, VT_EMPTY, VTS_I2 VTS_I2 VTS_XPOS_PIXELS VTS_YPOS_PIXELS)
	DISP_FUNCTION_ID(CDicomViewerSink,"MouseMove" , DISPID_MOUSEMOVE, OnMouseMove, VT_EMPTY, VTS_I2 VTS_I2 VTS_XPOS_PIXELS VTS_YPOS_PIXELS)
	DISP_FUNCTION_ID(CDicomViewerSink,"MouseUp" , DISPID_MOUSEUP, OnMouseUp, VT_EMPTY, VTS_I2 VTS_I2 VTS_XPOS_PIXELS VTS_YPOS_PIXELS)
	DISP_FUNCTION_ID(CDicomViewerSink,"Error" , DISPID_ERROREVENT, OnError, VT_EMPTY, VTS_I2 VTS_PBSTR VTS_SCODE VTS_BSTR VTS_BSTR VTS_I4 VTS_PBOOL)

	DISP_FUNCTION_ID(CDicomViewerSink,"KeyDown" , DISPID_KEYDOWN, OnKeyDown, VT_EMPTY, VTS_PI2 VTS_I2)
	DISP_FUNCTION_ID(CDicomViewerSink,"KeyPress" , DISPID_KEYPRESS, OnKeyPress, VT_EMPTY, VTS_PI2)
	DISP_FUNCTION_ID(CDicomViewerSink,"KeyUp" , DISPID_KEYUP, OnKeyUp, VT_EMPTY, VTS_PI2 VTS_I2)
/*
	EVENT_STOCK_KEYDOWN()
	EVENT_STOCK_KEYPRESS()
	EVENT_STOCK_KEYUP()


	EVENT_CUSTOM_ID("DrawStart", 201, FireDrawStart, VTS_NONE)
	EVENT_CUSTOM_ID("DrawEnd", 202, FireDrawEnd, VTS_NONE)
	EVENT_CUSTOM_ID("VerifyReceived", 203, FireVerifyReceived, VTS_PI4)
	EVENT_CUSTOM_ID("OnFrameChanging", 204, FireOnFrameChanging, VTS_I4  VTS_I4)
	EVENT_CUSTOM_ID("InfoMessage", 1, FireInfoMessage,  VTS_I2  VTS_BSTR)
	EVENT_CUSTOM_ID("OnDataChanged", 3, FireOnDataChanged, VTS_NONE)
	EVENT_CUSTOM_ID("OnDisplayChanged", 4, FireOnDisplayChanged, VTS_NONE)
	EVENT_CUSTOM_ID("ImageReceived", 5, FireImageReceived, VTS_DISPATCH  VTS_I4  VTS_PBOOL  VTS_PI4)
	EVENT_CUSTOM_ID("QueryDicomConnection", 6, FireQueryDicomConnection, VTS_DISPATCH)
	EVENT_CUSTOM_ID("EventReport", 101, FireEventReport, VTS_DISPATCH  VTS_I2  VTS_DISPATCH  VTS_PI4)
	EVENT_CUSTOM_ID("AssociationDicomConnection", 102, FireAssociationDicomConnection, VTS_BSTR  VTS_BSTR  VTS_BSTR  VTS_I4  VTS_PBOOL VTS_DISPATCH)
	EVENT_CUSTOM_ID("ActionComplete", 103, FireActionComplete2, VTS_DISPATCH  VTS_BSTR  VTS_VARIANT VTS_BOOL VTS_BSTR)
	EVENT_CUSTOM_ID("ImageReceivedAsync", 104, FireImageReceived2, VTS_DISPATCH  VTS_DISPATCH  VTS_PBOOL)
	EVENT_CUSTOM_ID("NormalisedReceived", 105, FireNormalisedReceived, VTS_DISPATCH)
	EVENT_STOCK_CLICK()
	EVENT_STOCK_DBLCLICK()
	EVENT_STOCK_MOUSEDOWN()
	EVENT_STOCK_MOUSEMOVE()
	EVENT_STOCK_MOUSEUP()

*/	//{{AFX_DISPATCH_MAP(CDicomViewerSink)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_IDicomViewerSink to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {856F0802-B6C5-11D2-A474-0040C711066C}
static const IID IID_IDicomViewerSink =
{   0xD1C00008, 0xB590, 0x44B1, { 0xBB, 0x3F, 0x95, 0x55, 0x52, 0x39, 0x0B, 0x8B } };


BEGIN_INTERFACE_MAP(CDicomViewerSink, CCmdTarget)
	INTERFACE_PART(CDicomViewerSink, IID_IDicomViewerSink, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDicomViewerSink message handlers
void CDicomViewerSink::OnInfoMessage(short InfoType, BSTR Text){}
void CDicomViewerSink::OnDataChanged(){}
void CDicomViewerSink::OnDisplayChanged(){}
void CDicomViewerSink::OnImageReceived(DicomImage* ReceivedImage, long Association, boolean* isAdded, long* Status){}
void CDicomViewerSink::OnClick()
{
}
void CDicomViewerSink::OnDblClick(){}
void CDicomViewerSink::OnMouseDown(short Button, short Shift, long x, long y)
{
	CurrentLabel.CreateInstance("DicomObjects8.DicomLabel");
	LabelDrawing = true;

	CurrentLabel->LabelType = doLabelPolyLine;
	CurrentLabel->Transparent = true;
	CurrentLabel->ForeColour = RGB(255,128,0);
	CurrentLabel->LineWidth = 3;

	CurrentLabel->AddPoint(x, y);
    m_ViewerControl->DrawLabel(CurrentLabel);
}
void CDicomViewerSink::OnMouseMove(short Button, short Shift, long x, long y)
{
	if(LabelDrawing)
	{
		m_ViewerControl->DrawLabel(CurrentLabel);
		CurrentLabel->AddPoint(x, y);
		m_ViewerControl->DrawLabel(CurrentLabel);
	}
}
void CDicomViewerSink::OnMouseUp(short Button, short Shift, long x, long y)
{
    if(LabelDrawing)
	{
        LabelDrawing = false;
		m_ViewerControl->DrawLabel(CurrentLabel);
        
        IDicomImagePtr image = m_ViewerControl->GetCurrentImage();
		image->Release();
        CurrentLabel->Rescale(image, doLabelScaleOutput);
        image->Labels->Add(CurrentLabel);
        
        CurrentLabel.Release();
        m_ViewerControl->Refresh();
    }
}
void CDicomViewerSink::OnError(short Number, BSTR* Description, SCODE Scode, BSTR Source, BSTR HelpFile, long HelpContext, boolean* CancelDisplay){}
void CDicomViewerSink::OnQueryRequest(DicomConnection* Connection){}
void CDicomViewerSink::OnEventReport(DicomConnection* Connection, short EventID, DicomDataSet* DataSet, long* Status){}
void CDicomViewerSink::OnAssociationRequest(BSTR CallingAE, BSTR CalledAE, BSTR CallingIPAddress, long Association, boolean* isOK, DicomContexts* Contexts){}
void CDicomViewerSink::OnActionComplete(DicomConnection* Connection, BSTR Action, VARIANT Tag, boolean Success, BSTR ErrorMessage){}
void CDicomViewerSink::OnImageReceivedAsync(DicomConnection* Connection, DicomImage* Image, boolean* isAdded){}
void CDicomViewerSink::OnNormalisedReceived(DicomConnection* Connection){}
void CDicomViewerSink::OnDrawStart(){}
void CDicomViewerSink::OnDrawEnd(){}
void CDicomViewerSink::OnFrameChanging(int Index, int Frame){}
void CDicomViewerSink::OnVerifyReceived(int * Status){}
void CDicomViewerSink::OnKeyDown(short *KeyCode, short Shift){}
void CDicomViewerSink::OnKeyUp(short *KeyCode, short Shift){}
void CDicomViewerSink::OnKeyPress(short *KeyAscii){}
