// CustomDicomServer.cpp : implementation file
//

#include "stdafx.h"
#include "MSVC Viewer.h"
#include "DicomServerSink.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDicomServerSink

IMPLEMENT_DYNCREATE(CDicomServerSink, CCmdTarget)

CDicomServerSink::CDicomServerSink()
{
	EnableAutomation();
}

CDicomServerSink::~CDicomServerSink()
{
}


void CDicomServerSink::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CCmdTarget::OnFinalRelease();
}


BEGIN_MESSAGE_MAP(CDicomServerSink, CCmdTarget)
	//{{AFX_MSG_MAP(CDicomServerSink)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CDicomServerSink, CCmdTarget)
	DISP_FUNCTION_ID(CDicomServerSink,"AssociationRequest",102,OnAssociationRequest,VT_EMPTY,VTS_BSTR  VTS_BSTR  VTS_BSTR  VTS_I4  VTS_PBOOL VTS_DISPATCH)
	DISP_FUNCTION_ID(CDicomServerSink,"QueryRequest",2,OnQueryRequest,VT_EMPTY,VTS_DISPATCH)
	DISP_FUNCTION_ID(CDicomServerSink,"ImageReceived",3,OnImageReceived,VT_EMPTY,VTS_DISPATCH  VTS_I4  VTS_PI4)
	DISP_FUNCTION_ID(CDicomServerSink,"InfoMessage",4,OnInfoMessage,VT_EMPTY,VTS_I2  VTS_BSTR)
	DISP_FUNCTION_ID(CDicomServerSink,"EventReport",101,OnEventReport,VT_EMPTY,VTS_DISPATCH  VTS_I2  VTS_DISPATCH  VTS_PI4)
	DISP_FUNCTION_ID(CDicomServerSink,"ActionComplete",103,OnActionComplete,VT_EMPTY,VTS_DISPATCH  VTS_BSTR  VTS_VARIANT VTS_BOOL VTS_BSTR)
	DISP_FUNCTION_ID(CDicomServerSink,"ImageReceivedAsync",104,OnImageReceivedAsync,VT_EMPTY,VTS_DISPATCH  VTS_DISPATCH)
	DISP_FUNCTION_ID(CDicomServerSink,"NormalisedReceived",105,OnNormalisedReceived,VT_EMPTY,VTS_DISPATCH)
	//{{AFX_DISPATCH_MAP(CDicomServerSink)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_ICustomDicomServer to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {856F07FF-B6C5-11D2-A474-0040C711066C}
static const IID IID_IDicomServerSink =
{ 0x60716840, 0x3abf, 0x11d1, { 0xa3, 0x95, 0x0, 0x40, 0xc7, 0x11, 0x6, 0x6c } };
BEGIN_INTERFACE_MAP(CDicomServerSink, CCmdTarget)
	INTERFACE_PART(CDicomServerSink, IID_IDicomServerSink, Dispatch)
END_INTERFACE_MAP()




/////////////////////////////////////////////////////////////////////////////
// CDicomServerSink message handlers

void CDicomServerSink::OnQueryRequest(IDicomConnection * Connection){}
void CDicomServerSink::OnImageReceived(IDicomImage* ReceivedImage, long Association, long* Status)
{
	IDicomImagePtr image=ReceivedImage;
	CMSVCViewerDoc * doc=((CMSVCViewerApp*)AfxGetApp())->AddNewImage(image);
	doc->UpdateAllViews(NULL);
}
void CDicomServerSink::OnAssociationRequest(BSTR CallingAE, BSTR CalledAE, BSTR CallingIPAddress, long Association, boolean* isOK, IDicomContexts* Contexts)
{
    //Reject any non-DICOM SOP classes
    for(int i=1;i<=255;i+=2)
	{
		if(Contexts->Exists[i])
		{
			IDicomContextPtr context=Contexts->Item[i];
			CString abst=(const char *)context->AbstractSyntax;
			if(abst.Left(14)!= "1.2.840.10008.")
				context->Reject(3);
		}
	}
}
void CDicomServerSink::OnInfoMessage(short InfoType, BSTR Text){}
void CDicomServerSink::OnEventReport(IDicomConnection* Connection, short EventID, IDicomDataSet* DataSet, long* Status){}
void CDicomServerSink::OnActionComplete(IDicomConnection* Connection, BSTR Action, VARIANT Tag, boolean Success, BSTR ErrorMessage){}
void CDicomServerSink::OnImageReceivedAsync(IDicomConnection* Connection, IDicomImage* Image){}
void CDicomServerSink::OnNormalisedReceived(IDicomConnection* Connection){}
