unit MWL;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OleCtrls, StdCtrls, DB, ADODB, Grids, DBGrids,
  DicomObjects8_TLB, Vcl.OleServer;

type
  TForm1 = class(TForm)
    DicomViewer1: TDicomViewer;
    DBConnection: TADOConnection;
    DisableDate: TCheckBox;
    ADOQuery1: TADOQuery;
    Label1: TLabel;
    Logger: TMemo;
    DicomServer1: TDicomServer;
    procedure Form_load(Sender: TObject);
    procedure QueryRequest(ASender: TObject;
      const Connection: IDicomConnection);
    procedure DicomServer1AssociationRequest(ASender: TObject;
      const Connection: IDicomConnection; var isOK: WordBool);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Form_load(Sender: TObject);
begin

  DicomServer1.Listen(104);
  DBConnection.Open;

end;

function RightStr(Const Str: String; Size: Word): String;
begin

  if Size > Length(Str) then
    Size := Length(Str);
  RightStr := Copy(Str, Length(Str) - Size + 1, Size);

end;

function MidStr(Const Str: String; From, Size: Word): String;
begin

  MidStr := Copy(Str, From, Size);

end;

function LeftStr(Const Str: String; Size: Word): String;
begin

  LeftStr := Copy(Str, 1, Size);

end;

function instr(start: integer; original, search: String): integer;
var
  ms: string;
begin

  ms := Copy(original, start, Length(original));
  if (start > Length(original)) or (start = 0) or (Pos(search, ms) = 0) then
    Result := 0
  else
    Result := Pos(search, ms) + start - 1;

end;

procedure Log(X: String);
begin

  Form1.Logger.Lines.Add(DateTimeToStr(Now()) + ' ' + X + ' ');

End;

procedure TForm1.DicomServer1AssociationRequest(ASender: TObject;
  const Connection: IDicomConnection; var isOK: WordBool);
var
  ac: DicomContext;
  X: integer;
begin

  Log('Request from ' + Connection.CallingAET + ' at ' + Connection.RemoteIP);

  X := 1;
  while Connection.Contexts.Exists[X] do
  begin
    ac := Connection.Contexts.item[X];
    X := X + 1;
    If (ac.AbstractSyntax <> '1.2.840.10008.5.1.4.31') And
      (ac.AbstractSyntax <> '1.2.840.10008.1.1') Then
    begin
      ac.Reject(3);
    end;
  end;

end;

function StarToPercent(a: String): String;
Var
  z: integer;
Begin

  While instr(1, a, '*') > 0 do
  begin
    z := instr(1, a, '*'); // gives the pos of * in the string
    Delete(a, z, 1);
    Insert('%', a, z);
  end;
  StarToPercent := a;

End;

procedure AddStringCondition(var query: String; condition: String;
  dbname: String);
begin

  If (condition <> '') And (condition <> '*') Then
  begin
    If instr(1, condition, '*') > 0 Then
    Begin
      query := query + ' AND ' + dbname + ' like ''' +
        StarToPercent(condition) + '''';
    End
    Else
    Begin
      query := query + ' AND ' + dbname + ' = ''' + condition + '''';
    End;
  End;

End;

procedure AddCondition(var query: String; condition: DicomAttribute;
  dbname: String);
Var
  values: Variant;
  c: integer;

Begin

  If (condition.Exists) And Not VarIsNull(condition.value) Then
  Begin
    if condition.Multiple then
    begin

      query := query + ' AND ( FALSE';
      values := condition.value;

      for c := 1 to VarArrayHighBound(values, 1) do
      begin
        query := query + ' OR ' + dbname + ' = ''' + values[c] + '''';
        // c := c+1;
      end;

      query := query + ' )';

    end
    else
    begin
      AddStringCondition(query, condition.value, dbname);
    end;
  End;

End;

procedure AddNameCondition(var query: String; condition: DicomAttribute;
  dbsurname: String; dbforename: String);
Var
  ptname: String;
  surname: String;
  forename: String;
Begin

  // Name needs to be split
  if not VarIsNull(condition.value) and (condition.Exists) then
  begin
    ptname := condition.value + '^^^^';

    If (ptname <> '') And (ptname <> '*') Then
    begin
      surname := LeftStr(ptname, instr(1, ptname, '^') - 1);
      // every thing before ^ in ptname into surname
      ptname := MidStr(ptname, Length(surname) + 2, Length(ptname));
      // del surname +^ from ptname
      forename := LeftStr(ptname, instr(1, ptname, '^') - 1);
      // every thing before ^ in ptname into first name
      AddStringCondition(query, surname, dbsurname);
      AddStringCondition(query, forename, dbforename);
    end;

  end;

End;

procedure AddSingleDateCondition(var query: String; condition: TDateTime;
  operator: String; dbname: String);
begin

  {
    all date formating goes through here to make it easy to change for
    different databases or locales condition.
  }

  query := query + ' AND ' + dbname + operator + 'cdate(''' +
    FormatDateTime('yyyy-mm-dd hh:nn', condition) + ''')';

End;

procedure AddDateCondition(var query: String; condition: DicomAttribute;
  dbname: String);
begin

  If (condition.Exists) And (condition.value <> '') And
    (condition.value <> '*') Then
  begin
    AddSingleDateCondition(query, condition.DateTimeFrom[StrToTime('1/1/1800')],
      '>=', dbname);
    AddSingleDateCondition(query, condition.DateTimeTo[StrToTime('1/1/2999')],
      '<=', dbname);
  End;

End;

procedure AddLinkedDateTimeCondition(var query: String;
  datecondition: DicomAttribute; timecondition: DicomAttribute; dbname: String);
Var
  startdatetime: TDateTime;
  enddatetime: TDateTime;
begin

  If (datecondition.Exists) And (timecondition.Exists) Then
  begin
    startdatetime := (datecondition.DateTimeFrom[StrToDate('1/1/1800')] +
      timecondition.DateTimeFrom[StrToTime('0')]);
    enddatetime := (datecondition.DateTimeTo[StrToDate('1/1/2999')] +
      timecondition.DateTimeTo[StrToTime('23:59:59')]);

    AddSingleDateCondition(query, startdatetime, '>=', dbname);
    AddSingleDateCondition(query, enddatetime, '<=', dbname);
  end
  else
  begin
    startdatetime := (datecondition.DateTimeFrom[StrToDate('1/1/1800')]);
    enddatetime := (datecondition.DateTimeTo[StrToDate('1/1/2999')]);
    AddSingleDateCondition(query, startdatetime, '>=', dbname);
    AddSingleDateCondition(query, enddatetime, '<=', dbname);
  end;

End;

procedure AddResultItem(DataSet: DicomDataSet; request: DicomDataSet;
  group: int64; element: int64; value: Variant);

Begin

  // Only send items which have been requested
  If (request.Attributes.item[group, element].Exists) Then
  begin
    If (VarIsNull(value)) Then
      value := '';
    DataSet.Attributes.Add(group, element, value);
  End;

End;

procedure TForm1.QueryRequest(ASender: TObject;
  const Connection: IDicomConnection);
Var
  NullSequence: DicomDataSets;
  sql: String;
  rq: DicomDataSet;
  rqs: DicomDataSets;
  rq1: DicomDataSet;

  rr1: DicomDataSet;
  rr: DicomDataSet;
  rrs: DicomDataSets;
  count: integer;
Begin

  If Connection.Root <> 'WORKLIST' Then
  begin
    Log('Not worklist query');
    Exit;
  End;

  if ADOQuery1.Active then
  begin
    ADOQuery1.Close;
    ADOQuery1.sql.Clear;
  end;

  NullSequence := coDicomDataSets.Create();
  rq := coDicomDataSet.Create;
  rqs := coDicomDataSets.Create;
  rq1 := coDicomDataSet.Create;
  rq := Connection.request;
  rqs := DicomDataSets(IDispatch(rq.Attributes.item[$40, $100].value));
  rq1 := rqs.item[1];

  // In a "Real" MWl server, this would either itself be a complex linked query, or a reference to such
  // a query as a "view" or similar in the underlying database
  // the "where TRUE" makes the syntax of adding further conditions simpler, as all are then " AND x=y"

  sql := 'SELECT * from ExamsScheduled where TRUE';

  // Required Matching keys
  AddCondition(sql, rq1.Attributes.item[$40, $1], 'ScheduledAET');
  AddCondition(sql, rq1.Attributes.item[$40, $6], 'PerformingPhysician');
  AddCondition(sql, rq1.Attributes.item[$8, $60], 'Modality');
  AddCondition(sql, rq.Attributes.item[$10, $20], 'PatientID');
  AddNameCondition(sql, rq.Attributes.item[$10, $10], 'surname', 'Forename');

  // if only date ot time are specified, then using standard matching
  // but if both are specified, then MWL defines a combined match

  If not DisableDate.Checked Then
  begin
    AddLinkedDateTimeCondition(sql, rq1.Attributes.item[$40, 2],
      rq1.Attributes.item[$40, 3], 'ExamDateAndTime');
  End;

  // Optional (but commonly used) matching keys.

  AddCondition(sql, rq1.Attributes.item[$40, $10], 'Location');
  AddCondition(sql, rq1.Attributes.item[$40, $11], 'Location');
  AddCondition(sql, rq1.Attributes.item[$40, $7], 'ExamDescription');

  sql := sql + ' order by Surname, Forename';

  Log(sql);
  count := 0;
  ADOQuery1.sql.Add(sql);
  ADOQuery1.Active := true;

  While ((Not ADOQuery1.Eof) And (count < 200)) // limit to 200 results
    do
  begin

    // Set up both "main" result and proecure step dataset in a sequence
    rr1 := coDicomDataSet.Create();
    rr := coDicomDataSet.Create();
    rrs := coDicomDataSets.Create();
    count := count + 1;

    rrs.Add(rr1);
    rr.Attributes.Add($40, $100, rrs);

    // add results to  "main" dataset

    AddResultItem(rr, rq, $8, $50, ADOQuery1.FieldByName('AccessionNumber')
      .text); // T2
    AddResultItem(rr, rq, $8, $80, ADOQuery1.FieldByName('HospitalName').text);
    // //'
    AddResultItem(rr, rq, $8, $90, ADOQuery1.FieldByName('ReferringPhysician')
      .text); // //'T2
    AddResultItem(rr, rq, $10, $10, ADOQuery1.FieldByName('surname').text + '^'
      + ADOQuery1.FieldByName('forename').text + '^^' + ADOQuery1.FieldByName
      ('Title').text); // 'T1
    AddResultItem(rr, rq, $10, $20, ADOQuery1.FieldByName('PatientID').text);
    // 'T1
    AddResultItem(rr, rq, $10, $30, ADOQuery1.FieldByName('DateOfBirth').text);
    // 'T2
    AddResultItem(rr, rq, $10, $40, ADOQuery1.FieldByName('Sex').text); // 'T2
    AddResultItem(rr, rq, $20, $D, ADOQuery1.FieldByName('StudyUID').text);
    // ' T1
    AddResultItem(rr, rq, $32, $1032,
      ADOQuery1.FieldByName('ReferringPhysician').text); // 'T2
    AddResultItem(rr, rq, $32, $1060, ADOQuery1.FieldByName('ExamDescription')
      .text); // 'T1C
    AddResultItem(rr, rq, $40, $1001, ADOQuery1.FieldByName('ProcedureID')
      .text); // ' T1

    // Scheduled Procedure Step sequence T1
    // add results to procedure step dataset

    // Return if requested
    AddResultItem(rr1, rq1, $40, 1, ADOQuery1.FieldByName('ScheduledAET').text);
    // ' T1
    AddResultItem(rr1, rq1, $40, 2, ADOQuery1.FieldByName('ExamDateAndTime')
      .text); // 'T1
    AddResultItem(rr1, rq1, $40, 3, ADOQuery1.FieldByName('ExamDateAndTime')
      .text); // 'T1
    AddResultItem(rr1, rq1, $8, $60, ADOQuery1.FieldByName('modality').text);
    // ' T1
    AddResultItem(rr1, rq1, $40, 6, ADOQuery1.FieldByName('PerformingPhysician')
      .text); // 'T2
    AddResultItem(rr1, rq1, $40, 7, ADOQuery1.FieldByName('ExamDescription')
      .text); // ' T1C
    AddResultItem(rr1, rq1, $40, 9, ADOQuery1.FieldByName('ProcedureStepID')
      .text); // ' T1
    AddResultItem(rr1, rq1, $40, $10, ADOQuery1.FieldByName('ExamRoom').text);
    // 'T2
    AddResultItem(rr1, rq1, $40, $11, ADOQuery1.FieldByName('ExamRoom').text);
    // 'T2

    // Put blanks in for unsupported fields which are type 2 (i.e. must have a value even if NULL)
    // In a real server, you may wish to support some or all of these, but they are not commonly supported

    AddResultItem(rr, rq, $8, $1110, NullSequence); // Ref'd Study Sequence
    AddResultItem(rr, rq, $40, $1003, ''); // Priority
    AddResultItem(rr, rq, $40, $1004, ''); // Transport Arrangements
    AddResultItem(rr, rq, $38, $10, ''); // Admission ID
    AddResultItem(rr, rq, $38, $300, ''); // Patient Location
    AddResultItem(rr, rq, $8, $1120, NullSequence); // Ref'd Patient Sequence
    AddResultItem(rr, rq, $10, $1030, ''); // Weight
    AddResultItem(rr, rq, $40, $3001, ''); // Confidentiality Constraint

    Connection.SendData(rr, $FF00);
    // could use $ff01 if some elements not matched

    Log(rr.PatientID);
    ADOQuery1.Next;
  end;

end;

end.
