VERSION 5.00
Begin VB.Form MWLServer 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "MWLServer"
   ClientHeight    =   6252
   ClientLeft      =   -12
   ClientTop       =   276
   ClientWidth     =   5688
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6252
   ScaleWidth      =   5688
   StartUpPosition =   3  'Windows Default
   Begin VB.CheckBox DisableDate 
      Caption         =   "Disable Date Matching"
      Height          =   255
      Left            =   240
      TabIndex        =   3
      Top             =   2520
      Value           =   1  'Checked
      Width           =   2775
   End
   Begin VB.TextBox Logger 
      Height          =   3135
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   0
      Top             =   3000
      Width           =   5412
   End
   Begin VB.Label Label2 
      Caption         =   "For early testing/development, you may wish to disable the ""date"" matching, to save having to update your database every day"
      Height          =   495
      Left            =   120
      TabIndex        =   2
      Top             =   1920
      Width           =   5295
   End
   Begin VB.Label Label1 
      Caption         =   $"ModalityWorklist.frx":0000
      Height          =   1695
      Left            =   120
      TabIndex        =   1
      Top             =   120
      Width           =   5295
   End
End
Attribute VB_Name = "MWLServer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim WithEvents server As DicomServer
Attribute server.VB_VarHelpID = -1
Dim db As adodb.Connection

Private Sub Form_Load()
    Dim g As New DicomGlobal
    Me.Caption = Me.Caption & " DO v" & g.Version
    g.RegWord("log") = 1
    g.RegString("loglocation") = "C:\dicom log files"
    g.RegWord("loglevel") = 63
    Set server = New DicomServer
    server.Listen 104
    OpenDataBase
End Sub

Function getSQLInstanceNames() As String
    Dim i As Integer
    Dim sValues As String
    Dim Value As String
    Module.fEnumKey "HKLM", "SYSTEM\CurrentControlSet\services", sValues
   
    Dim keys() As String
    keys = Split(sValues, "|")
    
    For i = 1 To UBound(keys)
        If keys(i) = "MSSQL$SQLEXPRESS" Then
            Dim k As Boolean
            k = True
        End If
        If keys(i) = "MSSQLSERVER" Or InStr(1, keys(i), "MSSQL$") Then
            If Value = "" Then
                Value = keys(i)
            Else
                Value = Value & "|" & keys(i)
            End If
        End If
    Next
    getSQLInstanceNames = Value
End Function

Function OpenDataBase() As Boolean

   Dim i As Integer
    Dim values() As String
    Dim names() As String
    names = Split(getSQLInstanceNames(), "|")
    Dim serverName As String
    Dim cs As String
    Dim errorMsg As String
    
   If UBound(names) <= 0 Then
         MsgBox "Error Connecting to Database, could not find a SQL Server instance."
         OpenDataBase = False
         Exit Function
    End If
        
    
   For i = 0 To UBound(names)
        Set db = New adodb.Connection
        If names(i) = "MSSQLSERVER" Then
            serverName = "."
        Else
            serverName = ".\" & Mid(names(i), 7)
        End If
        
       cs = "PROVIDER = MSDASQL;driver={SQL Server};server=" & serverName & ";Database=DICOM;Trusted_Connection=Yes;"
        On Error GoTo errorHandler
        db.Open cs
        
       ' this is to test that the DB really IS open and functioning and force next name if it is not
        db.Execute "Select * from DICOM.dbo.Configuration"
        
       OpenDataBase = True
        Exit Function
        
errorHandler:
        errorMsg = "Error Connecting Database - " & Err.Description
    Next
    
   If Not errorMsg = "" Then
         MsgBox "Error Connecting Database, Please check you have a functional SQL server instance and you have permissions to connect"
         OpenDataBase = False
    End If
End Function


Private Sub server_AssociationRequest(ByVal Connection As DicomObjects8.DicomConnection, isOK As Boolean)
    Log "Request from " & Connection.CallingAET & " at " & Connection.LocalIP
    Dim ac As DicomContext
    For Each ac In Connection.Contexts
        If ac.AbstractSyntax <> doSOP_ModalityWorklistQR_FIND And ac.AbstractSyntax <> doSOP_Verification Then
            ac.Reject 3
        End If
    Next
End Sub

Private Sub AddResultItem(DataSet As DicomDataSet, request As DicomDataSet, group As Long, element As Long, Value As Variant)
    'Only send items which have been requested
    If request.Attributes(group, element).Exists Then
        If IsNull(Value) Then Value = ""
               
        'If IsNull(value) Then Exit For ' Do not return blanks for type 1 attributes
        DataSet.Attributes.Add group, element, Value
    End If
End Sub

Private Function NewResultItem(request As DicomDataSet) As Object
    Dim d As DicomDataSet, a As Object
    Set d = CreateObject("DicomObjects8.DicomDataSet")
    For Each a In request.Attributes
        d.Attributes.Add a.group, a.element, a.Value
    Next
    Set NewResultItem = d
End Function

Private Sub AddCondition(ByRef query As String, condition As DicomAttribute, dbname As String)
    Dim i As Integer
    Dim values As Variant
    If condition.Exists And Not IsNull(condition.Value) Then
        If condition.Multiple Then
            query = query & " AND ( FALSE"
            values = condition.Value
            For i = 1 To UBound(values, 1)
                query = query & " OR " & dbname & " = '" & values(i) & "'"
            Next
            query = query & " )"
        Else
            AddStringCondition query, condition.Value, dbname
        End If
    End If
End Sub

Private Sub AddStringCondition(ByRef query As String, condition As String, dbname As String)
    If condition <> "" And condition <> "*" Then
        If InStr(condition, "*") Then
            query = query & " AND " & dbname & " like '" & StarToPercent(condition) & "'"
        Else
            query = query & " AND " & dbname & " = '" & condition & "'"
        End If
    End If
End Sub

Function StarToPercent(ByVal a As String) As String
    Dim z As Integer
    While InStr(a, "*")
        z = InStr(a, "*")
        a = Left(a, z - 1) & "%" & Mid(a, z + 1)
    Wend
    StarToPercent = a
End Function

Private Sub AddSingleDateCondition(ByRef query As String, condition As Date, operator As String, dbname As String)
    ' all date formating goes through here to make it easy to change for different databases or locales
    query = query & " AND " & dbname & operator & "#" & Format(condition, "yyyy-mm-dd hh:mm") & "#"
End Sub

Private Sub AddDateCondition(ByRef query As String, condition As DicomAttribute, dbname As String)
    If condition.Exists And condition.Value <> "" And condition.Value <> "*" Then
        AddSingleDateCondition query, condition.DateTimeFrom("1/1/1800"), ">=", dbname
        AddSingleDateCondition query, condition.DateTimeTo("1/1/2999"), "<=", dbname
    End If
End Sub

Sub AddLinkedDateTimeCondition(ByRef query As String, datecondition As DicomAttribute, timecondition As DicomAttribute, dbname As String)
    Dim startdatetime As Date, enddatetime As Date
    If datecondition.Exists And timecondition.Exists Then
        startdatetime = datecondition.DateTimeFrom("1/1/1800") + timecondition.DateTimeFrom("0")
        enddatetime = datecondition.DateTimeTo("1/1/2999") + timecondition.DateTimeTo("0.9999")
        AddSingleDateCondition query, startdatetime, ">=", dbname
        AddSingleDateCondition query, enddatetime, "<=", dbname
        
    Else
        AddDateCondition query, datecondition, "DateValue(" & dbname & ")"
        AddDateCondition query, timecondition, "TimeValue(" & dbname & ")"
    End If
End Sub

Sub AddNameCondition(ByRef query As String, condition As DicomAttribute, dbsurname As String, dbforename As String)
    Dim ptname As String, surname As String, forename As String
    'Name needs to be split
    If condition.Exists Then
        ptname = condition.Value & "^^^^"
        If ptname <> "" And ptname <> "*" Then
            surname = Left(ptname, InStr(ptname, "^") - 1)
            ptname = Mid(ptname, Len(surname) + 2)
            forename = Left(ptname, InStr(ptname, "^") - 1)
            AddStringCondition query, surname, dbsurname
            AddStringCondition query, forename, dbforename
        End If
    End If
End Sub

Private Sub server_QueryRequest(ByVal Connection As DicomObjects8.DicomConnection)
    Dim result As Recordset
    Dim NullSequence As New DicomDataSets
    Dim D1 As DicomAttribute
    Dim sql As String
    Dim rq As DicomDataSet, rqs As DicomDataSets, rq1 As DicomDataSet
    If Connection.Root <> "WORKLIST" Then
        Log "Not worklist query"
        Exit Sub
    End If
    
    Set rq = Connection.request
    Set rqs = rq.Attributes(&H40, &H100).Value
    Set rq1 = rqs(1)
    
    ' In a "Real" MWl server, this would either itself be a complex linked query, or a reference to such
    ' a query as a "view" or similar in the underlying database
    ' the "where TRUE" makes the syntax of adding further conditions simpler, as all are then " AND x=y"
    
    sql = "SELECT * from Dicom.dbo.ExamsScheduled where 1=1 "

    'sqlWhere = " where true "
    'Required Matching keys
    AddCondition sql, rq1.Attributes(&H40, &H1), "ScheduledAET"
    AddCondition sql, rq1.Attributes(&H40, &H6), "PerformingPhysician"
    AddCondition sql, rq1.Attributes(&H8, &H60), "Modality"
    AddCondition sql, rq.Attributes(&H10, &H20), "PatientID"
    AddNameCondition sql, rq.Attributes(&H10, &H10), "surname", "Forename"
        
    ' if only date ot time are specified, then using standard matching
    ' but if both are specified, then MWL defines a combined match
    
    If DisableDate = 0 Then
        AddLinkedDateTimeCondition sql, rq1.Attributes(&H40, 2), rq1.Attributes(&H40, 3), "ExamDateAndTime"
    End If
    
    ' Optional (but commonly used) matching keys.
    
    AddCondition sql, rq1.Attributes(&H40, &H10), "Location"
    AddCondition sql, rq1.Attributes(&H40, &H11), "Location"
    AddCondition sql, rq1.Attributes(&H40, &H7), "ExamDescription"
       
    sql = sql & " order by Surname, Forename"
    
    
    Log sql
    Set result = db.Execute(sql, , adCmdText)
    
    Dim rr1 As DicomDataSet
    Dim rr As DicomDataSet
    Dim rrs As DicomDataSets
    Dim count As Integer
    count = 0
    
    While Not result.EOF And count < 200 ' limit to 200 results

        ' Set up both "main" result and proecure step dataset in a sequence
        Set rr1 = New DicomDataSet
        Set rr = New DicomDataSet
        Set rrs = New DicomDataSets
        count = count + 1
        
        rrs.Add rr1
        rr.Attributes.Add &H40, &H100, rrs
        
        ' add results to  "main" dataset
              
        AddResultItem rr, rq, &H8, &H50, result!AccessionNumber 'T2
        AddResultItem rr, rq, &H8, &H80, result!HospitalName '
        AddResultItem rr, rq, &H8, &H90, result!ReferringPhysician 'T2
        
        AddResultItem rr, rq, &H10, &H10, result!surname & "^" & result!forename & "^^" & result!Title 'T1
        AddResultItem rr, rq, &H10, &H20, result!PatientID 'T1
        AddResultItem rr, rq, &H10, &H30, result!DateOfBirth 'T2
        AddResultItem rr, rq, &H10, &H40, result!Sex 'T2
        
        AddResultItem rr, rq, &H20, &HD, result!StudyUID ' T1
        
        AddResultItem rr, rq, &H32, &H1032, result!ReferringPhysician 'T2
        AddResultItem rr, rq, &H32, &H1060, result!ExamDescription 'T1C

        AddResultItem rr, rq, &H40, &H1001, result!ProcedureID ' T1
                
        ' Scheduled Procedure Step sequence T1
        ' add results to procedure step dataset
                
        'Return if requested
        AddResultItem rr1, rq1, &H40, 1, result!ScheduledAET    ' T1
        AddResultItem rr1, rq1, &H40, 2, result!ExamDateAndTime ' T1
        AddResultItem rr1, rq1, &H40, 3, result!ExamDateAndTime ' T1
        AddResultItem rr1, rq1, &H8, &H60, result!modality      ' T1
        
        AddResultItem rr1, rq1, &H40, 6, result!PerformingPhysician ' T2
        AddResultItem rr1, rq1, &H40, 7, result!ExamDescription     ' T1C
        AddResultItem rr1, rq1, &H40, 9, result!ProcedureStepID     ' T1
        AddResultItem rr1, rq1, &H40, &H10, result!ExamRoom         ' T2
        AddResultItem rr1, rq1, &H40, &H11, result!ExamRoom         ' T2
              
        ' Put blanks in for unsupported fields which are type 2 (i.e. must have a value even if NULL)
        ' In a real server, you may wish to support some or all of these, but they are not commonly supported
        
        AddResultItem rr, rq, &H8, &H1110, NullSequence     ' Ref'd Study Sequence
        AddResultItem rr, rq, &H40, &H1003, ""              ' Priority
        AddResultItem rr, rq, &H40, &H1004, ""              ' Transport Arrangements
        AddResultItem rr, rq, &H38, &H10, ""                ' Admission ID
        AddResultItem rr, rq, &H38, &H300, ""               ' Patient Location
        AddResultItem rr, rq, &H8, &H1120, NullSequence     ' Ref'd Patient Sequence
        AddResultItem rr, rq, &H10, &H1030, ""              ' Weight
        AddResultItem rr, rq, &H40, &H3001, ""              ' Confidentiality Constraint
                
        Connection.SendData rr, &HFF00                      ' could use &hff01 if some elements not matched
        
        Log rr.PatientID
        
        result.MoveNext
    Wend
    Connection.SendStatus 0
    
    Exit Sub
err1:
    Log Err.Description
    Connection.SendStatus 99
    
End Sub

Private Sub server_VerifyReceived(Status As Long)
    Status = 0
End Sub

Sub Log(X As String)
    Logger = Logger & vbCrLf & Now() & " " & X
    If Len(Logger) > 1500 Then Logger = Right(Logger, 1000)
End Sub







