VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form LicenseManager 
   Caption         =   "DicomObjects Sample License Manager"
   ClientHeight    =   6045
   ClientLeft      =   120
   ClientTop       =   450
   ClientWidth     =   7800
   LinkTopic       =   "Form1"
   ScaleHeight     =   6045
   ScaleWidth      =   7800
   StartUpPosition =   3  'Windows Default
   Begin MSComctlLib.ListView licenseList 
      Height          =   2772
      Left            =   120
      TabIndex        =   5
      Top             =   2040
      Width           =   7332
      _ExtentX        =   12938
      _ExtentY        =   4895
      View            =   3
      LabelEdit       =   1
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      FullRowSelect   =   -1  'True
      GridLines       =   -1  'True
      _Version        =   393217
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   0
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Arial CE"
         Size            =   9.75
         Charset         =   238
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      NumItems        =   4
      BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         Text            =   "License Type"
         Object.Width           =   2999
      EndProperty
      BeginProperty ColumnHeader(2) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         SubItemIndex    =   1
         Text            =   "Expiry Date"
         Object.Width           =   2540
      EndProperty
      BeginProperty ColumnHeader(3) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         SubItemIndex    =   2
         Text            =   "Allowed Functions"
         Object.Width           =   3528
      EndProperty
      BeginProperty ColumnHeader(4) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         SubItemIndex    =   3
         Text            =   "Maching MachineID"
         Object.Width           =   3528
      EndProperty
   End
   Begin VB.PictureBox Picture2 
      Appearance      =   0  'Flat
      AutoSize        =   -1  'True
      BackColor       =   &H80000005&
      DrawStyle       =   5  'Transparent
      ForeColor       =   &H80000008&
      Height          =   1455
      Left            =   2640
      Picture         =   "LicenseManager.frx":0000
      ScaleHeight     =   71.25
      ScaleMode       =   2  'Point
      ScaleWidth      =   150
      TabIndex        =   4
      Top             =   240
      Width           =   3030
   End
   Begin VB.CommandButton deleteSelectedLicenseBTN 
      Caption         =   "De-Activate Selected License"
      Height          =   855
      Left            =   2880
      TabIndex        =   3
      Top             =   4920
      Width           =   1815
   End
   Begin VB.CommandButton getLicenseBTN 
      Caption         =   "Get  New License"
      Height          =   855
      Left            =   480
      TabIndex        =   2
      Top             =   4920
      Width           =   1935
   End
   Begin VB.CommandButton deleteAllBTN 
      Caption         =   "De-Activate All Licenses"
      Height          =   855
      Left            =   5160
      TabIndex        =   1
      Top             =   4920
      Width           =   1815
   End
   Begin VB.Label MachineID 
      Caption         =   "Machine ID = "
      Height          =   255
      Left            =   5520
      TabIndex        =   0
      Top             =   1800
      Width           =   1935
   End
End
Attribute VB_Name = "LicenseManager"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim dlg As DicomLicenseGlobal
Dim lic As DicomLicense
Dim installedLicences As Variant

Dim list As ListItem

Private Sub populateLicenceList()
    licenseList.ListItems.Clear
    installedLicences = dlg.InstalledLicenses
    Dim i As Integer
    For i = LBound(installedLicences) To UBound(installedLicences)
        Set lic = installedLicences(i)
        
        Set list = licenseList.ListItems.Add(, , getLicenseType(lic.LicenseType))
        list.SubItems(1) = lic.Expiry
        list.SubItems(2) = lic.AllowedFunctions
        list.SubItems(3) = lic.MachineID
        
        If lic.Expiry < Now Then
            setRowColour vbRed, list
        Else
            setRowColour &H6AA5E, list
        End If
    Next
End Sub

Private Sub setRowColour(ByVal c As OLE_COLOR, ByRef list As ListItem)
    For i = 1 To list.ListSubItems.count
        list.ListSubItems.Item(i).ForeColor = c
    Next
    list.ForeColor = c
End Sub

Private Function getLicenseType(ByVal t As String) As String
    Dim tp As String
    Select Case t
        Case 0
            tp = "Full License"
        Case 1
            tp = "Developer License"
        Case 2
            tp = "Trial License"
        Case 3
            tp = "Demo License"
    End Select
    
    getLicenseType = tp
End Function

' delete and deactivate all licenses
Private Sub deleteAllBTN_Click()
 Dim dialog As New InfoDialog
    dialog.Show vbModal, Me
    If dialog.result Then
        Dim result As String
        result = dlg.DeactivateOnLine(dialog.txtCustomerInfo1, dialog.txtCustomerInfo2)
        MsgBox result, vbOKOnly
        licenseList.ListItems.Clear
    End If
End Sub

' delete and deactivate selected license only
Private Sub deleteSelectedLicenseBTN_Click()
    Dim i, count As Integer
    Dim fileVersion, result As String
    Dim g As New DicomGlobal
    fileVersion = g.Version
    count = 0
    For i = 0 To licenseList.ListItems.count - 1
        If licenseList.ListItems.Item(i + 1).Selected Then
            '   Deleting selected licences
            Set lic = installedLicences(i)
            If MsgBox("Are you sure you want to Deactivate the selected License?", vbYesNo) = vbYes Then
                result = lic.Deactivate(dlg.MachineID, fileVersion)
                MsgBox ("result: " + result)
                count = count + 1
                Exit For
            End If
        End If
    Next
    
    
    ' Clearing licence list on GUI
    If count > 0 Then
        licenseList.ListItems.Remove (i + 1)
    End If
    populateLicenceList
End Sub

Private Sub Form_Load()
    Dim g As New DicomGlobal
    
    ' this helps trouble-shoot licensing problems
    g.RegWord("LogMachineIDInfo") = 1
    g.RegString("LogLocation") = App.Path
    g.RegWord("LogLevel") = &H3F
    g.RegWord("Log") = 1
    ' send us the log file for checking if you have license problems
    
    Me.Caption = Me.Caption & " v" & g.Version
    Set dlg = New DicomLicenseGlobal
    MachineID.Caption = MachineID.Caption & dlg.MachineID
    populateLicenceList
End Sub

Private Sub getLicenseBTN_Click()
    dlg.ShowActivationDialog
    populateLicenceList
End Sub
