if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_StudyTable_PatientTable]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[StudyTable] DROP CONSTRAINT FK_StudyTable_PatientTable
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_ImageTable_SeriesTable]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[ImageTable] DROP CONSTRAINT FK_ImageTable_SeriesTable
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_SeriesTable_StudyTable]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[SeriesTable] DROP CONSTRAINT FK_SeriesTable_StudyTable
GO

/****** Object:  User Defined Function dbo.FunctionModalitiesInStudy    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FunctionModalitiesInStudy]') and xtype in (N'FN', N'IF', N'TF'))
drop function [dbo].[FunctionModalitiesInStudy]
GO

/****** Object:  Stored Procedure dbo.GetFileName    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[GetFileName]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[GetFileName]
GO

/****** Object:  Stored Procedure dbo.ImageExists    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ImageExists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ImageExists]
GO

/****** Object:  Stored Procedure dbo.InsertImage    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[InsertImage]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[InsertImage]
GO

/****** Object:  Stored Procedure dbo.InsertPatient    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[InsertPatient]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[InsertPatient]
GO

/****** Object:  Stored Procedure dbo.InsertSeries    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[InsertSeries]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[InsertSeries]
GO

/****** Object:  Stored Procedure dbo.InsertStudy    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[InsertStudy]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[InsertStudy]
GO

/****** Object:  View dbo.ImageRetrievalView    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ImageRetrievalView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[ImageRetrievalView]
GO

/****** Object:  View dbo.ImageView    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ImageView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[ImageView]
GO

/****** Object:  View dbo.PatientView    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[PatientView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[PatientView]
GO

/****** Object:  View dbo.SeriesView    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SeriesView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[SeriesView]
GO

/****** Object:  View dbo.StudyPatientView    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[StudyPatientView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[StudyPatientView]
GO

/****** Object:  View dbo.StudyStudyView    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[StudyStudyView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[StudyStudyView]
GO

/****** Object:  Table [dbo].[Configuration]    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Configuration]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[Configuration]
GO

/****** Object:  Table [dbo].[Events]    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Events]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[Events]
GO

/****** Object:  Table [dbo].[Fields]    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Fields]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[Fields]
GO

/****** Object:  Table [dbo].[ImageTable]    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ImageTable]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[ImageTable]
GO

/****** Object:  Table [dbo].[PatientTable]    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[PatientTable]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[PatientTable]
GO

/****** Object:  Table [dbo].[RemoteAETs]    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[RemoteAETs]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[RemoteAETs]
GO

/****** Object:  Table [dbo].[SeriesTable]    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SeriesTable]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[SeriesTable]
GO

/****** Object:  Table [dbo].[StudyTable]    Script Date: 19/03/2003 18:16:17 ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[StudyTable]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[StudyTable]
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  User Defined Function dbo.FunctionModalitiesInStudy    Script Date: 19/03/2003 18:16:19 ******/
CREATE FUNCTION dbo.FunctionModalitiesInStudy
	(
		@StudyUID varchar(64)
	)
RETURNS varchar(50)
AS
BEGIN
	
	DECLARE @result varchar(80), @isFirst bit, @thismod varchar(10)
	DECLARE mod_cursor CURSOR FORWARD_ONLY 
	FOR SELECT DISTINCT Modality
	FROM         dbo.SeriesTable
	WHERE     (StudyUID_FKey = @StudyUID)
	
	OPEN mod_cursor
	SET @isFirst=1
	SET @result=''
	FETCH NEXT FROM mod_cursor INTO @thismod

	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @isFirst=0  
			SET @result=@result + '\'
		ELSE
			SET @isFirst=0
		SET @result=@result + @thismod	
		FETCH NEXT FROM mod_cursor INTO @thismod
	
	END
	CLOSE mod_cursor
	DEALLOCATE mod_cursor

	RETURN @result
END


GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  Table [dbo].[Configuration]    Script Date: 19/03/2003 18:16:17 ******/
CREATE TABLE [dbo].[Configuration] (
	[ImplementationName] [char] (16) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[ImplementationUID] [char] (64) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[LocalAET] [char] (16) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[LocalPort] [int] NOT NULL ,
	[RelationalQueries] [bit] NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[Events]    Script Date: 19/03/2003 18:16:18 ******/
CREATE TABLE [dbo].[Events] (
	[EventID] [int] IDENTITY (1, 1) NOT NULL ,
	[DateTime] [datetime] NOT NULL ,
	[Severity] [smallint] NOT NULL ,
	[PatientID] [varchar] (64) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[Description] [varchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[Fields]    Script Date: 19/03/2003 18:16:18 ******/
CREATE TABLE [dbo].[Fields] (
	[FieldID] [int] IDENTITY (1, 1) NOT NULL ,
	[GroupID] [smallint] NOT NULL ,
	[ElementID] [smallint] NOT NULL ,
	[FieldName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[FieldSource] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[FieldMatch] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[ForMatching] [bit] NOT NULL ,
	[ForStoring] [bit] NOT NULL ,
	[IsName] [bit] NOT NULL ,
	[isDate] [bit] NOT NULL ,
	[PATIENT] [bit] NOT NULL ,
	[STUDYSTUDY] [bit] NOT NULL ,
	[STUDYPATIENT] [bit] NOT NULL ,
	[SERIES] [bit] NOT NULL ,
	[IMAGE] [bit] NOT NULL ,
	[FILENAME] [bit] NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[ImageTable]    Script Date: 19/03/2003 18:16:18 ******/
CREATE TABLE [dbo].[ImageTable] (
	[InstanceUID] [varchar] (64) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[SeriesUID_FKey] [varchar] (64) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[InstanceNumber] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[Filename] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[PatientTable]    Script Date: 19/03/2003 18:16:18 ******/
CREATE TABLE [dbo].[PatientTable] (
	[PatientID] [varchar] (64) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[Name_First] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[Name_Middle] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[Name_Last] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[Name_Title] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[DateOfBirth] [datetime] NULL ,
	[Sex] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[RemoteAETs]    Script Date: 19/03/2003 18:16:18 ******/
CREATE TABLE [dbo].[RemoteAETs] (
	[RemoteAET] [char] (16) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[IPAddress] [char] (32) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[Port] [int] NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[SeriesTable]    Script Date: 19/03/2003 18:16:18 ******/
CREATE TABLE [dbo].[SeriesTable] (
	[SeriesUID] [varchar] (64) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[StudyUID_FKey] [varchar] (64) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[Modality] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[SeriesNumber] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[SeriesDescription] [varchar] (64) COLLATE SQL_Latin1_General_CP1_CI_AS NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[StudyTable]    Script Date: 19/03/2003 18:16:19 ******/
CREATE TABLE [dbo].[StudyTable] (
	[StudyUID] [varchar] (64) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[PatientID_FKey] [varchar] (64) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[StudyDate] [datetime] NULL ,
	[StudyTime] [datetime] NULL ,
	[AccessionNumber] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[StudyID] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[ReferringPhysician_First] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[ReferringPhysician_Middle] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[ReferringPhysician_Last] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[ReferringPhysician_Title] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[StudyDescription] [varchar] (64) COLLATE SQL_Latin1_General_CP1_CI_AS NULL 
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[Events] WITH NOCHECK ADD 
	CONSTRAINT [PK_Events] PRIMARY KEY  CLUSTERED 
	(
		[EventID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[ImageTable] WITH NOCHECK ADD 
	CONSTRAINT [PK_ImageView] PRIMARY KEY  CLUSTERED 
	(
		[InstanceUID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[PatientTable] WITH NOCHECK ADD 
	CONSTRAINT [PK_PatientTable] PRIMARY KEY  CLUSTERED 
	(
		[PatientID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[SeriesTable] WITH NOCHECK ADD 
	CONSTRAINT [PK_SeriesTable] PRIMARY KEY  CLUSTERED 
	(
		[SeriesUID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[StudyTable] WITH NOCHECK ADD 
	CONSTRAINT [PK_STUDYTABLE] PRIMARY KEY  CLUSTERED 
	(
		[StudyUID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Events] ADD 
	CONSTRAINT [DF_Events_DateTime] DEFAULT (getdate()) FOR [DateTime]
GO

ALTER TABLE [dbo].[Fields] ADD 
	CONSTRAINT [DF_Fields_ForStoring] DEFAULT (1) FOR [ForStoring],
	CONSTRAINT [DF_Fields_PATIENT] DEFAULT (0) FOR [PATIENT]
GO

 CREATE  INDEX [IX_ImageTable] ON [dbo].[ImageTable]([SeriesUID_FKey]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_PatientTable] ON [dbo].[PatientTable]([Name_Last], [Sex], [DateOfBirth]) ON [PRIMARY]
GO

ALTER TABLE [dbo].[RemoteAETs] ADD 
	CONSTRAINT [PK_RemoteAETs] PRIMARY KEY  NONCLUSTERED 
	(
		[RemoteAET]
	)  ON [PRIMARY] 
GO

 CREATE  INDEX [IX_SeriesTable] ON [dbo].[SeriesTable]([StudyUID_FKey], [Modality]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_StudyTable] ON [dbo].[StudyTable]([PatientID_FKey]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_StudyTable_1] ON [dbo].[StudyTable]([StudyDate], [AccessionNumber]) ON [PRIMARY]
GO

ALTER TABLE [dbo].[ImageTable] ADD 
	CONSTRAINT [FK_ImageTable_SeriesTable] FOREIGN KEY 
	(
		[SeriesUID_FKey]
	) REFERENCES [dbo].[SeriesTable] (
		[SeriesUID]
	)
GO

ALTER TABLE [dbo].[SeriesTable] ADD 
	CONSTRAINT [FK_SeriesTable_StudyTable] FOREIGN KEY 
	(
		[StudyUID_FKey]
	) REFERENCES [dbo].[StudyTable] (
		[StudyUID]
	)
GO

ALTER TABLE [dbo].[StudyTable] ADD 
	CONSTRAINT [FK_StudyTable_PatientTable] FOREIGN KEY 
	(
		[PatientID_FKey]
	) REFERENCES [dbo].[PatientTable] (
		[PatientID]
	)
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  View dbo.ImageRetrievalView    Script Date: 19/03/2003 18:16:19 ******/
CREATE VIEW dbo.ImageRetrievalView
AS
SELECT     dbo.PatientTable.PatientID, dbo.StudyTable.StudyUID, dbo.SeriesTable.SeriesUID, dbo.ImageTable.InstanceUID, dbo.ImageTable.Filename, 
                      dbo.StudyTable.StudyDate, dbo.SeriesTable.SeriesNumber, dbo.ImageTable.InstanceNumber
FROM         dbo.PatientTable INNER JOIN
                      dbo.StudyTable ON dbo.PatientTable.PatientID = dbo.StudyTable.PatientID_FKey INNER JOIN
                      dbo.SeriesTable ON dbo.StudyTable.StudyUID = dbo.SeriesTable.StudyUID_FKey INNER JOIN
                      dbo.ImageTable ON dbo.SeriesTable.SeriesUID = dbo.ImageTable.SeriesUID_FKey

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  View dbo.ImageView    Script Date: 19/03/2003 18:16:19 ******/
CREATE VIEW dbo.ImageView
AS
SELECT     dbo.ImageTable.*
FROM         dbo.ImageTable

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  View dbo.PatientView    Script Date: 19/03/2003 18:16:19 ******/
CREATE VIEW dbo.PatientView
AS
SELECT     dbo.PatientTable.*
FROM         dbo.PatientTable

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  View dbo.SeriesView    Script Date: 19/03/2003 18:16:19 ******/
CREATE VIEW dbo.SeriesView
AS
SELECT     dbo.SeriesTable.*
FROM         dbo.SeriesTable

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  View dbo.StudyPatientView    Script Date: 19/03/2003 18:16:19 ******/
CREATE VIEW dbo.StudyView
AS
SELECT     dbo.StudyTable.*
FROM         dbo.StudyTable

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  View dbo.StudyStudyView    Script Date: 19/03/2003 18:16:19 ******/
CREATE VIEW dbo.View9
AS
SELECT     dbo.PatientTable.*, dbo.StudyTable.*
FROM         dbo.StudyTable INNER JOIN
                      dbo.PatientTable ON dbo.StudyTable.PatientID_FKey = dbo.PatientTable.PatientID

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  Stored Procedure dbo.GetFileName    Script Date: 19/03/2003 18:16:19 ******/
CREATE PROCEDURE dbo.GetFileName

	(
		@InstanceUID		varchar(64),
		@StudyDate			datetime,
		@AccessionNumber	varchar(16),
		@Modality			varchar(16),
		@PatientID			varchar(16),
		@SeriesUID			varchar(64),
		@StudyUID			varchar(64)
	)

AS
	
	select 'C:\IMAGES\' 
	+ @Modality + '\' 
	+ isnull(convert(varchar,@StudyDate,105),'00-00-00') + '\' 
	+ isnull(@PatientID,'NULL_ID') + '\' 
	+ @InstanceUID as filename
	RETURN 

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  Stored Procedure dbo.ImageExists    Script Date: 19/03/2003 18:16:19 ******/
CREATE PROCEDURE dbo.ImageExists

		@InstanceUID varchar(64)

AS
	SET NOCOUNT ON
	SELECT count(*) as count FROM ImageTABLE WHERE InstanceUID=@InstanceUID 

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  Stored Procedure dbo.InsertImage    Script Date: 19/03/2003 18:16:19 ******/
CREATE PROCEDURE dbo.InsertImage
		@InstanceUID		varchar(64),
		@SeriesUID_FKey		varchar(64),
		@InstanceNumber		int,
		@Filename			varchar(255)

AS
SET NOCOUNT ON 
IF NOT EXISTS (SELECT * FROM ImageTABLE WHERE InstanceUID=@InstanceUID)
BEGIN
	INSERT into ImageTABLE values 
	(
		@InstanceUID,
		@SeriesUID_FKey,
		@InstanceNumber,
		@Filename
)
END
	RETURN 

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  Stored Procedure dbo.InsertPatient    Script Date: 19/03/2003 18:16:19 ******/
CREATE PROCEDURE dbo.InsertPatient

		@Name_first				varchar(32),
		@Name_middle			varchar(32),
		@Name_last				varchar(32),
		@Name_title				varchar(32),
		@PatientID				varchar(64),
		@DateOfBirth			datetime,
		@Sex					varchar(1)

AS
SET NOCOUNT ON 
IF NOT EXISTS (SELECT * FROM PATIENTTABLE WHERE PATIENTID=@PatientID)
BEGIN
	INSERT into PATIENTTABLE values 
	( @PatientID, @Name_first,@Name_middle,@Name_last,@Name_Title,
	@dateOfBirth,@Sex )
END
	RETURN 

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  Stored Procedure dbo.InsertSeries    Script Date: 19/03/2003 18:16:19 ******/
CREATE PROCEDURE dbo.InsertSeries
		@SeriesUID					varchar(64),
		@StudyUID_FKey				varchar(64),
		@Modality					varchar(16),
		@SeriesNumber				int,
		@SeriesDescription			varchar(64)

AS
SET NOCOUNT ON 
IF NOT EXISTS (SELECT * FROM SeriesTABLE WHERE SeriesUID=@SeriesUID)
BEGIN
	INSERT into SeriesTABLE values 
	(
		@SeriesUID,
		@StudyUID_FKey,
		@Modality,
		@SeriesNumber,
		@SeriesDescription
)
END
	RETURN 

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

/****** Object:  Stored Procedure dbo.InsertStudy    Script Date: 19/03/2003 18:16:19 ******/
CREATE PROCEDURE dbo.InsertStudy
		@StudyUID					varchar(64),
		@PatientID_FKey				varchar(64),
		@StudyDate					datetime,
		@StudyTime					datetime,
		@AccessionNumber			varchar(16),
		@StudyID					varchar(16),
		@ReferringPhysician_first	varchar(32),
		@ReferringPhysician_middle	varchar(32),
		@ReferringPhysician_last	varchar(32),
		@ReferringPhysician_title	varchar(10),
		@StudyDescription			varchar(64)

AS
SET NOCOUNT ON 
IF NOT EXISTS (SELECT * FROM STUDYTABLE WHERE STUDYUID=@StudyUID)
BEGIN
	INSERT into STUDYTABLE values 
	( 	@StudyUID,
		@PatientID_FKey	,
		@StudyDate,
		@StudyTime,
		@AccessionNumber,
		@StudyID,
		@ReferringPhysician_first,
		@ReferringPhysician_middle,
		@ReferringPhysician_last,
		@ReferringPhysician_title,
		@StudyDescription
 )
END
	RETURN 

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

