Attribute VB_Name = "DataBase"
Dim db As adodb.Connection

Function getSQLInstanceNames() As String
    Dim i As Integer
    Dim sValues As String
    Dim Value As String
    Module.fEnumKey "HKLM", "SYSTEM\CurrentControlSet\services", sValues
   
    Dim keys() As String
    keys = Split(sValues, "|")
    
    For i = 1 To UBound(keys)
        If keys(i) = "MSSQL$SQLEXPRESS" Then
            Dim k As Boolean
            k = True
        End If
        If keys(i) = "MSSQLSERVER" Or InStr(1, keys(i), "MSSQL$") Then
            If Value = "" Then
                Value = keys(i)
            Else
                Value = Value & "|" & keys(i)
            End If
        End If
    Next
    getSQLInstanceNames = Value
End Function

Function OpenDataBase() As Boolean

   Dim i As Integer
    Dim values() As String
    Dim names() As String
    names = Split(getSQLInstanceNames(), "|")
    Dim serverName As String
    Dim cs As String
    Dim errorMsg As String
    
   If UBound(names) <= 0 Then
         MsgBox "Error Connecting to Database, could not find a SQL Server instance."
         OpenDataBase = False
         Exit Function
    End If
        
    
   For i = 0 To UBound(names)
        Set db = New adodb.Connection
        If names(i) = "MSSQLSERVER" Then
            serverName = "."
        Else
            serverName = ".\" & Mid(names(i), 7)
        End If
        
       cs = "PROVIDER = MSDASQL;driver={SQL Server};server=" & serverName & ";Database=DICOM;Trusted_Connection=Yes;"
        On Error GoTo errorHandler
        db.Open cs
        
       ' this is to test that the DB really IS open and functioning and force next name if it is not
        db.Execute "Select * from DICOM.dbo.Configuration"
        
       OpenDataBase = True
        Exit Function
        
errorHandler:
        errorMsg = "Error Connecting Database - " & Err.Description
    Next
    
   If Not errorMsg = "" Then
         MsgBox "Error Connecting Database, Please check you have a functional SQL server instance and you have permissions to connect"
         OpenDataBase = False
    End If
End Function

Function DBExecute(query As String) As Recordset
    Dim rec As New adodb.Recordset
    Dim res As String
    res = CheckQueryString(query)
    Debug.Print res
    rec.Open res, db, adOpenStatic, adLockReadOnly
    Set DBExecute = rec
End Function

Function CheckQueryString(query As String) As String
    Dim Result As String
    Dim i As Integer
    Dim ii As Integer
    Dim index As Integer
    Dim endIndex As Integer
    Dim flag As Integer
    Dim endOfStr As Boolean
    
    Result = query
    flag = -1
    index = 1
    i = 1
    ii = 1
    endIndex = 0
    endOfStr = False
        
    While endOfStr = False
        index = InStr(index, Result, "'", vbBinaryCompare)
        If index = 0 Then
            endOfStr = True
        Else
            If flag = 1 Then
                If (Mid(Result, index + 1, 1) <> ",") And (index <> Len(Result)) And (Mid(Result, index + 1, 1) <> ")") And (Mid(Result, index + 1, 1) <> " ") Then
                        Dim sFinal As String
                        Dim sLeft As String
                        Dim sRight As String
                        sLeft = Left(Result, index)
                        sRight = Right(Result, Len(Result) - index)
                        sFinal = sLeft & "'" & sRight
                        Result = sFinal
                        index = index + 1
                Else
                        flag = 0
                End If
            Else
                flag = 1
            End If
               index = index + 1
        End If
    Wend
    
    CheckQueryString = Result
End Function
