unit Utils;

interface

uses
  SysUtils, IOUtils;

Function GetSamplePath(projectsFolder: String; imageFolder: String): string;

implementation

Function GetSamplePath(projectsFolder: String; imageFolder: String): string;
var
  c: string;
  cName, cRoot: string;
begin
  c := TDirectory.GetCurrentDirectory;
  cName := TPath.GetFileNameWithoutExtension(c);
  cRoot := TPath.GetPathRoot(c);

  while not(CompareText(cName, projectsFolder) = 0) and
    not(CompareText(c, cRoot) = 0) do
  begin
    c := TDirectory.GetParent(c);
    cName := TPath.GetFileNameWithoutExtension(c);
    cRoot := TPath.GetPathRoot(c);
  end;

  if c = TPath.GetPathRoot(c) then
  begin
    GetSamplePath := ''; // Not found
  end
  else
  begin
    GetSamplePath := TPath.Combine(TDirectory.GetParent(c), imageFolder);
  end;

end;

end.
