unit DelphiViewer;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OleCtrls, ToolWin, ComCtrls, Menus, StdCtrls, ComObj,
  Attrib, Spin, Variants, ActiveX, printers, ExtCtrls,
  DicomObjects8_TLB, Vcl.OleServer, Utils;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Edit1: TMenuItem;
    Read1: TMenuItem;
    Write1: TMenuItem;
    Exit1: TMenuItem;
    Remote1: TMenuItem;
    Retrieve1: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    ClearAll1: TMenuItem;
    Rows: TSpinEdit;
    Columns: TSpinEdit;
    Label1: TLabel;
    Label2: TLabel;
    StretchToFit: TCheckBox;
    View1: TMenuItem;
    Attributes1: TMenuItem;
    Current: TSpinEdit;
    Label4: TLabel;
    Width: TTrackBar;
    Level: TTrackBar;
    Label5: TLabel;
    Label6: TLabel;
    Copy1: TMenuItem;
    Viewer: TDicomViewer;
    AttachPresentationState1: TMenuItem;
    Import1: TMenuItem;
    Export1: TMenuItem;
    Paste1: TMenuItem;
    Verify1: TMenuItem;
    SendSelectedImage1: TMenuItem;
    PrintWinows1: TMenuItem;
    PrintDICOM1: TMenuItem;
    PageControl1: TPageControl;
    TabSheet2: TTabSheet;
    Label8: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    PrinterAET: TEdit;
    PrinterPort: TEdit;
    PrinterIP: TEdit;
    PrinterFormat: TEdit;
    PrinterSize: TEdit;
    TabSheet1: TTabSheet;
    Label7: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label3: TLabel;
    LocalAET: TEdit;
    RemoteAET: TEdit;
    RemotePort: TEdit;
    RemoteIP: TEdit;
    LocalPort: TEdit;
    RetrievalType: TRadioGroup;
    StudyRoot: TCheckBox;
    Logging1: TMenuItem;
    EnableLogging1: TMenuItem;
    LogLevel1: TMenuItem;
    LogDirectory1: TMenuItem;
    Help1: TMenuItem;
    AboutDicomObjects1: TMenuItem;
    MultiframeCine1: TMenuItem;
    ForwardContinuous1: TMenuItem;
    Reverse1: TMenuItem;
    Oscilate1: TMenuItem;
    Stop1: TMenuItem;
    DicomServer1: TDicomServer;
    procedure FormCreate(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Read1Click(Sender: TObject);
    procedure Write1Click(Sender: TObject);
    procedure ClearAll1Click(Sender: TObject);
    procedure RowsChange(Sender: TObject);
    procedure ColumnsChange(Sender: TObject);
    procedure StretchToFitClick(Sender: TObject);
    procedure Attributes1Click(Sender: TObject);
    procedure Cine1Click(Sender: TObject);
    procedure CurrentChange(Sender: TObject);
    procedure ViewerDataChanged(Sender: TObject);
    procedure WidthChange(Sender: TObject);
    procedure LevelChange(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure AttachPresentationState1Click(Sender: TObject);
    procedure Import1Click(Sender: TObject);
    procedure Export1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure PrintWinows1Click(Sender: TObject);
    procedure Retrieve1Click(Sender: TObject);
    procedure PrintDICOM1Click(Sender: TObject);
    procedure Verify1Click(Sender: TObject);
    procedure EnableLogging1Click(Sender: TObject);
    procedure LogLevel1Click(Sender: TObject);
    procedure LogDirectory1Click(Sender: TObject);
    procedure RetrievalTypeClick(Sender: TObject);
    procedure AboutDicomObjects1Click(Sender: TObject);
    procedure SendSelectedImage1Click(Sender: TObject);
    procedure ForwardContinuous1Click(Sender: TObject);
    procedure Reverse1Click(Sender: TObject);
    procedure Oscilate1Click(Sender: TObject);
    procedure Stop1Click(Sender: TObject);
    procedure DicomServer1InstanceReceived(ASender: TObject;
      const Connection: IDicomConnection; const dataset: IDicomDataSet);
    procedure DicomServer1AssociationRequest(ASender: TObject;
      const Connection: IDicomConnection; var isOK: WordBool);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses QRUnit;

// uses Attrib;

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
var
  dg : DicomGlobal;
begin
  dg := CoDicomGlobal.Create;
  dg.SetDLLDirectory;
  DicomServer1.Listen(11112);
end;

procedure TMainForm.Exit1Click(Sender: TObject);
begin
  MainForm.close
end;

procedure TMainForm.Read1Click(Sender: TObject);
var
  Images: DicomImages;
  samplePath: string;
begin
  try
    Images := Viewer.Images;
    samplePath := GetSamplePath('SampleProjects','SampleImages/2D');
    OpenDialog1.InitialDir := samplePath;
    if(OpenDialog1.Execute)then
    begin
      Images.ReadFile(OpenDialog1.Files[0]);
    end;
  except
    on e: EOleException do
    begin
      MessageDlg('Trapped error number ' + e.message, mtConfirmation,
        mbYesNoCancel, 0);
    end
  end
end;

procedure TMainForm.Write1Click(Sender: TObject);
var
  Image: DicomImage;
begin
  SaveDialog1.Execute;
  Image := Viewer.CurrentImage;
  Image.WriteFile(SaveDialog1.Files[0], FALSE, NULL, NULL);
end;

procedure TMainForm.ClearAll1Click(Sender: TObject);
begin
  Viewer.Images.Clear;
end;

procedure TMainForm.RowsChange(Sender: TObject);
begin
  Viewer.MultiRows := Rows.Value;
end;

procedure TMainForm.ColumnsChange(Sender: TObject);
begin
  Viewer.MultiColumns := Columns.Value;
end;

procedure TMainForm.StretchToFitClick(Sender: TObject);
begin

  if StretchToFit.State = cbChecked then
  begin
    Viewer.CurrentImage.StretchMode := StretchCentred;
  end
  else
  begin
    Viewer.CurrentImage.StretchMode := StretchTopLeft;
  end;

end;

procedure DoAttributes(Attributes: DicomAttributes; prefix: string;
  control: TMemo);

var
  at: DicomAttribute;
  seq: DicomDataSets;
  s: DicomDataSets;
  i, ii: Integer;
  v, v1: Variant;
  ss: string;
begin
  For ii := 1 to Attributes.count do
  begin
    at := Attributes.ItemByIndex[ii];
    control.text := control.text + prefix + '(' + IntToHex(at.Group, 4) + ',' +
      IntToHex(at.Element, 4) + ') : ';
    control.text := control.text +
      Copy(at.Description + '                              ', 0, 30);
    If at.Group = $7FE0 Then // pixel data
      control.text := control.text + 'Pixel data'#13#10
    Else If (VarType(at.Value) = 9) Then // i.e. a sequence
    begin
      s := DicomDataSets(IDispatch(at.Value));
      Str(s.count, ss);
      control.text := control.text + 'Sequence of ' + ss + ' items:' + #13#10;
      seq := DicomDataSets(IDispatch(s));
      For i := 1 To seq.count do
      begin
        control.text := control.text + prefix + '>---------------'#13#10;
        DoAttributes(DicomAttributes(DicomDataSet(seq[i]).Attributes),
          prefix + '>', control);
      end;
      control.text := control.text + prefix + '>---------------'#13#10;
    end
    Else
    begin
      v := at.Value; // could be variant or array
      If (VarType(v) > 8192) then // i.e. an array
      begin
        control.text := control.text + 'Multiple values :' + #13#10 +
          '              ';
        For i := VarArrayLowBound(v, 1) To VarArrayHighBound(v, 1) do
        begin
          v1 := Variant(v[i]);
          varcast(v1, v1, 8);
          control.text := control.text + v1;
          If i <> VarArrayHighBound(v, 1) Then
            control.text := control.text + ' : ';
        end;
        control.text := control.text + #13#10;
      end
      else if VarType(v) = 1 then
        control.text := control.text + 'NULL'#13#10
      else
      begin
        varcast(v, v, 8);
        control.text := control.text + v + #13#10;
      end
    end;
  end;

end;

procedure TMainForm.Attributes1Click(Sender: TObject);
var
  Image: DicomImage;
  Attributes: DicomAttributes;
begin
  Image := Viewer.CurrentImage;
  if Image = nil then
    exit;
  Attributes := Image.Attributes;
  Attrib.Attribform.show;
  Attrib.Attribform.Memo1.text := '';
  DoAttributes(Attributes, '', Attrib.Attribform.Memo1);
end;

procedure TMainForm.Cine1Click(Sender: TObject);

begin
  Viewer.CurrentImage.CineMode := doCineRepeat;
end;

procedure TMainForm.CurrentChange(Sender: TObject);
var
  ims: DicomImages;
begin
  if Current.Value > Current.maxvalue then
    Current.Value := Current.maxvalue;
  if Current.Value < Current.MinValue then
    Current.Value := Current.MinValue;

  ims := Viewer.Images;
  if ims.count > 0 then
    Viewer.CurrentIndex := Current.Value
  else
    Current.Value := 0;
end;

procedure TMainForm.DicomServer1AssociationRequest(ASender: TObject;
  const Connection: IDicomConnection; var isOK: WordBool);
var
  i, i2: Integer;
  context: DicomContext;
  abst: String;
begin
  // Reject any non-DICOM SOP classes
  for i := 1 to 128 do
  begin
    i2 := i * 2 - 1;
    if Connection.Contexts.Exists[i2] then
    begin
      context := Connection.Contexts.Item[i2];
      abst := context.AbstractSyntax;
      if Copy(abst, 0, 14) <> '1.2.840.10008.' then
        context.Reject(3);
    end;
  end;
end;

procedure TMainForm.DicomServer1InstanceReceived(ASender: TObject;
  const Connection: IDicomConnection; const dataset: IDicomDataSet);
begin
  { Load Instance into viewer. }
  Viewer.Images.Add(dataset);
  Connection.SendStatus(0);
end;

procedure TMainForm.ViewerDataChanged(Sender: TObject);
var
  ims: DicomImages;
  im: DicomImage;
begin
  ims := Viewer.Images;
  if ims.count > 0 then
  begin
    Current.MinValue := 1;
    Current.maxvalue := ims.count;
    im := DicomImage(Viewer.CurrentImage);
    Width.Position := Round(im.Width);
    Level.Position := Round(im.Level);
  end
  else
  begin
    Current.MinValue := 0;
    Current.maxvalue := 0;
    Current.Value := 0;
  end;
  Current.Value := Viewer.CurrentIndex;
end;

procedure TMainForm.WidthChange(Sender: TObject);
var
  Image: DicomImage;
  Images: DicomImages;
begin
  Image := Viewer.CurrentImage;
  Images := Viewer.Images;
  if Images.count > 0 then
    Image.Width := Width.Position;
end;

procedure TMainForm.LevelChange(Sender: TObject);
var
  Image: DicomImage;
  Images: DicomImages;
begin
  Image := Viewer.CurrentImage;
  Images := Viewer.Images;
  if Images.count > 0 then
    Image.Level := Level.Position;
end;

procedure TMainForm.Copy1Click(Sender: TObject);
var
  Image: DicomImage;
begin
  Image := Viewer.CurrentImage;
  Image.Copy;
end;

procedure TMainForm.AttachPresentationState1Click(Sender: TObject);

var
  ds: DicomDataSets;
  Image: DicomImage;
  samplePath: string;
begin
  ds := CoDicomDataSets.Create;
  samplePath := GetSamplePath('SampleProjects','SampleImages/2D');
  OpenDialog1.InitialDir := samplePath;
  OpenDialog1.Execute;
  Image := Viewer.CurrentImage;
  Image.PresentationState := ds.ReadFile(OpenDialog1.Files[0]);
end;

procedure TMainForm.Import1Click(Sender: TObject);
var
  Image: DicomImage;
begin
  Image := CoDicomImage.Create;
  OpenDialog1.Execute;
  Image.FileImport(OpenDialog1.FileName, '', 0);
  Viewer.Images.Add(Image);

end;

procedure TMainForm.Export1Click(Sender: TObject);
var
  Image: DicomImage;
begin
  Image := Viewer.CurrentImage;
  SaveDialog1.Execute;
  Image.FileExport(SaveDialog1.FileName, '', 95);
end;

procedure TMainForm.Paste1Click(Sender: TObject);
var
  Image: DicomImage;
begin
  Image := CoDicomImage.Create;
  Image.Paste;
  Viewer.Images.Add(Image);
end;

procedure TMainForm.PrintWinows1Click(Sender: TObject);
var
  picture: IPicture;
  Image: DicomImage;
  x1, y1: Integer;
  r: TRect;
  f, f1, f2: real;
begin
  Image := Viewer.CurrentImage;
  picture := Image.picture;
  picture.get_width(x1);
  picture.get_height(y1);
  f1 := Printer.Pagewidth - 200;
  f1 := f1 / x1;
  f2 := Printer.PageHeight - 200;
  f2 := f2 / y1;
  if f1 > f2 then
    f := f2
  else
    f := f1;
  r := Classes.Rect(100, 100, 100 + Trunc(x1 * f), 100 + Trunc(y1 * f));
  Printer.BeginDoc;
  picture.Render(Printer.Canvas.handle, r.Left, r.Top, r.Right - r.Left,
    r.Bottom - r.Top, 0, y1, x1, -y1, r);

  Printer.EndDoc;
end;

procedure TMainForm.Retrieve1Click(Sender: TObject);
begin
  QRForm.show();
end;

procedure TMainForm.PrintDICOM1Click(Sender: TObject);
var
  Printer: DicomPrint;
  port, code: Integer;
  i: Integer;
begin

  Printer := CoDicomPrint.Create(); // ('DicomObjects.DicomPrint');

  Printer.Node := WideString(PrinterIP.text);
  Val(PrinterPort.text, port, code);
  Printer.port := port;
  Printer.CalledAE := WideString(PrinterAET.text);
  Printer.CallingAE := WideString(LocalAET.text);
  Printer.Open();

  Printer.Format := WideString(PrinterFormat.text);
  Printer.Orientation := WideString('PORTRAIT');
  Printer.FilmSize := WideString(PrinterSize.text);

  for i := 1 to Viewer.Images.count do
  begin
    Printer.PrintImage(Viewer.Images[Variant(i)], FALSE, true);
  end;
  Printer.close();
end;

procedure TMainForm.Verify1Click(Sender: TObject);
var
  global: DicomGlobal;
  result: Integer;
  port, code: Integer;
begin
  global := CoDicomGlobal.Create();
  result := -1;
  Val(RemotePort.text, port, code);
  result := global.Echo(WideString(RemoteIP.text), port,
    WideString(LocalAET.text), WideString(RemoteAET.text));

  if result = 0 then
    Application.MessageBox('Verify Succeeded', 'C-ECHO', MB_OK)
  else
    Application.MessageBox('Verify Failed', 'C-ECHO', MB_OK);
end;

procedure TMainForm.EnableLogging1Click(Sender: TObject);
var
  global: DicomGlobal;
begin
  global := CoDicomGlobal.Create();
  if EnableLogging1.checked then
    global.RegWord['Log'] := 1
  else
    global.RegWord['Log'] := 0;
end;

procedure TMainForm.LogLevel1Click(Sender: TObject);
var
  global: DicomGlobal;
  Value, Status: Integer;
begin
  global := CoDicomGlobal.Create();
  Val(InputBox('Logging', '"Enter log level in decimal (63 is "normal")', '63'),
    Value, Status);
  global.RegWord['LogLevel'] := Value;

end;

procedure TMainForm.LogDirectory1Click(Sender: TObject);
var
  global: DicomGlobal;
begin
  global := CoDicomGlobal.Create();
  global.RegString['LogLocation'] :=
    InputBox('Logging', 'Enter log directory', 'C:\');
end;

procedure TMainForm.RetrievalTypeClick(Sender: TObject);
var
  s: String;
begin
  if RetrievalType.ItemIndex >= 1 then
  begin
    s := 'You have requested use of a C-MOVE operation.  Please note that this can ONLY work if the SCP has been set up to "know" your AET title, and to associate it with your IP address and listening port.  ';
    s := s + 'If the supplied Access server is running on the same machine, then this is OK, as it associates LOCAL = localhost/1111, ';
    s := s + 'but if using another server, then this information MUST be set up on that server, as the DICOM C-MOVE protocol allows no method of specifying the destination other than the AE title.';;
    Application.MessageBox(PChar(s), 'C-MOVE warning', MB_OK);
  end;

end;

procedure TMainForm.AboutDicomObjects1Click(Sender: TObject);
begin
  Viewer.AboutBox;
end;

procedure TMainForm.SendSelectedImage1Click(Sender: TObject);
var
  result: Integer;
  port, code: Integer;
begin
  if Viewer.Images.count > 0 then
  begin
    result := -1;
    Val(RemotePort.text, port, code);
    result := Viewer.CurrentImage.Send(WideString(RemoteIP.text), port,
      WideString(LocalAET.text), WideString(RemoteAET.text));
    if result = 0 then
      Application.MessageBox('Send Current Image Succeeded',
        'Send Current Image', MB_OK)
    else
      Application.MessageBox('Send Current Image', 'Send Current Image', MB_OK);
  end
  else
  begin
    Application.MessageBox('No Image to Send', 'Send Current Image', MB_OK);
  end;
end;

procedure TMainForm.ForwardContinuous1Click(Sender: TObject);
begin
  Viewer.CurrentImage.CineMode := doCineRepeat;
end;

procedure TMainForm.Reverse1Click(Sender: TObject);
begin
  Viewer.CurrentImage.CineMode := doCineReverse;
end;

procedure TMainForm.Oscilate1Click(Sender: TObject);
begin
  Viewer.CurrentImage.CineMode := doCineOscillate;
end;

procedure TMainForm.Stop1Click(Sender: TObject);
begin
  Viewer.CurrentImage.CineMode := doCineStatic;
end;

end.
