# Modality Worklist

## Prerequisites
Before running the project, ensure that the following software is installed on your machine:

1. **Microsoft SQL Server**
2. **SQL Server Management Studio (SSMS)**

## Steps to Run the Program

### 1. Install or Confirm the Installation of MS SQL Server and SSMS

Ensure that both **Microsoft SQL Server** and **SQL Server Management Studio (SSMS)** are installed on your machine.

---

### 2. Import the `MWLDB.mdf` File into the SQL Server Database

The database file `MWLDB.mdf` is located in the **SCP** project directory. You need to import this `.mdf` file into your SQL Server instance.

#### Steps to Import the Database:

1. Open **SQL Server Management Studio (SSMS)**.
2. Connect to your local SQL Server instance.
3. In **Object Explorer**, right-click the **Databases** folder and choose **Attach...**.
4. In the **Attach Databases** window, click **Add**.
5. Browse to the `SCP` directory in your project folder and select the `MWLDB.mdf` file.
6. **Important**: If you see an associated `.ldf` (log file) listed that does not exist, remove it by selecting the row and clicking **Remove**.
7. Click **OK** to complete the import process.

---

### 3. Update the Connection String in `SCP\Program.cs`

After importing the database, you need to update the connection string in the `SCP\Program.cs` file to point to your local SQL Server instance.

#### Steps to Update the Connection String:

1. Open the project in your development environment (e.g., Visual Studio).
2. Navigate to the `SCP\Program.cs` file.
3. Locate the section of code that defines the `CONNECTION_STRING`. It should look something like this:

    ```csharp
    const string CONNECTION_STRING = @"Server=.\SQLEXPRESS;Database=MWLDB;Trusted_Connection=True;";
    ```

4. Modify the `Data Source` to match your SQL Server instance name. 

5. Save the changes.

---

### 4. Run the Program

Once the database is set up and the connection string is configured, run both the `SCP` and `SCU` projects simultaneously.


---

