﻿using DicomObjects;
using DicomObjects.Enums;
using DicomObjects.UIDs;
using System;

namespace SCU
{
    class Program
    {
        private const string PressIToSendMPPSMEssage = "Press i to send a 'In-progress' MPPS message to SCP, or";
        private const string PressCToSendCompleteMessage = "Press c to send a 'Complete' MPPS message to SCP, or";
        private const string PressEnterForExit = "Press [Enter] = exit";
        private const string InvalidCharacter = "Invalid character, please press c, i or enter to exit";

        private const string PatientName = "Bloggs^Joe";
        private const string PatientId = "ID1";
        private const string Gender = "M";
        private const string DateOfBirth = "1962/12/31";
        private const string AccessionNumber = "12345";
        private const string RequestedProcedureID = "REQ_ID1";
        private const string RequestedProcedureDescription = "Requested Procedure Description";
        private const string ScheduledProcedureStepId = "STEP_ID1";
        private const string ScheduledProcedureStepDescription = "Scheduled Procedure Step Description";
        private const string PerformedStationAETitle = "AETitle";
        private const string PerformedStationName = "Station Name";
        private const string PerformedLocation = "Location";
        private const string PerformedProcedureStepID = "1";
        private const string PerformedProcedureStepDescription = "Performed Procedure Step Description";
        private const string PerformedProcedureTypeDescription = "Performed Procedure Type Description";
        private const string Modality = "CT";
        private const string StudyId = "ID1";
        private const string Node = "localhost";
        private const string CallingAE = "CALLING_AE";
        private const string CalledAE = "CALLED_AE";
        private const int Port = 104;
        private const string InProgress = "IN PROGRESS";
        private const string SucceededMessage = "SendComplete - Succeeded";
        private const string PerformedActionCodeValue = "PAI-1";
        private const string PerformedActionCodingSchemeDesignator = "DCMOBJ";
        private const string PerformedActionCodeMeaning = "Performed Action Item 1";
        private const string ProcedureCodeValue = "PC-1";
        private const string ProcedureCodingSchemeDesignator = "DCMOBJ";
        private const string ProcedureCodeMeaning = "Procedure Code 1";
        private const string PerformedProcedureStepStatus = "COMPLETED";

        static void Main(string[] args)
        {
            Console.WriteLine(PressIToSendMPPSMEssage);
            Console.WriteLine(PressCToSendCompleteMessage);
            Console.WriteLine(PressEnterForExit);
            do
            {
                string UID = DicomGlobal.NewUID();

                var key = Console.ReadKey().Key;

                if (key == ConsoleKey.Enter)
                    return;

                if (key == ConsoleKey.I || key == ConsoleKey.C)
                {                    
                    if (key == ConsoleKey.I)
                    {
                        Console.WriteLine("");
                        SendInProgress(UID);
                    }
                    else
                    {
                        Console.WriteLine("");
                        SendComplete(UID);
                    }
                }
                else
                    Console.WriteLine(InvalidCharacter);
            }
            while (true);
        }

        private static void SendInProgress(string UID)
        {
            DicomDataSetCollection emptydss = new DicomDataSetCollection();
            DicomDataSet ds;
            DicomAssociation cn = new DicomAssociation();            
            
            ds = MakeBaseDataSet();

            try
            {
                cn.RequestedContexts.Add(SOPClasses.ModalityPerformedProcedureStep);
                cn.Open(Node, Port, CallingAE, CalledAE);

                //following sequences are blank at this stage (filled in when MPPS complete)
                // but they must still be present

                ds.Add(Keyword.PerformedProtocolCodeSequence, emptydss);
                ds.Add(Keyword.ProcedureCodeSequence, emptydss);
                ds.Add(Keyword.PerformedSeriesSequence, emptydss);
                ds.Add(Keyword.PerformedProcedureStepStatus, InProgress);
                cn.NCreate(SOPClasses.ModalityPerformedProcedureStep, UID, ds);

                if (cn.LastStatus == 0)
                    Console.WriteLine(SucceededMessage);

                cn.Close();
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }

        private static void SendComplete(string UID)
        {
            DicomDataSet ds;
            DicomDataSetCollection emptydss = new DicomDataSetCollection();
            DicomAssociation cn = new DicomAssociation();
            DicomDataSet procedureCode = new DicomDataSet();
            DicomDataSetCollection procedureCodeSQ = new DicomDataSetCollection();
            DicomDataSet protocalCode = new DicomDataSet();
            DicomDataSetCollection performedProtocalCodeSQ = new DicomDataSetCollection();
            try
            {
                ds = MakeBaseDataSet();
                cn.RequestedContexts.Add(SOPClasses.ModalityPerformedProcedureStep);
                cn.Open(Node, Port, CallingAE, CalledAE);

                // These code values are arbitrary, and would be mapped to local/defined codes for real use
                // There is scope for adding more detail of the examination here if required -
                // - see the DICOM standard for details

                // Performed Action Item Sequence
                protocalCode.Add(Keyword.CodeValue, PerformedActionCodeValue);
                protocalCode.Add(Keyword.CodingSchemeDesignator, PerformedActionCodingSchemeDesignator);
                protocalCode.Add(Keyword.CodeMeaning, PerformedActionCodeMeaning);
                performedProtocalCodeSQ.Add(protocalCode);
                ds.Add(Keyword.PerformedProtocolCodeSequence, performedProtocalCodeSQ);

                // Procedure Code Sequence
                procedureCode.Add(Keyword.CodeValue, ProcedureCodeValue);
                procedureCode.Add(Keyword.CodingSchemeDesignator, ProcedureCodingSchemeDesignator);
                procedureCode.Add(Keyword.CodeMeaning, ProcedureCodeMeaning);
                procedureCodeSQ.Add(procedureCode);
                ds.Add(Keyword.ProcedureCodeSequence, procedureCodeSQ);

                ds.Add(Keyword.PerformedSeriesSequence, emptydss);
                ds.Add(Keyword.PerformedProcedureStepStatus, PerformedProcedureStepStatus);

                cn.NSet(SOPClasses.ModalityPerformedProcedureStep, UID, ds);

                if (cn.LastStatus == 0)
                   Console.WriteLine(SucceededMessage);
                cn.Close();
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }

        private static DicomDataSet MakeBaseDataSet()
        {
            DicomDataSet ds = new DicomDataSet();
            var emptydss = new DicomDataSetCollection();

            //set up procedure  details
            ds.Name = PatientName;
            ds.PatientID = PatientId;
            ds.Sex = Gender;
            ds.DateOfBirth = Convert.ToDateTime(DateOfBirth);

            //Patient
            ds.Add(Keyword.ReferencedPatientSequence, emptydss);

            //This has basically the info returend in 0040,0100 from MWL
            DicomDataSetCollection dds = new DicomDataSetCollection();
            DicomDataSet ds1 = new DicomDataSet { StudyUID = DicomGlobal.NewUID() };
            ds1.Add(Keyword.ReferencedStudySequence, emptydss);
            ds1.Add(Keyword.AccessionNumber, AccessionNumber);
            ds1.Add(Keyword.RequestedProcedureID, RequestedProcedureID);
            ds1.Add(Keyword.RequestedProcedureDescription, RequestedProcedureDescription);
            ds1.Add(Keyword.ScheduledProcedureStepID, ScheduledProcedureStepId);
            ds1.Add(Keyword.ScheduledProcedureStepDescription, ScheduledProcedureStepDescription);
            ds1.Add(Keyword.ScheduledProtocolCodeSequence, emptydss);

            dds.Add(ds1);
            ds.Add(Keyword.ScheduledStepAttributesSequence, dds);

            ds.Add(Keyword.PerformedStationAETitle, PerformedStationAETitle);
            ds.Add(Keyword.PerformedStationName, PerformedStationName);
            ds.Add(Keyword.PerformedLocation, PerformedLocation);
            ds.Add(Keyword.PerformedProcedureStepStartDate, DateTime.Now);
            ds.Add(Keyword.PerformedProcedureStepStartTime, DateTime.Now);
            ds.Add(Keyword.PerformedProcedureStepID, PerformedProcedureStepID);
            ds.Add(Keyword.PerformedProcedureStepEndDate, "");
            ds.Add(Keyword.PerformedProcedureStepEndTime, "");
            ds.Add(Keyword.PerformedProcedureStepDescription, PerformedProcedureStepDescription);
            ds.Add(Keyword.PerformedProcedureTypeDescription, PerformedProcedureTypeDescription);
            ds.Add(Keyword.Modality,Modality);
            ds.Add(Keyword.StudyID, StudyId);

            return ds;
        }

    }
}
