﻿using System;
using DicomObjects;

namespace DICOMDIRReader
{
    class Program
    {
        static void Main(string[] args)
        {
            DicomDataSet DicomDIR = new DicomDataSet(Properties.Resources.DICOMDIR);

            foreach (DicomDataSet Patient in DicomDIR.Children) // Patient Level
            {
                int ImageCount = 0;
                Console.WriteLine($"======= {Patient.Name} =======");

                foreach (DicomDataSet Study in Patient.Children) // Study Level
                {
                    string studyDescription = !string.IsNullOrEmpty(Study.StudyDescription) ? Study.StudyDescription : "(no study description)";
                    Console.WriteLine($"- Study {studyDescription}");
                    
                    foreach (DicomDataSet Series in Study.Children) // Series Level
                    {
                        string seriesDescription = !string.IsNullOrEmpty(Series.SeriesDescription)? Series.SeriesDescription: "(no series description)";
                        Console.WriteLine($"-- Series {seriesDescription}");
                        foreach (DicomDataSet Image in Series.Children) // Image Level
                        {
                            string[] pathComponents;
                            string ImageFilePath="";
                            pathComponents = (string[])Image[0x4, 0x1500].Value;
                            for (int level = 0; level < pathComponents.GetLength(0); level++)
                            {
                                if (pathComponents[level] != "")
                                    ImageFilePath = $"{ImageFilePath}\\{pathComponents[level]}";
                            }
                            Console.WriteLine($"--- IMAGE {ImageFilePath}");
                            ImageCount++;
                        }
                    }
                }                
                Console.WriteLine($"======= { Patient.Name} ( {ImageCount} Image(s)) =======");
                Console.WriteLine("");
            }

            Console.WriteLine("Press any key to exit");
            Console.ReadKey();
        }
    }
}
