﻿using DicomObjects;
using System.ComponentModel;
using System.Diagnostics;
using System.Runtime.CompilerServices;
using System.Windows.Input;

namespace MauiSampleViewer
{
    public class ViewerOptions : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler? PropertyChanged;

        // General SCP
        private string _generalLocalAETitle = "";

        public string GeneralLocalAETitle
        {
            get => _generalLocalAETitle;
            set
            {
                _generalLocalAETitle = value;
                OnPropertyChanged(nameof(GeneralLocalAETitle));
            }
        }

        private int _generalListenPort = 107;

        public int GeneralListenPort
        {
            get => _generalListenPort;
            set
            {
                _generalListenPort = value;
                OnPropertyChanged(nameof(GeneralListenPort));
            }
        }

        // Storage SCU
        private string _storageRemoteNode = "dicomserver.co.uk";

        public string StorageRemoteNode
        {
            get => _storageRemoteNode;
            set
            {
                _storageRemoteNode = value;
                OnPropertyChanged();
            }
        }

        private int _storageRemotePort = 104;

        public int StorageRemotePort
        {
            get => _storageRemotePort;
            set
            {
                _storageRemotePort = value;
                OnPropertyChanged();
            }
        }

        private string _storageAEName = "Remote_AE";

        public string StorageAEName
        {
            get => _storageAEName;
            set
            {
                _storageAEName = value;
                OnPropertyChanged();
            }
        }

        // Query SCU
        private string _queryRemoteNode = "dicomserver.co.uk";

        public string QueryRemoteNode
        {
            get => _queryRemoteNode;
            set
            {
                _queryRemoteNode = value;
                OnPropertyChanged();
            }
        }

        private int _queryRemotePort = 104;

        public int QueryRemotePort
        {
            get => _queryRemotePort;
            set
            {
                _queryRemotePort = value;
                OnPropertyChanged();
            }
        }

        private string _queryRemoteAE = "Remote_AE";

        public string QueryRemoteAE
        {
            get => _queryRemoteAE;
            set
            {
                _queryRemoteAE = value;
                OnPropertyChanged();
            }
        }

        private string _queryCallingAE = "Viewer";

        public string QueryCallingAE
        {
            get => _queryCallingAE;
            set
            {
                _queryCallingAE = value;
                OnPropertyChanged();
            }
        }

        private string _queryMoveDestination = "LOCAL";

        public string QueryMoveDestination
        {
            get => _queryMoveDestination;
            set
            {
                _queryMoveDestination = value;
                OnPropertyChanged();
            }
        }

        private bool _useCGet = true;

        public bool UseCGet
        {
            get => _useCGet;
            set
            {
                _useCGet = value;
                OnPropertyChanged();
            }
        }

        private bool _useCMove = false;

        public bool UseCMove
        {
            get => _useCMove;
            set
            {
                _useCMove = value;
                OnPropertyChanged();
            }
        }

        private bool _usePatientRoot = true;

        public bool UsePatientRoot
        {
            get => _usePatientRoot;
            set
            {
                _usePatientRoot = value;
                OnPropertyChanged();
            }
        }

        private bool _useStudyRoot = false;

        public bool UseStudyRoot
        {
            get => _useStudyRoot;
            set
            {
                _useStudyRoot = value;
                OnPropertyChanged();
            }
        }

        // MultiColumns and Rows
        public Action<int>? OnMultiRowsChanged { get; set; }
        public Action<int>? OnMultiColumnsChanged { get; set; }

        private int _multiRows = 1;

        public int MultiRows
        {
            get => _multiRows;
            set
            {
                if (_multiRows != value)
                {
                    _multiRows = value;
                    OnPropertyChanged();
                    OnMultiRowsChanged?.Invoke(value);
                }
            }
        }

        private int _multiColumns = 1;

        public int MultiColumns
        {
            get => _multiColumns;
            set
            {
                if (_multiColumns != value)
                {
                    _multiColumns = value;
                    OnPropertyChanged();
                    OnMultiColumnsChanged?.Invoke(value);
                }
            }
        }

        // Printing
        private string _printerNodeName = "localhost";

        public string PrinterNodeName
        {
            get => _printerNodeName;
            set
            {
                _printerNodeName = value;
                OnPropertyChanged();
            }
        }

        private int _printerPort = 104;

        public int PrinterPort
        {
            get => _printerPort;
            set
            {
                _printerPort = value;
                OnPropertyChanged();
            }
        }

        private string _printerAEName = "PrinterAE";

        public string PrinterAEName
        {
            get => _printerAEName;
            set
            {
                _printerAEName = value;
                OnPropertyChanged();
            }
        }

        private string _printerClientAEName = "PrintClientAE";

        public string PrinterClientAEName
        {
            get => _printerClientAEName;
            set
            {
                _printerClientAEName = value;
                OnPropertyChanged();
            }
        }

        private bool _printInColour = false;

        public bool PrintInColour
        {
            get => _printInColour;
            set
            {
                _printInColour = value;
                OnPropertyChanged();
            }
        }

        private string _selectedPrintFormat = "STANDARD\\1,1";

        public string SelectedPrintFormat
        {
            get => _selectedPrintFormat;
            set
            {
                _selectedPrintFormat = value;
                OnPropertyChanged();
            }
        }

        private string _selectedOrientation = "PORTRAIT";

        public string SelectedOrientation
        {
            get => _selectedOrientation;
            set
            {
                _selectedOrientation = value;
                OnPropertyChanged();
            }
        }

        private string _selectedFilmSize = "8INX10IN";

        public string SelectedFilmSize
        {
            get => _selectedFilmSize;
            set
            {
                _selectedFilmSize = value;
                OnPropertyChanged();
            }
        }

        private string _selectedMagnification = "NONE";

        public string SelectedMagnification
        {
            get => _selectedMagnification;
            set
            {
                _selectedMagnification = value;
                OnPropertyChanged();
            }
        }


        // Logging
        private string _logPath = @"C:\Dicom Log Files\";

        public string LogPath
        {
            get => _logPath;
            set
            {
                _logPath = value;
                OnPropertyChanged();
            }
        }

        private string _selectedLogLevel = "Errors & Main Events Only (0x7)";

        public string SelectedLogLevel
        {
            get => _selectedLogLevel;
            set
            {
                _selectedLogLevel = value;
                OnPropertyChanged();
            }
        }

        public ICommand StartLoggingCommand { get; }
        public ICommand StopLoggingCommand { get; }


        // LabelForm Settings

        // Label Type
        private string _labelType = "Rectangle";

        public string LabelType
        {
            get => _labelType;
            set
            {
                if (!string.IsNullOrEmpty(value) && value != _labelType && value != "True" && value != "False")
                {
                    _labelType = value;
                    OnPropertyChanged();
                }
            }
        }

        // Tied To
        private string _tiedTo = "Image";

        public string TiedTo
        {
            get => _tiedTo;
            set
            {
                if (!string.IsNullOrEmpty(value) && value != _labelType && value != "True" && value != "False")
                {
                    _tiedTo = value;
                    OnPropertyChanged();
                }
            }
        }

        // Other fields
        private bool _isLabelTransparent = true;

        public bool IsLabelTransparent
        {
            get => _isLabelTransparent;
            set
            {
                _isLabelTransparent = value;
                OnPropertyChanged();
            }
        }

        private int _labelLineWidth = 1;

        public int LabelLineWidth
        {
            get => _labelLineWidth;
            set
            {
                _labelLineWidth = value;
                OnPropertyChanged();
            }
        }

        private string _labelFont = "Arial";

        public string LabelFont
        {
            get => _labelFont;
            set
            {
                _labelFont = value;
                OnPropertyChanged();
            }
        }

        private string _foreColorHex = "#FF0000";

        public string LabelForeColorHex
        {
            get => _foreColorHex;
            set
            {
                _foreColorHex = value;
                OnPropertyChanged();
            }
        }

        private string _backColorHex = "#000000";

        public string LabelBackColorHex
        {
            get => _backColorHex;
            set
            {
                _backColorHex = value;
                OnPropertyChanged();
            }
        }

        public DicomViewer? Viewer { get; set; } = null;
        public int CurrentIndex
        {
            get => Viewer?.CurrentIndex ?? 0;
            set
            {
                if (Viewer != null && Viewer.CurrentIndex != value)
                {
                    Viewer.CurrentIndex = value;
                    OnPropertyChanged(); 
                }
            }
        }

        public ViewerOptions()
        {
            StartLoggingCommand = new Command(StartLogging);
            StopLoggingCommand = new Command(StopLogging);
        }

        private void StartLogging()
        {
            int logLevel = SelectedLogLevel switch
            {
                "Errors & Main Events Only (0x7)" => 0x7,
                "Most Data (0x3F)" => 0x3F,
                "Full Log (0x3FF)" => 0x3FF,
                _ => 0x7
            };

            try
            {
                DicomGlobal.LogToFile(LogPath, logLevel);
            }
            catch (Exception ex)
            {
#if DEBUG
                Debug.WriteLine($"StartLogging failed: {ex}");
#endif
            }
        }

        private void StopLogging()
        {
            try
            {
                DicomGlobal.LogToFileStop();
            }
            catch (Exception ex)
            {
#if DEBUG
                Debug.WriteLine($"StopLogging failed: {ex}");
#endif
            }
        }

        private void OnPropertyChanged([CallerMemberName] string? name = null)
            => PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(name));
    }
}