﻿using DicomObjects;
using Microsoft.Maui.Handlers;
using Microsoft.UI.Xaml.Input;
using SkiaSharp.Views.Maui;
using SkiaSharp.Views.Maui.Controls;
using SkiaSharp.Views.Maui.Handlers;
using SkiaSharp.Views.Windows;

namespace MauiSampleViewer.Platforms
{
    public partial class DicomViewerHandler : SKCanvasViewHandler
    {
        protected override void ConnectHandler(SKXamlCanvas platformView)
        {
            base.ConnectHandler(platformView);

            if (VirtualView is not DicomViewer dicomViewer)
                return;

            platformView.PointerWheelChanged += (s, e) =>
            {
                if (MainPage.Instance == null || MainPage.Instance.GetSelectedImage() == null)
                    return;

                int delta = e.GetCurrentPoint(null).Properties.MouseWheelDelta;
                var selectedImage = MainPage.Instance.GetSelectedImage();
                var Viewer = (DicomViewer)VirtualView;

                switch (GetWheelFunction(selectedImage))
                {
                    case WheelFunction.NextImage:
                        MainPage.Instance.CurrentIndex = Math.Clamp(MainPage.Instance.CurrentIndex + Math.Sign(delta), 0, MainPage.Instance.Images.Count - 1);
                        break;

                    case WheelFunction.Cine:
                        selectedImage.Frame = Math.Clamp(selectedImage.Frame + Math.Sign(delta), 1, selectedImage.FrameCount);
                        break;
                }

                Viewer.Refresh();
                // No need to manually update zoom and the current frame index label if LabelType.Formatted is used to display them
                e.Handled = true;
            };
        }

        public enum WheelFunction
        {
            Volume,
            Cine,
            NextImage
        }

        private static WheelFunction GetWheelFunction(DicomImage selectedImage)
        {
            if (selectedImage?.FrameCount > 1)
                return WheelFunction.Cine;

            return WheelFunction.NextImage;
        }
    }
}