# Dicom Server

## Prerequisites
1. **Microsoft SQL Server**
2. **SQL Server Management Studio (SSMS)**

## Steps to Run the Program
### 1. Install or Confirm the Installation of MS SQL Server and SSMS

Ensure that both **Microsoft SQL Server** and **SQL Server Management Studio (SSMS)** are installed on your machine.

---

### 2. Import the `DicomServerDB.mdf` File

The database file (`DicomServerDB.mdf`) is located in the root directory of the project. You need to import this `.mdf` file into SQL Server using SQL Server Management Studio.

#### Steps to Import the Database:
1. Open **SQL Server Management Studio (SSMS)**.
2. Connect to your local SQL Server instance (e.g., `.\SQLEXPRESS`).
3. In **Object Explorer**, right-click the **Databases** folder and choose **Attach...**.
4. In the **Attach Databases** window, click **Add**.
5. Browse to the project's root directory and select the `DicomServerDB.mdf` file.
6. **Important**: In the **Database details** section, remove the `.ldf` (log file) row. This file is not exist and can cause errors if not removed.
7. Click **OK** to complete the import process.

---

### 3. Update the Program's Connection String

Once the database is imported, update the program's connection string to point to the SQL Server instance.

#### Steps to Update the Connection String:
1. Open the project in your development environment.
2. Locate the `appsettings.json` file.
3. Find the following line:

    ```json
    "localServerDB": "Data Source=.\\SQLEXPRESS;Initial Catalog=DicomServerDB;Integrated Security=True;MultipleActiveResultSets=True"
    ```

4. Ensure that the connection string is correct for your local SQL Server instance. If needed, adjust the instance name and database name.
   
5. Save the changes.

---

### 4. Run the Program

Once the database is set up and the connection string is configured:

1. Build and run the program using your development environment (e.g., Visual Studio).
2. The program should now connect to the `DicomServerDB` database and function as expected.

