﻿using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Logging;
using System;
using System.Data.SqlClient;

namespace DicomServer.Core
{
    internal class Program
    {
        private const string AppsettingsFile = "appsettings.json";
        private const string ConnectionString = "ConnectionStrings:localServerDB";
        private const string PressAnyKey = "Press any key to shut down";

        protected Program() { }
        static void Main(string[] args)
        {
            var serviceCollection = new ServiceCollection();

            serviceCollection.AddLogging(configure => configure.AddConsole());

            // Register the MainServer class with dependency injection
            serviceCollection.AddSingleton<MainServer>();

            var serviceProvider = serviceCollection.BuildServiceProvider();

            var logger = serviceProvider.GetRequiredService<ILogger<Program>>();

            IConfiguration config = new ConfigurationBuilder()
                  .AddJsonFile(AppsettingsFile)
                  .Build();

            var mainServer = serviceProvider.GetRequiredService<MainServer>();

            string connectionString = config[ConnectionString];
            using SqlConnection connection = new SqlConnection(connectionString);
            connection.Open();
            mainServer.Startup(connection);

            Console.WriteLine(PressAnyKey);
            Console.ReadLine();
        }
    }
}
